/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

public final class BackpressureHelper {
    private BackpressureHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static long addCap(long a2, long b2) {
        long u2 = a2 + b2;
        if (u2 < 0L) {
            return Long.MAX_VALUE;
        }
        return u2;
    }

    public static long multiplyCap(long a2, long b2) {
        long u2 = a2 * b2;
        if ((a2 | b2) >>> 31 != 0L && u2 / a2 != b2) {
            return Long.MAX_VALUE;
        }
        return u2;
    }

    public static long add(AtomicLong requested, long n2) {
        long u2;
        long r2;
        do {
            if ((r2 = requested.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r2, u2 = BackpressureHelper.addCap(r2, n2)));
        return r2;
    }

    public static long addCancel(AtomicLong requested, long n2) {
        long u2;
        long r2;
        do {
            if ((r2 = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (r2 != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r2, u2 = BackpressureHelper.addCap(r2, n2)));
        return r2;
    }

    public static long produced(AtomicLong requested, long n2) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n2;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }

    public static long producedCancel(AtomicLong requested, long n2) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            if (current == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n2;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }
}

