/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.util.NotificationLite$DisposableNotification;
import io.reactivex.internal.util.NotificationLite$ErrorNotification;
import io.reactivex.internal.util.NotificationLite$SubscriptionNotification;

public enum NotificationLite {
    COMPLETE;


    public static <T> Object next(T value) {
        return value;
    }

    public static Object complete() {
        return COMPLETE;
    }

    public static Object error(Throwable e2) {
        return new NotificationLite$ErrorNotification(e2);
    }

    public static Object subscription(Yy s2) {
        return new NotificationLite$SubscriptionNotification(s2);
    }

    public static Object disposable(Disposable d2) {
        return new NotificationLite$DisposableNotification(d2);
    }

    public static boolean isComplete(Object o2) {
        return o2 == COMPLETE;
    }

    public static boolean isError(Object o2) {
        return o2 instanceof NotificationLite$ErrorNotification;
    }

    public static boolean isSubscription(Object o2) {
        return o2 instanceof NotificationLite$SubscriptionNotification;
    }

    public static boolean isDisposable(Object o2) {
        return o2 instanceof NotificationLite$DisposableNotification;
    }

    public static <T> T getValue(Object o2) {
        return (T)o2;
    }

    public static Throwable getError(Object o2) {
        return ((NotificationLite$ErrorNotification)o2).e;
    }

    public static Yy getSubscription(Object o2) {
        return ((NotificationLite$SubscriptionNotification)o2).s;
    }

    public static Disposable getDisposable(Object o2) {
        return ((NotificationLite$DisposableNotification)o2).d;
    }

    public static <T> boolean accept(Object o2, Yx<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof NotificationLite$ErrorNotification) {
            s2.onError(((NotificationLite$ErrorNotification)o2).e);
            return true;
        }
        s2.onNext(o2);
        return false;
    }

    public static <T> boolean accept(Object o2, Observer<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof NotificationLite$ErrorNotification) {
            s2.onError(((NotificationLite$ErrorNotification)o2).e);
            return true;
        }
        s2.onNext(o2);
        return false;
    }

    public static <T> boolean acceptFull(Object o2, Yx<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof NotificationLite$ErrorNotification) {
            s2.onError(((NotificationLite$ErrorNotification)o2).e);
            return true;
        }
        if (o2 instanceof NotificationLite$SubscriptionNotification) {
            s2.onSubscribe(((NotificationLite$SubscriptionNotification)o2).s);
            return false;
        }
        s2.onNext(o2);
        return false;
    }

    public static <T> boolean acceptFull(Object o2, Observer<? super T> s2) {
        if (o2 == COMPLETE) {
            s2.onComplete();
            return true;
        }
        if (o2 instanceof NotificationLite$ErrorNotification) {
            s2.onError(((NotificationLite$ErrorNotification)o2).e);
            return true;
        }
        if (o2 instanceof NotificationLite$DisposableNotification) {
            s2.onSubscribe(((NotificationLite$DisposableNotification)o2).d);
            return false;
        }
        s2.onNext(o2);
        return false;
    }

    public String toString() {
        return "NotificationLite.Complete";
    }
}

