/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.internal.util.Pow2;

public final class OpenHashSet<T> {
    private static final int INT_PHI = -1640531527;
    final float loadFactor;
    int mask;
    int size;
    int maxSize;
    T[] keys;

    public OpenHashSet() {
        this(16, 0.75f);
    }

    public OpenHashSet(int capacity) {
        this(capacity, 0.75f);
    }

    public OpenHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int c2 = Pow2.roundToPowerOfTwo(capacity);
        this.mask = c2 - 1;
        this.maxSize = (int)(loadFactor * (float)c2);
        this.keys = new Object[c2];
    }

    public boolean add(T value) {
        T[] a2 = this.keys;
        int m2 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m2;
        T curr = a2[pos];
        if (curr != null) {
            if (curr.equals(value)) {
                return false;
            }
            while ((curr = a2[pos = pos + 1 & m2]) != null) {
                if (!curr.equals(value)) continue;
                return false;
            }
        }
        a2[pos] = value;
        if (++this.size >= this.maxSize) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(T value) {
        T[] a2 = this.keys;
        int m2 = this.mask;
        int pos = OpenHashSet.mix(value.hashCode()) & m2;
        T curr = a2[pos];
        if (curr == null) {
            return false;
        }
        if (curr.equals(value)) {
            return this.removeEntry(pos, a2, m2);
        }
        do {
            if ((curr = a2[pos = pos + 1 & m2]) != null) continue;
            return false;
        } while (!curr.equals(value));
        return this.removeEntry(pos, a2, m2);
    }

    boolean removeEntry(int pos, T[] a2, int m2) {
        --this.size;
        while (true) {
            T curr;
            int last = pos;
            pos = pos + 1 & m2;
            while (true) {
                if ((curr = a2[pos]) == null) {
                    a2[last] = null;
                    return true;
                }
                int slot = OpenHashSet.mix(curr.hashCode()) & m2;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & m2;
            }
            a2[last] = curr;
        }
    }

    void rehash() {
        T[] a2 = this.keys;
        int i2 = a2.length;
        int newCap = i2 << 1;
        int m2 = newCap - 1;
        Object[] b2 = new Object[newCap];
        int j2 = this.size;
        while (j2-- != 0) {
            while (a2[--i2] == null) {
            }
            int pos = OpenHashSet.mix(a2[i2].hashCode()) & m2;
            if (b2[pos] != null) {
                while (b2[pos = pos + 1 & m2] != null) {
                }
            }
            b2[pos] = a2[i2];
        }
        this.mask = m2;
        this.maxSize = (int)((float)newCap * this.loadFactor);
        this.keys = b2;
    }

    static int mix(int x2) {
        int h2 = x2 * -1640531527;
        return h2 ^ h2 >>> 16;
    }

    public Object[] keys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }
}

