/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ObservableQueueDrain;
import io.reactivex.internal.util.QueueDrain;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class QueueDrainHelper {
    static final long COMPLETED_MASK = Long.MIN_VALUE;
    static final long REQUESTED_MASK = Long.MAX_VALUE;

    private QueueDrainHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, U> void drainMaxLoop(SimplePlainQueue<T> q2, Yx<? super U> a2, boolean delayError, Disposable dispose, QueueDrain<T, U> qd2) {
        int missed = 1;
        while (true) {
            boolean empty;
            boolean d2 = qd2.done();
            T v2 = q2.poll();
            boolean bl2 = empty = v2 == null;
            if (QueueDrainHelper.checkTerminated(d2, empty, a2, delayError, q2, qd2)) {
                if (dispose != null) {
                    dispose.dispose();
                }
                return;
            }
            if (!empty) {
                long r2 = qd2.requested();
                if (r2 != 0L) {
                    if (!qd2.accept(a2, v2) || r2 == Long.MAX_VALUE) continue;
                    qd2.produced(1L);
                    continue;
                }
                q2.clear();
                if (dispose != null) {
                    dispose.dispose();
                }
                a2.onError(new MissingBackpressureException("Could not emit value due to lack of requests."));
                return;
            }
            if ((missed = qd2.leave(-missed)) == 0) break;
        }
    }

    public static <T, U> boolean checkTerminated(boolean d2, boolean empty, Yx<?> s2, boolean delayError, SimpleQueue<?> q2, QueueDrain<T, U> qd2) {
        if (qd2.cancelled()) {
            q2.clear();
            return true;
        }
        if (d2) {
            if (delayError) {
                if (empty) {
                    Throwable err = qd2.error();
                    if (err != null) {
                        s2.onError(err);
                    } else {
                        s2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd2.error();
                if (err != null) {
                    q2.clear();
                    s2.onError(err);
                    return true;
                }
                if (empty) {
                    s2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T, U> void drainLoop(SimplePlainQueue<T> q2, Observer<? super U> a2, boolean delayError, Disposable dispose, ObservableQueueDrain<T, U> qd2) {
        int missed = 1;
        block0: do {
            if (QueueDrainHelper.checkTerminated(qd2.done(), q2.isEmpty(), a2, delayError, q2, dispose, qd2)) {
                return;
            }
            while (true) {
                boolean empty;
                boolean d2 = qd2.done();
                T v2 = q2.poll();
                boolean bl2 = empty = v2 == null;
                if (QueueDrainHelper.checkTerminated(d2, empty, a2, delayError, q2, dispose, qd2)) {
                    return;
                }
                if (empty) continue block0;
                qd2.accept(a2, v2);
            }
        } while ((missed = qd2.leave(-missed)) != 0);
    }

    public static <T, U> boolean checkTerminated(boolean d2, boolean empty, Observer<?> s2, boolean delayError, SimpleQueue<?> q2, Disposable disposable, ObservableQueueDrain<T, U> qd2) {
        if (qd2.cancelled()) {
            q2.clear();
            disposable.dispose();
            return true;
        }
        if (d2) {
            if (delayError) {
                if (empty) {
                    Throwable err;
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    if ((err = qd2.error()) != null) {
                        s2.onError(err);
                    } else {
                        s2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable err = qd2.error();
                if (err != null) {
                    q2.clear();
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    s2.onError(err);
                    return true;
                }
                if (empty) {
                    if (disposable != null) {
                        disposable.dispose();
                    }
                    s2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> SimpleQueue<T> createQueue(int capacityHint) {
        if (capacityHint < 0) {
            return new SpscLinkedArrayQueue(-capacityHint);
        }
        return new SpscArrayQueue(capacityHint);
    }

    public static void request(Yy s2, int prefetch) {
        s2.request(prefetch < 0 ? Long.MAX_VALUE : (long)prefetch);
    }

    public static <T> boolean postCompleteRequest(long n2, Yx<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long r0;
        long u2;
        long r2;
        while (!state.compareAndSet(r2 = state.get(), u2 = r2 & Long.MIN_VALUE | BackpressureHelper.addCap(r0 = r2 & Long.MAX_VALUE, n2))) {
        }
        if (r2 == Long.MIN_VALUE) {
            QueueDrainHelper.postCompleteDrain(n2 | Long.MIN_VALUE, actual, queue, state, isCancelled);
            return true;
        }
        return false;
    }

    static boolean isCancelled(BooleanSupplier cancelled) {
        try {
            return cancelled.getAsBoolean();
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            return true;
        }
    }

    static <T> boolean postCompleteDrain(long n2, Yx<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long e2 = n2 & Long.MIN_VALUE;
        while (true) {
            if (e2 != n2) {
                if (QueueDrainHelper.isCancelled(isCancelled)) {
                    return true;
                }
                T t2 = queue.poll();
                if (t2 == null) {
                    actual.onComplete();
                    return true;
                }
                actual.onNext(t2);
                ++e2;
                continue;
            }
            if (QueueDrainHelper.isCancelled(isCancelled)) {
                return true;
            }
            if (queue.isEmpty()) {
                actual.onComplete();
                return true;
            }
            n2 = state.get();
            if (n2 != e2) continue;
            n2 = state.addAndGet(-(e2 & Long.MAX_VALUE));
            if ((n2 & Long.MAX_VALUE) == 0L) {
                return false;
            }
            e2 = n2 & Long.MIN_VALUE;
        }
    }

    public static <T> void postComplete(Yx<? super T> actual, Queue<T> queue, AtomicLong state, BooleanSupplier isCancelled) {
        long u2;
        long r2;
        if (queue.isEmpty()) {
            actual.onComplete();
            return;
        }
        if (QueueDrainHelper.postCompleteDrain(state.get(), actual, queue, state, isCancelled)) {
            return;
        }
        do {
            if (((r2 = state.get()) & Long.MIN_VALUE) == 0L) continue;
            return;
        } while (!state.compareAndSet(r2, u2 = r2 | Long.MIN_VALUE));
        if (r2 != 0L) {
            QueueDrainHelper.postCompleteDrain(u2, actual, queue, state, isCancelled);
        }
    }
}

