/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;

public final class VolatileSizeArrayList<T>
extends AtomicInteger
implements List<T>,
RandomAccess {
    private static final long serialVersionUID = 3972397474470203923L;
    final ArrayList<T> list;

    public VolatileSizeArrayList() {
        this.list = new ArrayList();
    }

    public VolatileSizeArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.get();
    }

    @Override
    public boolean isEmpty() {
        return this.get() == 0;
    }

    @Override
    public boolean contains(Object o2) {
        return this.list.contains(o2);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a2) {
        return this.list.toArray(a2);
    }

    @Override
    public boolean add(T e2) {
        boolean b2 = this.list.add(e2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public boolean remove(Object o2) {
        boolean b2 = this.list.remove(o2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.list.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        boolean b2 = this.list.addAll(c2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c2) {
        boolean b2 = this.list.addAll(index, c2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean b2 = this.list.removeAll(c2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean b2 = this.list.retainAll(c2);
        this.lazySet(this.list.size());
        return b2;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.lazySet(0);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.lazySet(this.list.size());
    }

    @Override
    public T remove(int index) {
        T v2 = this.list.remove(index);
        this.lazySet(this.list.size());
        return v2;
    }

    @Override
    public int indexOf(Object o2) {
        return this.list.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.list.lastIndexOf(o2);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VolatileSizeArrayList) {
            return this.list.equals(((VolatileSizeArrayList)obj).list);
        }
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

