/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Notification;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.VolatileSizeArrayList;
import io.reactivex.observers.BaseTestConsumer$TestWaitStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class BaseTestConsumer<T, U extends BaseTestConsumer<T, U>>
implements Disposable {
    protected final CountDownLatch done;
    protected final List<T> values = new VolatileSizeArrayList();
    protected final List<Throwable> errors = new VolatileSizeArrayList<Throwable>();
    protected long completions;
    protected Thread lastThread;
    protected boolean checkSubscriptionOnce;
    protected int initialFusionMode;
    protected int establishedFusionMode;
    protected CharSequence tag;
    protected boolean timeout;

    public BaseTestConsumer() {
        this.done = new CountDownLatch(1);
    }

    public final Thread lastThread() {
        return this.lastThread;
    }

    public final List<T> values() {
        return this.values;
    }

    public final List<Throwable> errors() {
        return this.errors;
    }

    public final long completions() {
        return this.completions;
    }

    public final boolean isTerminated() {
        return this.done.getCount() == 0L;
    }

    public final int valueCount() {
        return this.values.size();
    }

    public final int errorCount() {
        return this.errors.size();
    }

    protected final AssertionError fail(String message) {
        CharSequence tag;
        StringBuilder b2 = new StringBuilder(64 + message.length());
        b2.append(message);
        b2.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions);
        if (this.timeout) {
            b2.append(", timeout!");
        }
        if (this.isDisposed()) {
            b2.append(", disposed!");
        }
        if ((tag = this.tag) != null) {
            b2.append(", tag = ").append(tag);
        }
        b2.append(')');
        AssertionError ae2 = new AssertionError((Object)b2.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)ae2)).initCause(this.errors.get(0));
            } else {
                CompositeException ce2 = new CompositeException(this.errors);
                ((Throwable)((Object)ae2)).initCause(ce2);
            }
        }
        return ae2;
    }

    public final U await() {
        if (this.done.getCount() == 0L) {
            return (U)this;
        }
        this.done.await();
        return (U)this;
    }

    public final boolean await(long time, TimeUnit unit) {
        boolean d2 = this.done.getCount() == 0L || this.done.await(time, unit);
        this.timeout = !d2;
        return d2;
    }

    public final U assertComplete() {
        long c2 = this.completions;
        if (c2 == 0L) {
            throw this.fail("Not completed");
        }
        if (c2 > 1L) {
            throw this.fail("Multiple completions: " + c2);
        }
        return (U)this;
    }

    public final U assertNotComplete() {
        long c2 = this.completions;
        if (c2 == 1L) {
            throw this.fail("Completed!");
        }
        if (c2 > 1L) {
            throw this.fail("Multiple completions: " + c2);
        }
        return (U)this;
    }

    public final U assertNoErrors() {
        int s2 = this.errors.size();
        if (s2 != 0) {
            throw this.fail("Error(s) present: " + this.errors);
        }
        return (U)this;
    }

    public final U assertError(Throwable error) {
        return this.assertError(Functions.equalsWith(error));
    }

    public final U assertError(Class<? extends Throwable> errorClass) {
        return this.assertError(Functions.isInstanceOf(errorClass));
    }

    public final U assertError(Predicate<Throwable> errorPredicate) {
        int s2 = this.errors.size();
        if (s2 == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e2 : this.errors) {
            try {
                if (!errorPredicate.test(e2)) continue;
                found = true;
                break;
            }
            catch (Exception ex2) {
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if (found) {
            if (s2 != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return (U)this;
    }

    public final U assertValue(T value) {
        int s2 = this.values.size();
        if (s2 != 1) {
            throw this.fail("Expected: " + BaseTestConsumer.valueAndClass(value) + ", Actual: " + this.values);
        }
        T v2 = this.values.get(0);
        if (!ObjectHelper.equals(value, v2)) {
            throw this.fail("Expected: " + BaseTestConsumer.valueAndClass(value) + ", Actual: " + BaseTestConsumer.valueAndClass(v2));
        }
        return (U)this;
    }

    public final U assertNever(T value) {
        int s2 = this.values.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            T v2 = this.values.get(i2);
            if (!ObjectHelper.equals(v2, value)) continue;
            throw this.fail("Value at position " + i2 + " is equal to " + BaseTestConsumer.valueAndClass(value) + "; Expected them to be different");
        }
        return (U)this;
    }

    public final U assertValue(Predicate<T> valuePredicate) {
        this.assertValueAt(0, valuePredicate);
        if (this.values.size() > 1) {
            throw this.fail("Value present but other values as well");
        }
        return (U)this;
    }

    public final U assertNever(Predicate<? super T> valuePredicate) {
        int s2 = this.values.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            T v2 = this.values.get(i2);
            try {
                if (!valuePredicate.test(v2)) continue;
                throw this.fail("Value at position " + i2 + " matches predicate " + valuePredicate.toString() + ", which was not expected.");
            }
            catch (Exception ex2) {
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        return (U)this;
    }

    @Experimental
    public final U assertValueAt(int index, T value) {
        int s2 = this.values.size();
        if (s2 == 0) {
            throw this.fail("No values");
        }
        if (index >= s2) {
            throw this.fail("Invalid index: " + index);
        }
        T v2 = this.values.get(index);
        if (!ObjectHelper.equals(value, v2)) {
            throw this.fail("Expected: " + BaseTestConsumer.valueAndClass(value) + ", Actual: " + BaseTestConsumer.valueAndClass(v2));
        }
        return (U)this;
    }

    public final U assertValueAt(int index, Predicate<T> valuePredicate) {
        int s2 = this.values.size();
        if (s2 == 0) {
            throw this.fail("No values");
        }
        if (index >= this.values.size()) {
            throw this.fail("Invalid index: " + index);
        }
        boolean found = false;
        try {
            if (valuePredicate.test(this.values.get(index))) {
                found = true;
            }
        }
        catch (Exception ex2) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        if (!found) {
            throw this.fail("Value not present");
        }
        return (U)this;
    }

    public static String valueAndClass(Object o2) {
        if (o2 != null) {
            return o2 + " (class: " + o2.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public final U assertValueCount(int count) {
        int s2 = this.values.size();
        if (s2 != count) {
            throw this.fail("Value counts differ; Expected: " + count + ", Actual: " + s2);
        }
        return (U)this;
    }

    public final U assertNoValues() {
        return this.assertValueCount(0);
    }

    public final U assertValues(T ... values) {
        int s2 = this.values.size();
        if (s2 != values.length) {
            throw this.fail("Value count differs; Expected: " + values.length + " " + Arrays.toString(values) + ", Actual: " + s2 + " " + this.values);
        }
        for (int i2 = 0; i2 < s2; ++i2) {
            T u2 = values[i2];
            T v2 = this.values.get(i2);
            if (ObjectHelper.equals(u2, v2)) continue;
            throw this.fail("Values at position " + i2 + " differ; Expected: " + BaseTestConsumer.valueAndClass(u2) + ", Actual: " + BaseTestConsumer.valueAndClass(v2));
        }
        return (U)this;
    }

    @Experimental
    public final U assertValuesOnly(T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertNoErrors()).assertNotComplete();
    }

    public final U assertValueSet(Collection<? extends T> expected) {
        if (expected.isEmpty()) {
            this.assertNoValues();
            return (U)this;
        }
        for (T v2 : this.values) {
            if (expected.contains(v2)) continue;
            throw this.fail("Value not in the expected collection: " + BaseTestConsumer.valueAndClass(v2));
        }
        return (U)this;
    }

    public final U assertValueSequence(Iterable<? extends T> sequence) {
        boolean actualNext;
        boolean expectedNext;
        int i2 = 0;
        Iterator<T> actualIterator = this.values.iterator();
        Iterator<T> expectedIterator = sequence.iterator();
        while (true) {
            T v2;
            expectedNext = expectedIterator.hasNext();
            actualNext = actualIterator.hasNext();
            if (!actualNext || !expectedNext) break;
            T u2 = expectedIterator.next();
            if (!ObjectHelper.equals(u2, v2 = actualIterator.next())) {
                throw this.fail("Values at position " + i2 + " differ; Expected: " + BaseTestConsumer.valueAndClass(u2) + ", Actual: " + BaseTestConsumer.valueAndClass(v2));
            }
            ++i2;
        }
        if (actualNext) {
            throw this.fail("More values received than expected (" + i2 + ")");
        }
        if (expectedNext) {
            throw this.fail("Fewer values received than expected (" + i2 + ")");
        }
        return (U)this;
    }

    public final U assertTerminated() {
        if (this.done.getCount() != 0L) {
            throw this.fail("Subscriber still running!");
        }
        long c2 = this.completions;
        if (c2 > 1L) {
            throw this.fail("Terminated with multiple completions: " + c2);
        }
        int s2 = this.errors.size();
        if (s2 > 1) {
            throw this.fail("Terminated with multiple errors: " + s2);
        }
        if (c2 != 0L && s2 != 0) {
            throw this.fail("Terminated with multiple completions and errors: " + c2);
        }
        return (U)this;
    }

    public final U assertNotTerminated() {
        if (this.done.getCount() == 0L) {
            throw this.fail("Subscriber terminated!");
        }
        return (U)this;
    }

    public final boolean awaitTerminalEvent() {
        try {
            this.await();
            return true;
        }
        catch (InterruptedException ex2) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitTerminalEvent(long duration, TimeUnit unit) {
        try {
            return this.await(duration, unit);
        }
        catch (InterruptedException ex2) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final U assertErrorMessage(String message) {
        int s2 = this.errors.size();
        if (s2 == 0) {
            throw this.fail("No errors");
        }
        if (s2 == 1) {
            Throwable e2 = this.errors.get(0);
            String errorMessage = e2.getMessage();
            if (!ObjectHelper.equals(message, errorMessage)) {
                throw this.fail("Error message differs; Expected: " + message + ", Actual: " + errorMessage);
            }
        } else {
            throw this.fail("Multiple errors");
        }
        return (U)this;
    }

    public final List<List<Object>> getEvents() {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        result.add(this.values());
        result.add(this.errors());
        ArrayList completeList = new ArrayList();
        for (long i2 = 0L; i2 < this.completions; ++i2) {
            completeList.add(Notification.createOnComplete());
        }
        result.add(completeList);
        return result;
    }

    public abstract U assertSubscribed();

    public abstract U assertNotSubscribed();

    public final U assertResult(T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertNoErrors()).assertComplete();
    }

    public final U assertFailure(Class<? extends Throwable> error, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertNotComplete();
    }

    public final U assertFailure(Predicate<Throwable> errorPredicate, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(errorPredicate)).assertNotComplete();
    }

    public final U assertFailureAndMessage(Class<? extends Throwable> error, String message, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertErrorMessage(message)).assertNotComplete();
    }

    public final U awaitDone(long time, TimeUnit unit) {
        try {
            if (!this.done.await(time, unit)) {
                this.timeout = true;
                this.dispose();
            }
        }
        catch (InterruptedException ex2) {
            this.dispose();
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        return (U)this;
    }

    public final U assertEmpty() {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertNoValues()).assertNoErrors()).assertNotComplete();
    }

    public final U withTag(CharSequence tag) {
        this.tag = tag;
        return (U)this;
    }

    public final U awaitCount(int atLeast) {
        return this.awaitCount(atLeast, BaseTestConsumer$TestWaitStrategy.SLEEP_10MS, 5000L);
    }

    public final U awaitCount(int atLeast, Runnable waitStrategy) {
        return this.awaitCount(atLeast, waitStrategy, 5000L);
    }

    public final U awaitCount(int atLeast, Runnable waitStrategy, long timeoutMillis) {
        long start = System.currentTimeMillis();
        while (true) {
            if (timeoutMillis > 0L && System.currentTimeMillis() - start >= timeoutMillis) {
                this.timeout = true;
                break;
            }
            if (this.done.getCount() == 0L || this.values.size() >= atLeast) break;
            waitStrategy.run();
        }
        return (U)this;
    }

    public final boolean isTimeout() {
        return this.timeout;
    }

    public final U clearTimeout() {
        this.timeout = false;
        return (U)this;
    }

    public final U assertTimeout() {
        if (!this.timeout) {
            throw this.fail("No timeout?!");
        }
        return (U)this;
    }

    public final U assertNoTimeout() {
        if (this.timeout) {
            throw this.fail("Timeout?!");
        }
        return (U)this;
    }
}

