/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;

public final class SerializedObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Disposable s;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedObserver(@NonNull Observer<? super T> actual) {
        this(actual, false);
    }

    public SerializedObserver(@NonNull Observer<? super T> actual, boolean delayError) {
        this.actual = actual;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(@NonNull Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NonNull T t2) {
        if (this.done) {
            return;
        }
        if (t2 == null) {
            this.s.dispose();
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.next(t2));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t2);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(@NonNull Throwable t2) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                    if (q2 == null) {
                        q2 = new AppendOnlyLinkedArrayList(4);
                        this.queue = q2;
                    }
                    Object err = NotificationLite.error(t2);
                    if (this.delayError) {
                        q2.add(err);
                    } else {
                        q2.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q2;
        do {
            SerializedObserver serializedObserver = this;
            synchronized (serializedObserver) {
                q2 = this.queue;
                if (q2 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q2.accept(this.actual));
    }
}

