/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observers.BaseTestConsumer;
import io.reactivex.observers.TestObserver$EmptyObserver;
import java.util.concurrent.atomic.AtomicReference;

public class TestObserver<T>
extends BaseTestConsumer<T, TestObserver<T>>
implements CompletableObserver,
MaybeObserver<T>,
Observer<T>,
SingleObserver<T>,
Disposable {
    private final Observer<? super T> actual;
    private final AtomicReference<Disposable> subscription = new AtomicReference();
    private QueueDisposable<T> qs;

    public static <T> TestObserver<T> create() {
        return new TestObserver<T>();
    }

    public static <T> TestObserver<T> create(Observer<? super T> delegate) {
        return new TestObserver<T>(delegate);
    }

    public TestObserver() {
        this(TestObserver$EmptyObserver.INSTANCE);
    }

    public TestObserver(Observer<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Disposable s2) {
        this.lastThread = Thread.currentThread();
        if (s2 == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.subscription.compareAndSet(null, s2)) {
            s2.dispose();
            if (this.subscription.get() != DisposableHelper.DISPOSED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + s2));
            }
            return;
        }
        if (this.initialFusionMode != 0 && s2 instanceof QueueDisposable) {
            int m2;
            this.qs = (QueueDisposable)s2;
            this.establishedFusionMode = m2 = this.qs.requestFusion(this.initialFusionMode);
            if (m2 == 1) {
                this.checkSubscriptionOnce = true;
                this.lastThread = Thread.currentThread();
                try {
                    Object t2;
                    while ((t2 = this.qs.poll()) != null) {
                        this.values.add(t2);
                    }
                    ++this.completions;
                    this.subscription.lazySet(DisposableHelper.DISPOSED);
                }
                catch (Throwable ex2) {
                    this.errors.add(ex2);
                }
                return;
            }
        }
        this.actual.onSubscribe(s2);
    }

    @Override
    public void onNext(T t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        if (this.establishedFusionMode == 2) {
            try {
                while ((t2 = this.qs.poll()) != null) {
                    this.values.add(t2);
                }
            }
            catch (Throwable ex2) {
                this.errors.add(ex2);
                this.qs.dispose();
            }
            return;
        }
        this.values.add(t2);
        if (t2 == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            if (t2 == null) {
                this.errors.add(new NullPointerException("onError received a null Throwable"));
            } else {
                this.errors.add(t2);
            }
            this.actual.onError(t2);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.actual.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    public final boolean isCancelled() {
        return this.isDisposed();
    }

    public final void cancel() {
        this.dispose();
    }

    @Override
    public final void dispose() {
        DisposableHelper.dispose(this.subscription);
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed(this.subscription.get());
    }

    public final boolean hasSubscription() {
        return this.subscription.get() != null;
    }

    @Override
    public final TestObserver<T> assertSubscribed() {
        if (this.subscription.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    @Override
    public final TestObserver<T> assertNotSubscribed() {
        if (this.subscription.get() != null) {
            throw this.fail("Subscribed!");
        }
        if (!this.errors.isEmpty()) {
            throw this.fail("Not subscribed but errors found");
        }
        return this;
    }

    public final TestObserver<T> assertOf(Consumer<? super TestObserver<T>> check) {
        try {
            check.accept(this);
        }
        catch (Throwable ex2) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        return this;
    }

    final TestObserver<T> setInitialFusionMode(int mode) {
        this.initialFusionMode = mode;
        return this;
    }

    final TestObserver<T> assertFusionMode(int mode) {
        int m2 = this.establishedFusionMode;
        if (m2 != mode) {
            if (this.qs != null) {
                throw new AssertionError((Object)("Fusion mode different. Expected: " + TestObserver.fusionModeToString(mode) + ", actual: " + TestObserver.fusionModeToString(m2)));
            }
            throw this.fail("Upstream is not fuseable");
        }
        return this;
    }

    static String fusionModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SYNC";
            }
            case 2: {
                return "ASYNC";
            }
        }
        return "Unknown(" + mode + ")";
    }

    final TestObserver<T> assertFuseable() {
        if (this.qs == null) {
            throw new AssertionError((Object)"Upstream is not fuseable.");
        }
        return this;
    }

    final TestObserver<T> assertNotFuseable() {
        if (this.qs != null) {
            throw new AssertionError((Object)"Upstream is fuseable.");
        }
        return this;
    }

    @Override
    public void onSuccess(T value) {
        this.onNext(value);
        this.onComplete();
    }
}

