/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.AsyncProcessor$AsyncSubscription;
import io.reactivex.processors.FlowableProcessor;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncProcessor<T>
extends FlowableProcessor<T> {
    static final AsyncProcessor$AsyncSubscription[] EMPTY = new AsyncProcessor$AsyncSubscription[0];
    static final AsyncProcessor$AsyncSubscription[] TERMINATED = new AsyncProcessor$AsyncSubscription[0];
    final AtomicReference<AsyncProcessor$AsyncSubscription<T>[]> subscribers = new AtomicReference<AsyncProcessor$AsyncSubscription[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    @NonNull
    public static <T> AsyncProcessor<T> create() {
        return new AsyncProcessor<T>();
    }

    AsyncProcessor() {
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.subscribers.get() == TERMINATED) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.value = t2;
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.value = null;
        this.error = t2;
        for (AsyncProcessor$AsyncSubscription as2 : this.subscribers.getAndSet(TERMINATED)) {
            as2.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v2 = this.value;
        AsyncProcessor$AsyncSubscription[] array = this.subscribers.getAndSet(TERMINATED);
        if (v2 == null) {
            for (AsyncProcessor$AsyncSubscription as2 : array) {
                as2.onComplete();
            }
        } else {
            for (AsyncProcessor$AsyncSubscription as3 : array) {
                as3.complete(v2);
            }
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        AsyncProcessor$AsyncSubscription<T> as2 = new AsyncProcessor$AsyncSubscription<T>(s2, this);
        s2.onSubscribe(as2);
        if (this.add(as2)) {
            if (as2.isCancelled()) {
                this.remove(as2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                s2.onError(ex2);
            } else {
                T v2 = this.value;
                if (v2 != null) {
                    as2.complete(v2);
                } else {
                    as2.onComplete();
                }
            }
        }
    }

    boolean add(AsyncProcessor$AsyncSubscription<T> ps2) {
        AsyncProcessor$AsyncSubscription[] b2;
        AsyncProcessor$AsyncSubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new AsyncProcessor$AsyncSubscription[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = ps2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(AsyncProcessor$AsyncSubscription<T> ps2) {
        AsyncProcessor$AsyncSubscription[] b2;
        AsyncProcessor$AsyncSubscription<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != ps2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new AsyncProcessor$AsyncSubscription[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    public Object[] getValues() {
        Object[] objectArray;
        T v2 = this.getValue();
        if (v2 != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v2;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public T[] getValues(T[] array) {
        T v2 = this.getValue();
        if (v2 == null) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length == 0) {
            array = Arrays.copyOf(array, 1);
        }
        array[0] = v2;
        if (array.length != 1) {
            array[1] = null;
        }
        return array;
    }
}

