/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.Scheduler;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.ReplayProcessor$ReplayBuffer;
import io.reactivex.processors.ReplayProcessor$ReplaySubscription;
import io.reactivex.processors.ReplayProcessor$SizeAndTimeBoundReplayBuffer;
import io.reactivex.processors.ReplayProcessor$SizeBoundReplayBuffer;
import io.reactivex.processors.ReplayProcessor$UnboundedReplayBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplayProcessor<T>
extends FlowableProcessor<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final ReplayProcessor$ReplayBuffer<T> buffer;
    boolean done;
    final AtomicReference<ReplayProcessor$ReplaySubscription<T>[]> subscribers;
    static final ReplayProcessor$ReplaySubscription[] EMPTY = new ReplayProcessor$ReplaySubscription[0];
    static final ReplayProcessor$ReplaySubscription[] TERMINATED = new ReplayProcessor$ReplaySubscription[0];

    @CheckReturnValue
    public static <T> ReplayProcessor<T> create() {
        return new ReplayProcessor(new ReplayProcessor$UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    public static <T> ReplayProcessor<T> create(int capacityHint) {
        return new ReplayProcessor(new ReplayProcessor$UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    public static <T> ReplayProcessor<T> createWithSize(int maxSize) {
        return new ReplayProcessor(new ReplayProcessor$SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplayProcessor<T> createUnbounded() {
        return new ReplayProcessor(new ReplayProcessor$SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    public static <T> ReplayProcessor<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplayProcessor(new ReplayProcessor$SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    public static <T> ReplayProcessor<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplayProcessor(new ReplayProcessor$SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(ReplayProcessor$ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.subscribers = new AtomicReference<ReplayProcessor$ReplaySubscription[]>(EMPTY);
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        ReplayProcessor$ReplaySubscription<? super T> rs2 = new ReplayProcessor$ReplaySubscription<T>(s2, this);
        s2.onSubscribe(rs2);
        if (this.add(rs2) && rs2.cancelled) {
            this.remove(rs2);
            return;
        }
        this.buffer.replay(rs2);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (this.done) {
            s2.cancel();
            return;
        }
        s2.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            return;
        }
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        b2.next(t2);
        for (ReplayProcessor$ReplaySubscription<T> rs2 : this.subscribers.get()) {
            b2.replay(rs2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        b2.error(t2);
        for (ReplayProcessor$ReplaySubscription rs2 : this.subscribers.getAndSet(TERMINATED)) {
            b2.replay(rs2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        b2.complete();
        for (ReplayProcessor$ReplaySubscription rs2 : this.subscribers.getAndSet(TERMINATED)) {
            b2.replay(rs2);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        if (b2.isDone()) {
            return b2.getError();
        }
        return null;
    }

    public T getValue() {
        return this.buffer.getValue();
    }

    public Object[] getValues() {
        Object[] a2 = EMPTY_ARRAY;
        Object[] b2 = this.getValues(a2);
        if (b2 == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b2;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        return b2.isDone() && b2.getError() == null;
    }

    @Override
    public boolean hasThrowable() {
        ReplayProcessor$ReplayBuffer<T> b2 = this.buffer;
        return b2.isDone() && b2.getError() != null;
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplayProcessor$ReplaySubscription<T> rs2) {
        ReplayProcessor$ReplaySubscription[] b2;
        ReplayProcessor$ReplaySubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a2.length;
            b2 = new ReplayProcessor$ReplaySubscription[len + 1];
            System.arraycopy(a2, 0, b2, 0, len);
            b2[len] = rs2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(ReplayProcessor$ReplaySubscription<T> rs2) {
        ReplayProcessor$ReplaySubscription[] b2;
        ReplayProcessor$ReplaySubscription<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED || a2 == EMPTY) {
                return;
            }
            int len = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < len; ++i2) {
                if (a2[i2] != rs2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (len == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new ReplayProcessor$ReplaySubscription[len - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, len - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }
}

