/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;

final class SerializedProcessor<T>
extends FlowableProcessor<T> {
    final FlowableProcessor<T> actual;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    SerializedProcessor(FlowableProcessor<T> actual) {
        this.actual = actual;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        this.actual.subscribe(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Yy s2) {
        boolean cancel;
        if (!this.done) {
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                        if (q2 == null) {
                            this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                        }
                        q2.add(NotificationLite.subscription(s2));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            s2.cancel();
        } else {
            this.actual.onSubscribe(s2);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.next(t2));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(t2);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t2) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                reportError = true;
            } else {
                this.done = true;
                if (this.emitting) {
                    AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                    if (q2 == null) {
                        this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                    }
                    q2.setFirst(NotificationLite.error(t2));
                    return;
                }
                reportError = false;
                this.emitting = true;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.actual.onError(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q2 = this.queue;
                if (q2 == null) {
                    this.queue = q2 = new AppendOnlyLinkedArrayList(4);
                }
                q2.add(NotificationLite.complete());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<Object> q2;
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                q2 = this.queue;
                if (q2 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q2.accept(this.actual);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.actual.hasSubscribers();
    }

    @Override
    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    @Override
    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    @Override
    public boolean hasComplete() {
        return this.actual.hasComplete();
    }
}

