/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.internal.schedulers.TrampolineScheduler;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers$ComputationTask;
import io.reactivex.schedulers.Schedulers$IOTask;
import io.reactivex.schedulers.Schedulers$NewThreadTask;
import io.reactivex.schedulers.Schedulers$SingleTask;
import java.util.concurrent.Executor;

public final class Schedulers {
    @NonNull
    static final Scheduler SINGLE = RxJavaPlugins.initSingleScheduler(new Schedulers$SingleTask());
    @NonNull
    static final Scheduler COMPUTATION = RxJavaPlugins.initComputationScheduler(new Schedulers$ComputationTask());
    @NonNull
    static final Scheduler IO = RxJavaPlugins.initIoScheduler(new Schedulers$IOTask());
    @NonNull
    static final Scheduler TRAMPOLINE = TrampolineScheduler.instance();
    @NonNull
    static final Scheduler NEW_THREAD = RxJavaPlugins.initNewThreadScheduler(new Schedulers$NewThreadTask());

    private Schedulers() {
        throw new IllegalStateException("No instances!");
    }

    @NonNull
    public static Scheduler computation() {
        return RxJavaPlugins.onComputationScheduler(COMPUTATION);
    }

    @NonNull
    public static Scheduler io() {
        return RxJavaPlugins.onIoScheduler(IO);
    }

    @NonNull
    public static Scheduler trampoline() {
        return TRAMPOLINE;
    }

    @NonNull
    public static Scheduler newThread() {
        return RxJavaPlugins.onNewThreadScheduler(NEW_THREAD);
    }

    @NonNull
    public static Scheduler single() {
        return RxJavaPlugins.onSingleScheduler(SINGLE);
    }

    @NonNull
    public static Scheduler from(@NonNull Executor executor) {
        return new ExecutorScheduler(executor);
    }

    public static void shutdown() {
        Schedulers.computation().shutdown();
        Schedulers.io().shutdown();
        Schedulers.newThread().shutdown();
        Schedulers.single().shutdown();
        Schedulers.trampoline().shutdown();
        SchedulerPoolFactory.shutdown();
    }

    public static void start() {
        Schedulers.computation().start();
        Schedulers.io().start();
        Schedulers.newThread().start();
        Schedulers.single().start();
        Schedulers.trampoline().start();
        SchedulerPoolFactory.start();
    }
}

