/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.AsyncSubject$AsyncDisposable;
import io.reactivex.subjects.Subject;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncSubject<T>
extends Subject<T> {
    static final AsyncSubject$AsyncDisposable[] EMPTY = new AsyncSubject$AsyncDisposable[0];
    static final AsyncSubject$AsyncDisposable[] TERMINATED = new AsyncSubject$AsyncDisposable[0];
    final AtomicReference<AsyncSubject$AsyncDisposable<T>[]> subscribers = new AtomicReference<AsyncSubject$AsyncDisposable[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    public static <T> AsyncSubject<T> create() {
        return new AsyncSubject<T>();
    }

    AsyncSubject() {
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (this.subscribers.get() == TERMINATED) {
            s2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.value = t2;
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.value = null;
        this.error = t2;
        for (AsyncSubject$AsyncDisposable as2 : this.subscribers.getAndSet(TERMINATED)) {
            as2.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v2 = this.value;
        AsyncSubject$AsyncDisposable[] array = this.subscribers.getAndSet(TERMINATED);
        if (v2 == null) {
            for (AsyncSubject$AsyncDisposable as2 : array) {
                as2.onComplete();
            }
        } else {
            for (AsyncSubject$AsyncDisposable as3 : array) {
                as3.complete(v2);
            }
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        AsyncSubject$AsyncDisposable<T> as2 = new AsyncSubject$AsyncDisposable<T>(s2, this);
        s2.onSubscribe(as2);
        if (this.add(as2)) {
            if (as2.isDisposed()) {
                this.remove(as2);
            }
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                s2.onError(ex2);
            } else {
                T v2 = this.value;
                if (v2 != null) {
                    as2.complete(v2);
                } else {
                    as2.onComplete();
                }
            }
        }
    }

    boolean add(AsyncSubject$AsyncDisposable<T> ps2) {
        AsyncSubject$AsyncDisposable[] b2;
        AsyncSubject$AsyncDisposable<T>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = a2.length;
            b2 = new AsyncSubject$AsyncDisposable[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = ps2;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void remove(AsyncSubject$AsyncDisposable<T> ps2) {
        AsyncSubject$AsyncDisposable[] b2;
        AsyncSubject$AsyncDisposable<T>[] a2;
        do {
            int n2;
            if ((n2 = (a2 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != ps2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new AsyncSubject$AsyncDisposable[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    public Object[] getValues() {
        Object[] objectArray;
        T v2 = this.getValue();
        if (v2 != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = v2;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public T[] getValues(T[] array) {
        T v2 = this.getValue();
        if (v2 == null) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length == 0) {
            array = Arrays.copyOf(array, 1);
        }
        array[0] = v2;
        if (array.length != 1) {
            array[1] = null;
        }
        return array;
    }
}

