/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.subjects.ReplaySubject$Node;
import io.reactivex.subjects.ReplaySubject$ReplayBuffer;
import io.reactivex.subjects.ReplaySubject$ReplayDisposable;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;

final class ReplaySubject$SizeBoundReplayBuffer<T>
extends AtomicReference<Object>
implements ReplaySubject$ReplayBuffer<T> {
    private static final long serialVersionUID = 1107649250281456395L;
    final int maxSize;
    int size;
    volatile ReplaySubject$Node<Object> head;
    ReplaySubject$Node<Object> tail;
    volatile boolean done;

    ReplaySubject$SizeBoundReplayBuffer(int maxSize) {
        this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
        ReplaySubject$Node<Object> h2 = new ReplaySubject$Node<Object>(null);
        this.tail = h2;
        this.head = h2;
    }

    void trim() {
        if (this.size > this.maxSize) {
            --this.size;
            ReplaySubject$Node<Object> h2 = this.head;
            this.head = (ReplaySubject$Node)h2.get();
        }
    }

    @Override
    public void add(T value) {
        ReplaySubject$Node<T> n2 = new ReplaySubject$Node<T>(value);
        ReplaySubject$Node<Object> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.set(n2);
        this.trim();
    }

    @Override
    public void addFinal(Object notificationLite) {
        ReplaySubject$Node<Object> n2 = new ReplaySubject$Node<Object>(notificationLite);
        ReplaySubject$Node<Object> t2 = this.tail;
        this.tail = n2;
        ++this.size;
        t2.lazySet(n2);
        this.done = true;
    }

    @Override
    public T getValue() {
        ReplaySubject$Node next;
        ReplaySubject$Node prev = null;
        ReplaySubject$Node h2 = this.head;
        while ((next = (ReplaySubject$Node)h2.get()) != null) {
            prev = h2;
            h2 = next;
        }
        Object v2 = h2.value;
        if (v2 == null) {
            return null;
        }
        if (NotificationLite.isComplete(v2) || NotificationLite.isError(v2)) {
            return prev.value;
        }
        return v2;
    }

    @Override
    public T[] getValues(T[] array) {
        ReplaySubject$Node h2 = this.head;
        int s2 = this.size();
        if (s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
        } else {
            if (array.length < s2) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
            }
            for (int i2 = 0; i2 != s2; ++i2) {
                ReplaySubject$Node next = (ReplaySubject$Node)h2.get();
                array[i2] = next.value;
                h2 = next;
            }
            if (array.length > s2) {
                array[s2] = null;
            }
        }
        return array;
    }

    @Override
    public void replay(ReplaySubject$ReplayDisposable<T> rs2) {
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Observer a2 = rs2.actual;
        ReplaySubject$Node index = (ReplaySubject$Node)rs2.index;
        if (index == null) {
            index = this.head;
        }
        while (true) {
            if (rs2.cancelled) {
                rs2.index = null;
                return;
            }
            ReplaySubject$Node n2 = (ReplaySubject$Node)index.get();
            if (n2 != null) {
                Object o2 = n2.value;
                if (this.done && n2.get() == null) {
                    if (NotificationLite.isComplete(o2)) {
                        a2.onComplete();
                    } else {
                        a2.onError(NotificationLite.getError(o2));
                    }
                    rs2.index = null;
                    rs2.cancelled = true;
                    return;
                }
                a2.onNext(o2);
                index = n2;
                continue;
            }
            if (index.get() != null) continue;
            rs2.index = index;
            if ((missed = rs2.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public int size() {
        int s2;
        ReplaySubject$Node h2 = this.head;
        for (s2 = 0; s2 != Integer.MAX_VALUE; ++s2) {
            ReplaySubject$Node next = (ReplaySubject$Node)h2.get();
            if (next == null) {
                Object o2 = h2.value;
                if (!NotificationLite.isComplete(o2) && !NotificationLite.isError(o2)) break;
                --s2;
                break;
            }
            h2 = next;
        }
        return s2;
    }
}

