/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.subjects.ReplaySubject$ReplayBuffer;
import io.reactivex.subjects.ReplaySubject$ReplayDisposable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class ReplaySubject$UnboundedReplayBuffer<T>
extends AtomicReference<Object>
implements ReplaySubject$ReplayBuffer<T> {
    private static final long serialVersionUID = -733876083048047795L;
    final List<Object> buffer;
    volatile boolean done;
    volatile int size;

    ReplaySubject$UnboundedReplayBuffer(int capacityHint) {
        this.buffer = new ArrayList<Object>(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
    }

    @Override
    public void add(T value) {
        this.buffer.add(value);
        ++this.size;
    }

    @Override
    public void addFinal(Object notificationLite) {
        this.buffer.add(notificationLite);
        ++this.size;
        this.done = true;
    }

    @Override
    public T getValue() {
        int s2 = this.size;
        if (s2 != 0) {
            List<Object> b2 = this.buffer;
            Object o2 = b2.get(s2 - 1);
            if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
                if (s2 == 1) {
                    return null;
                }
                return (T)b2.get(s2 - 2);
            }
            return (T)o2;
        }
        return null;
    }

    @Override
    public T[] getValues(T[] array) {
        int s2 = this.size;
        if (s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        List<Object> b2 = this.buffer;
        Object o2 = b2.get(s2 - 1);
        if ((NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) && --s2 == 0) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        if (array.length < s2) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), s2);
        }
        for (int i2 = 0; i2 < s2; ++i2) {
            array[i2] = b2.get(i2);
        }
        if (array.length > s2) {
            array[s2] = null;
        }
        return array;
    }

    @Override
    public void replay(ReplaySubject$ReplayDisposable<T> rs2) {
        int index;
        if (rs2.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        List<Object> b2 = this.buffer;
        Observer<Object> a2 = rs2.actual;
        Integer indexObject = (Integer)rs2.index;
        if (indexObject != null) {
            index = indexObject;
        } else {
            index = 0;
            rs2.index = 0;
        }
        while (true) {
            if (rs2.cancelled) {
                rs2.index = null;
                return;
            }
            int s2 = this.size;
            while (s2 != index) {
                if (rs2.cancelled) {
                    rs2.index = null;
                    return;
                }
                Object o2 = b2.get(index);
                if (this.done && index + 1 == s2 && index + 1 == (s2 = this.size)) {
                    if (NotificationLite.isComplete(o2)) {
                        a2.onComplete();
                    } else {
                        a2.onError(NotificationLite.getError(o2));
                    }
                    rs2.index = null;
                    rs2.cancelled = true;
                    return;
                }
                a2.onNext(o2);
                ++index;
            }
            if (index != this.size) continue;
            rs2.index = index;
            if ((missed = rs2.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public int size() {
        int s2 = this.size;
        if (s2 != 0) {
            Object o2 = this.buffer.get(s2 - 1);
            if (NotificationLite.isComplete(o2) || NotificationLite.isError(o2)) {
                return s2 - 1;
            }
            return s2;
        }
        return 0;
    }
}

