/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import io.reactivex.subjects.UnicastSubject$UnicastQueueDisposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends Subject<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Observer<? super T>> actual;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean disposed;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean once;
    final BasicIntQueueDisposable<T> wip;
    boolean enableOperatorFusion;

    @CheckReturnValue
    public static <T> UnicastSubject<T> create() {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), true);
    }

    @CheckReturnValue
    public static <T> UnicastSubject<T> create(int capacityHint) {
        return new UnicastSubject<T>(capacityHint, true);
    }

    @CheckReturnValue
    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onTerminate) {
        return new UnicastSubject<T>(capacityHint, onTerminate, true);
    }

    @CheckReturnValue
    @Experimental
    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onTerminate, boolean delayError) {
        return new UnicastSubject<T>(capacityHint, onTerminate, delayError);
    }

    @CheckReturnValue
    @Experimental
    public static <T> UnicastSubject<T> create(boolean delayError) {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), delayError);
    }

    UnicastSubject(int capacityHint, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference();
        this.delayError = delayError;
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastSubject$UnicastQueueDisposable(this);
    }

    UnicastSubject(int capacityHint, Runnable onTerminate) {
        this(capacityHint, onTerminate, true);
    }

    UnicastSubject(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference<Runnable>(ObjectHelper.requireNonNull(onTerminate, "onTerminate"));
        this.delayError = delayError;
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastSubject$UnicastQueueDisposable(this);
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            observer.onSubscribe(this.wip);
            this.actual.lazySet(observer);
            if (this.disposed) {
                this.actual.lazySet(null);
                return;
            }
            this.drain();
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only a single observer allowed."), observer);
        }
    }

    void doTerminate() {
        Runnable r2 = this.onTerminate.get();
        if (r2 != null && this.onTerminate.compareAndSet(r2, null)) {
            r2.run();
        }
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (this.done || this.disposed) {
            s2.dispose();
        }
    }

    @Override
    public void onNext(T t2) {
        ObjectHelper.requireNonNull(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.disposed) {
            return;
        }
        this.queue.offer(t2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        ObjectHelper.requireNonNull(t2, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.disposed) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.disposed) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    void drainNormal(Observer<? super T> a2) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean failFast = !this.delayError;
        boolean canBeError = true;
        while (true) {
            boolean empty;
            if (this.disposed) {
                this.actual.lazySet(null);
                q2.clear();
                return;
            }
            boolean d2 = this.done;
            T v2 = this.queue.poll();
            boolean bl2 = empty = v2 == null;
            if (d2) {
                if (failFast && canBeError) {
                    if (this.failedFast(q2, a2)) {
                        return;
                    }
                    canBeError = false;
                }
                if (empty) {
                    this.errorOrComplete(a2);
                    return;
                }
            }
            if (!empty) {
                a2.onNext(v2);
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    void drainFused(Observer<? super T> a2) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean bl2 = failFast = !this.delayError;
        do {
            if (this.disposed) {
                this.actual.lazySet(null);
                q2.clear();
                return;
            }
            boolean d2 = this.done;
            if (failFast && d2 && this.failedFast(q2, a2)) {
                return;
            }
            a2.onNext(null);
            if (!d2) continue;
            this.errorOrComplete(a2);
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void errorOrComplete(Observer<? super T> a2) {
        this.actual.lazySet(null);
        Throwable ex2 = this.error;
        if (ex2 != null) {
            a2.onError(ex2);
        } else {
            a2.onComplete();
        }
    }

    boolean failedFast(SimpleQueue<T> q2, Observer<? super T> a2) {
        Throwable ex2 = this.error;
        if (ex2 != null) {
            this.actual.lazySet(null);
            q2.clear();
            a2.onError(ex2);
            return true;
        }
        return false;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Observer<? super T> a2 = this.actual.get();
        int missed = 1;
        while (true) {
            if (a2 != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a2);
                } else {
                    this.drainNormal(a2);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a2 = this.actual.get();
        }
    }

    @Override
    public boolean hasObservers() {
        return this.actual.get() != null;
    }

    @Override
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.done && this.error == null;
    }
}

