/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

public final class SafeSubscriber<T>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super T> actual;
    Yy s;
    boolean done;

    public SafeSubscriber(Yx<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            try {
                this.actual.onSubscribe(this);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.done = true;
                try {
                    s2.cancel();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal(e1);
                    RxJavaPlugins.onError(new CompositeException(e2, e1));
                    return;
                }
                RxJavaPlugins.onError(e2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.s == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t2 == null) {
            NullPointerException ex2 = new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(ex2, e1));
                return;
            }
            this.onError(ex2);
            return;
        }
        try {
            this.actual.onNext(t2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(e2, e1));
                return;
            }
            this.onError(e2);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex2 = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            RxJavaPlugins.onError(new CompositeException(ex2, e2));
            return;
        }
        try {
            this.actual.onError(ex2);
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(new CompositeException(ex2, e3));
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        if (this.s == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.actual.onSubscribe(EmptySubscription.INSTANCE);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                RxJavaPlugins.onError(new CompositeException(t2, npe, e2));
                return;
            }
            try {
                this.actual.onError(new CompositeException(t2, npe));
            }
            catch (Throwable e3) {
                Exceptions.throwIfFatal(e3);
                RxJavaPlugins.onError(new CompositeException(t2, npe, e3));
            }
            return;
        }
        if (t2 == null) {
            t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        try {
            this.actual.onError(t2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(new CompositeException(t2, ex2));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.s == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.actual.onComplete();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            RxJavaPlugins.onError(e2);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex2 = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            RxJavaPlugins.onError(new CompositeException(ex2, e2));
            return;
        }
        try {
            this.actual.onError(ex2);
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            RxJavaPlugins.onError(new CompositeException(ex2, e3));
        }
    }

    @Override
    public void request(long n2) {
        try {
            this.s.request(n2);
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            try {
                this.s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                RxJavaPlugins.onError(new CompositeException(e2, e1));
                return;
            }
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void cancel() {
        try {
            this.s.cancel();
        }
        catch (Throwable e1) {
            Exceptions.throwIfFatal(e1);
            RxJavaPlugins.onError(e1);
        }
    }
}

