/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.observers.BaseTestConsumer;
import io.reactivex.subscribers.TestSubscriber$EmptySubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class TestSubscriber<T>
extends BaseTestConsumer<T, TestSubscriber<T>>
implements Yy,
FlowableSubscriber<T>,
Disposable {
    private final Yx<? super T> actual;
    private volatile boolean cancelled;
    private final AtomicReference<Yy> subscription;
    private final AtomicLong missedRequested;
    private QueueSubscription<T> qs;

    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    public static <T> TestSubscriber<T> create(long initialRequested) {
        return new TestSubscriber<T>(initialRequested);
    }

    public static <T> TestSubscriber<T> create(Yx<? super T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    public TestSubscriber() {
        this(TestSubscriber$EmptySubscriber.INSTANCE, Long.MAX_VALUE);
    }

    public TestSubscriber(long initialRequest) {
        this(TestSubscriber$EmptySubscriber.INSTANCE, initialRequest);
    }

    public TestSubscriber(Yx<? super T> actual) {
        this(actual, Long.MAX_VALUE);
    }

    public TestSubscriber(Yx<? super T> actual, long initialRequest) {
        if (initialRequest < 0L) {
            throw new IllegalArgumentException("Negative initial request not allowed");
        }
        this.actual = actual;
        this.subscription = new AtomicReference();
        this.missedRequested = new AtomicLong(initialRequest);
    }

    @Override
    public void onSubscribe(Yy s2) {
        this.lastThread = Thread.currentThread();
        if (s2 == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.subscription.compareAndSet(null, s2)) {
            s2.cancel();
            if (this.subscription.get() != SubscriptionHelper.CANCELLED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + s2));
            }
            return;
        }
        if (this.initialFusionMode != 0 && s2 instanceof QueueSubscription) {
            int m2;
            this.qs = (QueueSubscription)s2;
            this.establishedFusionMode = m2 = this.qs.requestFusion(this.initialFusionMode);
            if (m2 == 1) {
                this.checkSubscriptionOnce = true;
                this.lastThread = Thread.currentThread();
                try {
                    Object t2;
                    while ((t2 = this.qs.poll()) != null) {
                        this.values.add(t2);
                    }
                    ++this.completions;
                }
                catch (Throwable ex2) {
                    this.errors.add(ex2);
                }
                return;
            }
        }
        this.actual.onSubscribe(s2);
        long mr2 = this.missedRequested.getAndSet(0L);
        if (mr2 != 0L) {
            s2.request(mr2);
        }
        this.onStart();
    }

    protected void onStart() {
    }

    @Override
    public void onNext(T t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        if (this.establishedFusionMode == 2) {
            try {
                while ((t2 = this.qs.poll()) != null) {
                    this.values.add(t2);
                }
            }
            catch (Throwable ex2) {
                this.errors.add(ex2);
                this.qs.cancel();
            }
            return;
        }
        this.values.add(t2);
        if (t2 == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new NullPointerException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            this.errors.add(t2);
            if (t2 == null) {
                this.errors.add(new IllegalStateException("onError received a null Throwable"));
            }
            this.actual.onError(t2);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.actual.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public final void request(long n2) {
        SubscriptionHelper.deferredRequest(this.subscription, this.missedRequested, n2);
    }

    @Override
    public final void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.subscription);
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final void dispose() {
        this.cancel();
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final boolean hasSubscription() {
        return this.subscription.get() != null;
    }

    @Override
    public final TestSubscriber<T> assertSubscribed() {
        if (this.subscription.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    @Override
    public final TestSubscriber<T> assertNotSubscribed() {
        if (this.subscription.get() != null) {
            throw this.fail("Subscribed!");
        }
        if (!this.errors.isEmpty()) {
            throw this.fail("Not subscribed but errors found");
        }
        return this;
    }

    final TestSubscriber<T> setInitialFusionMode(int mode) {
        this.initialFusionMode = mode;
        return this;
    }

    final TestSubscriber<T> assertFusionMode(int mode) {
        int m2 = this.establishedFusionMode;
        if (m2 != mode) {
            if (this.qs != null) {
                throw new AssertionError((Object)("Fusion mode different. Expected: " + TestSubscriber.fusionModeToString(mode) + ", actual: " + TestSubscriber.fusionModeToString(m2)));
            }
            throw this.fail("Upstream is not fuseable");
        }
        return this;
    }

    static String fusionModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SYNC";
            }
            case 2: {
                return "ASYNC";
            }
        }
        return "Unknown(" + mode + ")";
    }

    final TestSubscriber<T> assertFuseable() {
        if (this.qs == null) {
            throw new AssertionError((Object)"Upstream is not fuseable.");
        }
        return this;
    }

    final TestSubscriber<T> assertNotFuseable() {
        if (this.qs != null) {
            throw new AssertionError((Object)"Upstream is fuseable.");
        }
        return this;
    }

    public final TestSubscriber<T> assertOf(Consumer<? super TestSubscriber<T>> check) {
        try {
            check.accept(this);
        }
        catch (Throwable ex2) {
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        return this;
    }

    public final TestSubscriber<T> requestMore(long n2) {
        this.request(n2);
        return this;
    }
}

