/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.HttpUrl$Builder$ParseResult;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class HttpUrl$Builder {
    @Nullable
    String a;
    String b;
    String c = "";
    @Nullable
    String d;
    int a;
    final List<String> a = new ArrayList();
    @Nullable
    List<String> b = "";
    @Nullable
    String e;

    public HttpUrl$Builder() {
        this.a.add("");
    }

    public HttpUrl$Builder a(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme == null");
        }
        if (scheme.equalsIgnoreCase("http")) {
            this.a = "http";
        } else if (scheme.equalsIgnoreCase("https")) {
            this.a = "https";
        } else {
            throw new IllegalArgumentException("unexpected scheme: " + scheme);
        }
        return this;
    }

    public HttpUrl$Builder b(String username) {
        if (username == null) {
            throw new NullPointerException("username == null");
        }
        this.b = HttpUrl.a(username, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
        return this;
    }

    public HttpUrl$Builder c(String password) {
        if (password == null) {
            throw new NullPointerException("password == null");
        }
        this.c = HttpUrl.a(password, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
        return this;
    }

    public HttpUrl$Builder d(String host) {
        if (host == null) {
            throw new NullPointerException("host == null");
        }
        String encoded = HttpUrl$Builder.a(host, 0, host.length());
        if (encoded == null) {
            throw new IllegalArgumentException("unexpected host: " + host);
        }
        this.d = encoded;
        return this;
    }

    public HttpUrl$Builder a(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("unexpected port: " + port);
        }
        this.a = port;
        return this;
    }

    int a() {
        return this.a != -1 ? this.a : HttpUrl.a(this.a);
    }

    public HttpUrl$Builder e(@Nullable String encodedQuery) {
        this.b = encodedQuery != null ? HttpUrl.a(HttpUrl.a(encodedQuery, " \"'<>#", true, false, true, true)) : null;
        return this;
    }

    public HttpUrl$Builder a(String encodedName, @Nullable String encodedValue) {
        if (encodedName == null) {
            throw new NullPointerException("encodedName == null");
        }
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(HttpUrl.a(encodedName, " \"'<>#&=", true, false, true, true));
        this.b.add(encodedValue != null ? HttpUrl.a(encodedValue, " \"'<>#&=", true, false, true, true) : null);
        return this;
    }

    HttpUrl$Builder a() {
        int i2;
        int size = this.a.size();
        for (i2 = 0; i2 < size; ++i2) {
            String pathSegment = (String)this.a.get(i2);
            this.a.set(i2, HttpUrl.a(pathSegment, "[]", true, true, false, true));
        }
        if (this.b != null) {
            size = this.b.size();
            for (i2 = 0; i2 < size; ++i2) {
                String component = (String)this.b.get(i2);
                if (component == null) continue;
                this.b.set(i2, HttpUrl.a(component, "\\^`{|}", true, true, true, true));
            }
        }
        if (this.e != null) {
            this.e = HttpUrl.a(this.e, " \"#<>\\^`{|}", true, true, false, false);
        }
        return this;
    }

    public HttpUrl a() {
        if (this.a == null) {
            throw new IllegalStateException("scheme == null");
        }
        if (this.d == null) {
            throw new IllegalStateException("host == null");
        }
        return new HttpUrl(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.a);
        result.append("://");
        if (!this.b.isEmpty() || !this.c.isEmpty()) {
            result.append(this.b);
            if (!this.c.isEmpty()) {
                result.append(':');
                result.append(this.c);
            }
            result.append('@');
        }
        if (this.d.indexOf(58) != -1) {
            result.append('[');
            result.append(this.d);
            result.append(']');
        } else {
            result.append(this.d);
        }
        int effectivePort = this.a();
        if (effectivePort != HttpUrl.a(this.a)) {
            result.append(':');
            result.append(effectivePort);
        }
        HttpUrl.a(result, (List<String>)((Object)this.a));
        if (this.b != null) {
            result.append('?');
            HttpUrl.b(result, (List<String>)((Object)this.b));
        }
        if (this.e != null) {
            result.append('#');
            result.append(this.e);
        }
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    HttpUrl$Builder$ParseResult a(@Nullable HttpUrl base, String input) {
        int limit;
        int pos;
        block19: {
            pos = Rw.a(input, 0, input.length());
            int schemeDelimiterOffset = HttpUrl$Builder.a(input, pos, limit = Rw.b(input, pos, input.length()));
            if (schemeDelimiterOffset != -1) {
                if (input.regionMatches(true, pos, "https:", 0, 6)) {
                    this.a = "https";
                    pos += "https:".length();
                } else {
                    if (!input.regionMatches(true, pos, "http:", 0, 5)) return HttpUrl$Builder$ParseResult.UNSUPPORTED_SCHEME;
                    this.a = "http";
                    pos += "http:".length();
                }
            } else {
                if (base == null) return HttpUrl$Builder$ParseResult.MISSING_SCHEME;
                this.a = base.a;
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = HttpUrl$Builder.b(input, pos, limit);
            if (slashCount >= 2 || base == null || !base.a.equals(this.a)) {
                pos += slashCount;
                while (true) {
                    int componentDelimiterOffset;
                    int c2 = (componentDelimiterOffset = Rw.a(input, pos, limit, "@/\\?#")) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                    switch (c2) {
                        case 64: {
                            if (!hasPassword) {
                                int passwordColonOffset = Rw.a(input, pos, componentDelimiterOffset, ':');
                                String canonicalUsername = HttpUrl.a(input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                String string = this.b = hasUsername ? this.b + "%40" + canonicalUsername : canonicalUsername;
                                if (passwordColonOffset != componentDelimiterOffset) {
                                    hasPassword = true;
                                    this.c = HttpUrl.a(input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                hasUsername = true;
                            } else {
                                this.c = this.c + "%40" + HttpUrl.a(input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                            }
                            pos = componentDelimiterOffset + 1;
                            break;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            int portColonOffset = HttpUrl$Builder.c(input, pos, componentDelimiterOffset);
                            if (portColonOffset + 1 < componentDelimiterOffset) {
                                this.d = HttpUrl$Builder.a(input, pos, portColonOffset);
                                this.a = HttpUrl$Builder.d(input, portColonOffset + 1, componentDelimiterOffset);
                                if (this.a == -1) {
                                    return HttpUrl$Builder$ParseResult.INVALID_PORT;
                                }
                            } else {
                                this.d = HttpUrl$Builder.a(input, pos, portColonOffset);
                                this.a = HttpUrl.a(this.a);
                            }
                            if (this.d == null) {
                                return HttpUrl$Builder$ParseResult.INVALID_HOST;
                            }
                            pos = componentDelimiterOffset;
                            break block19;
                        }
                    }
                }
            }
            this.b = base.b();
            this.c = base.c();
            this.d = base.b;
            this.a = base.a;
            this.a.clear();
            this.a.addAll(base.a());
            if (pos == limit || input.charAt(pos) == '#') {
                this.e(base.f());
            }
        }
        int pathDelimiterOffset = Rw.a(input, pos, limit, "?#");
        this.a(input, pos, pathDelimiterOffset);
        pos = pathDelimiterOffset;
        if (pos < limit && input.charAt(pos) == '?') {
            int queryDelimiterOffset = Rw.a(input, pos, limit, '#');
            this.b = HttpUrl.a(HttpUrl.a(input, pos + 1, queryDelimiterOffset, " \"'<>#", true, false, true, true, null));
            pos = queryDelimiterOffset;
        }
        if (pos >= limit || input.charAt(pos) != '#') return HttpUrl$Builder$ParseResult.SUCCESS;
        this.e = HttpUrl.a(input, pos + 1, limit, "", true, false, false, false, null);
        return HttpUrl$Builder$ParseResult.SUCCESS;
    }

    private void a(String input, int pos, int limit) {
        if (pos == limit) {
            return;
        }
        char c2 = input.charAt(pos);
        if (c2 == '/' || c2 == '\\') {
            this.a.clear();
            this.a.add("");
            ++pos;
        } else {
            this.a.set(this.a.size() - 1, "");
        }
        int i2 = pos;
        while (i2 < limit) {
            int pathSegmentDelimiterOffset = Rw.a(input, i2, limit, "/\\");
            boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
            this.a(input, i2, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
            i2 = pathSegmentDelimiterOffset;
            if (!segmentHasTrailingSlash) continue;
            ++i2;
        }
    }

    private void a(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
        String segment = HttpUrl.a(input, pos, limit, " \"<>^`{}|/\\?#", alreadyEncoded, false, false, true, null);
        if (this.a(segment)) {
            return;
        }
        if (this.b(segment)) {
            this.a();
            return;
        }
        if (((String)this.a.get(this.a.size() - 1)).isEmpty()) {
            this.a.set(this.a.size() - 1, segment);
        } else {
            this.a.add(segment);
        }
        if (addTrailingSlash) {
            this.a.add("");
        }
    }

    private boolean a(String input) {
        return input.equals(".") || input.equalsIgnoreCase("%2e");
    }

    private boolean b(String input) {
        return input.equals("..") || input.equalsIgnoreCase("%2e.") || input.equalsIgnoreCase(".%2e") || input.equalsIgnoreCase("%2e%2e");
    }

    private void a() {
        String removed = (String)this.a.remove(this.a.size() - 1);
        if (removed.isEmpty() && !this.a.isEmpty()) {
            this.a.set(this.a.size() - 1, "");
        } else {
            this.a.add("");
        }
    }

    private static int a(String input, int pos, int limit) {
        if (limit - pos < 2) {
            return -1;
        }
        char c0 = input.charAt(pos);
        if (!(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z')) {
            return -1;
        }
        for (int i2 = pos + 1; i2 < limit; ++i2) {
            char c2 = input.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.') continue;
            if (c2 == ':') {
                return i2;
            }
            return -1;
        }
        return -1;
    }

    private static int b(String input, int pos, int limit) {
        char c2;
        int slashCount = 0;
        while (pos < limit && ((c2 = input.charAt(pos)) == '\\' || c2 == '/')) {
            ++slashCount;
            ++pos;
        }
        return slashCount;
    }

    private static int c(String input, int pos, int limit) {
        block4: for (int i2 = pos; i2 < limit; ++i2) {
            switch (input.charAt(i2)) {
                case '[': {
                    while (++i2 < limit && input.charAt(i2) != ']') {
                    }
                    continue block4;
                }
                case ':': {
                    return i2;
                }
            }
        }
        return limit;
    }

    private static String a(String input, int pos, int limit) {
        String percentDecoded = HttpUrl.a(input, pos, limit, false);
        return Rw.a(percentDecoded);
    }

    private static int d(String input, int pos, int limit) {
        try {
            String portString = HttpUrl.a(input, pos, limit, "", false, false, false, true, null);
            int i2 = Integer.parseInt(portString);
            if (i2 > 0 && i2 <= 65535) {
                return i2;
            }
            return -1;
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }
}

