/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.codec.language.bm.Languages$1;
import org.apache.commons.codec.language.bm.Languages$2;
import org.apache.commons.codec.language.bm.Languages$LanguageSet;
import org.apache.commons.codec.language.bm.NameType;

public class Languages {
    public static final String ANY = "any";
    private static final Map<NameType, Languages> LANGUAGES = new EnumMap<NameType, Languages>(NameType.class);
    private final Set<String> languages;
    public static final Languages$LanguageSet NO_LANGUAGES;
    public static final Languages$LanguageSet ANY_LANGUAGE;

    public static Languages getInstance(NameType nameType) {
        return LANGUAGES.get((Object)nameType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Languages getInstance(String languagesResourceName) {
        HashSet<String> ls2 = new HashSet<String>();
        InputStream langIS = Languages.class.getClassLoader().getResourceAsStream(languagesResourceName);
        if (langIS == null) {
            throw new IllegalArgumentException("Unable to resolve required resource: " + languagesResourceName);
        }
        try (Scanner lsScanner = new Scanner(langIS, "UTF-8");){
            boolean inExtendedComment = false;
            while (lsScanner.hasNextLine()) {
                String line = lsScanner.nextLine().trim();
                if (inExtendedComment) {
                    if (!line.endsWith("*/")) continue;
                    inExtendedComment = false;
                    continue;
                }
                if (line.startsWith("/*")) {
                    inExtendedComment = true;
                    continue;
                }
                if (line.length() <= 0) continue;
                ls2.add(line);
            }
        }
        return new Languages(Collections.unmodifiableSet(ls2));
    }

    private static String langResourceName(NameType nameType) {
        return String.format("org/apache/commons/codec/language/bm/%s_languages.txt", nameType.getName());
    }

    private Languages(Set<String> languages) {
        this.languages = languages;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    static {
        for (NameType s2 : NameType.values()) {
            LANGUAGES.put(s2, Languages.getInstance(Languages.langResourceName(s2)));
        }
        NO_LANGUAGES = new Languages$1();
        ANY_LANGUAGE = new Languages$2();
    }
}

