/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.impl.WeakHashtable$1;
import org.apache.commons.logging.impl.WeakHashtable$Entry;
import org.apache.commons.logging.impl.WeakHashtable$Referenced;
import org.apache.commons.logging.impl.WeakHashtable$WeakKey;

public final class WeakHashtable
extends Hashtable {
    private static final long serialVersionUID = -1546036869799732453L;
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    @Override
    public boolean containsKey(Object key) {
        WeakHashtable$Referenced referenced = new WeakHashtable$Referenced(key, null);
        return super.containsKey(referenced);
    }

    @Override
    public Enumeration elements() {
        this.purge();
        return super.elements();
    }

    @Override
    public Set entrySet() {
        this.purge();
        Set referencedEntries = super.entrySet();
        HashSet<WeakHashtable$Entry> unreferencedEntries = new HashSet<WeakHashtable$Entry>();
        for (Map.Entry entry : referencedEntries) {
            WeakHashtable$Referenced referencedKey = (WeakHashtable$Referenced)entry.getKey();
            Object key = WeakHashtable$Referenced.access$100(referencedKey);
            Object value = entry.getValue();
            if (key == null) continue;
            WeakHashtable$Entry dereferencedEntry = new WeakHashtable$Entry(key, value, null);
            unreferencedEntries.add(dereferencedEntry);
        }
        return unreferencedEntries;
    }

    @Override
    public Object get(Object key) {
        WeakHashtable$Referenced referenceKey = new WeakHashtable$Referenced(key, null);
        return super.get(referenceKey);
    }

    @Override
    public Enumeration keys() {
        this.purge();
        Enumeration enumer = super.keys();
        return new WeakHashtable$1(this, enumer);
    }

    @Override
    public Set keySet() {
        this.purge();
        Set referencedKeys = super.keySet();
        HashSet<Object> unreferencedKeys = new HashSet<Object>();
        for (WeakHashtable$Referenced referenceKey : referencedKeys) {
            Object keyValue = WeakHashtable$Referenced.access$100(referenceKey);
            if (keyValue == null) continue;
            unreferencedKeys.add(keyValue);
        }
        return unreferencedKeys;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        WeakHashtable$Referenced keyRef = new WeakHashtable$Referenced(key, this.queue, null);
        return super.put(keyRef, value);
    }

    @Override
    public void putAll(Map t2) {
        if (t2 != null) {
            Set entrySet = t2.entrySet();
            for (Map.Entry entry : entrySet) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Collection values() {
        this.purge();
        return super.values();
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new WeakHashtable$Referenced(key, null));
    }

    @Override
    public boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    @Override
    public int size() {
        this.purge();
        return super.size();
    }

    @Override
    public String toString() {
        this.purge();
        return super.toString();
    }

    @Override
    protected void rehash() {
        this.purge();
        super.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        ArrayList<WeakHashtable$Referenced> toRemove = new ArrayList<WeakHashtable$Referenced>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey key;
            while ((key = (WeakHashtable$WeakKey)this.queue.poll()) != null) {
                toRemove.add(WeakHashtable$WeakKey.access$400(key));
            }
        }
        int size = toRemove.size();
        for (int i2 = 0; i2 < size; ++i2) {
            super.remove(toRemove.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakHashtable$WeakKey key = (WeakHashtable$WeakKey)this.queue.poll();
            if (key != null) {
                super.remove(WeakHashtable$WeakKey.access$400(key));
            }
        }
    }
}

