/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.BasicHeader;

@NotThreadSafe
public abstract class AbstractHttpEntity
implements HttpEntity {
    protected static final int OUTPUT_BUFFER_SIZE = 4096;
    protected Header contentType;
    protected Header contentEncoding;
    protected boolean chunked;

    protected AbstractHttpEntity() {
    }

    @Override
    public Header getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    public void setContentType(Header contentType) {
        this.contentType = contentType;
    }

    public void setContentType(String ctString) {
        BasicHeader h2 = null;
        if (ctString != null) {
            h2 = new BasicHeader("Content-Type", ctString);
        }
        this.setContentType(h2);
    }

    public void setContentEncoding(Header contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setContentEncoding(String ceString) {
        BasicHeader h2 = null;
        if (ceString != null) {
            h2 = new BasicHeader("Content-Encoding", ceString);
        }
        this.setContentEncoding(h2);
    }

    public void setChunked(boolean b2) {
        this.chunked = b2;
    }

    @Override
    @Deprecated
    public void consumeContent() {
    }

    public String toString() {
        long len;
        StringBuilder sb2 = new StringBuilder();
        sb2.append('[');
        if (this.contentType != null) {
            sb2.append("Content-Type: ");
            sb2.append(this.contentType.getValue());
            sb2.append(',');
        }
        if (this.contentEncoding != null) {
            sb2.append("Content-Encoding: ");
            sb2.append(this.contentEncoding.getValue());
            sb2.append(',');
        }
        if ((len = this.getContentLength()) >= 0L) {
            sb2.append("Content-Length: ");
            sb2.append(len);
            sb2.append(',');
        }
        sb2.append("Chunked: ");
        sb2.append(this.chunked);
        sb2.append(']');
        return sb2.toString();
    }
}

