/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.impl.auth.NTLMEngineImpl;

class NTLMEngineImpl$MD4 {
    protected int A = 1732584193;
    protected int B = -271733879;
    protected int C = -1732584194;
    protected int D = 271733878;
    protected long count = 0L;
    protected byte[] dataBuffer = new byte[64];

    NTLMEngineImpl$MD4() {
    }

    void update(byte[] input) {
        int transferAmt;
        int curBufferPos = (int)(this.count & 0x3FL);
        int inputIndex = 0;
        while (input.length - inputIndex + curBufferPos >= this.dataBuffer.length) {
            transferAmt = this.dataBuffer.length - curBufferPos;
            System.arraycopy(input, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
            this.count += (long)transferAmt;
            curBufferPos = 0;
            inputIndex += transferAmt;
            this.processBuffer();
        }
        if (inputIndex < input.length) {
            transferAmt = input.length - inputIndex;
            System.arraycopy(input, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
            this.count += (long)transferAmt;
            curBufferPos += transferAmt;
        }
    }

    byte[] getOutput() {
        int bufferIndex = (int)(this.count & 0x3FL);
        int padLen = bufferIndex < 56 ? 56 - bufferIndex : 120 - bufferIndex;
        byte[] postBytes = new byte[padLen + 8];
        postBytes[0] = -128;
        for (int i2 = 0; i2 < 8; ++i2) {
            postBytes[padLen + i2] = (byte)(this.count * 8L >>> 8 * i2);
        }
        this.update(postBytes);
        byte[] result = new byte[16];
        NTLMEngineImpl.writeULong(result, this.A, 0);
        NTLMEngineImpl.writeULong(result, this.B, 4);
        NTLMEngineImpl.writeULong(result, this.C, 8);
        NTLMEngineImpl.writeULong(result, this.D, 12);
        return result;
    }

    protected void processBuffer() {
        int[] d2 = new int[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            d2[i2] = (this.dataBuffer[i2 * 4] & 0xFF) + ((this.dataBuffer[i2 * 4 + 1] & 0xFF) << 8) + ((this.dataBuffer[i2 * 4 + 2] & 0xFF) << 16) + ((this.dataBuffer[i2 * 4 + 3] & 0xFF) << 24);
        }
        int AA2 = this.A;
        int BB2 = this.B;
        int CC2 = this.C;
        int DD2 = this.D;
        this.round1(d2);
        this.round2(d2);
        this.round3(d2);
        this.A += AA2;
        this.B += BB2;
        this.C += CC2;
        this.D += DD2;
    }

    protected void round1(int[] d2) {
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d2[0], 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d2[1], 7);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d2[2], 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d2[3], 19);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d2[4], 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d2[5], 7);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d2[6], 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d2[7], 19);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d2[8], 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d2[9], 7);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d2[10], 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d2[11], 19);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d2[12], 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d2[13], 7);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d2[14], 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d2[15], 19);
    }

    protected void round2(int[] d2) {
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d2[0] + 1518500249, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d2[4] + 1518500249, 5);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d2[8] + 1518500249, 9);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d2[12] + 1518500249, 13);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d2[1] + 1518500249, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d2[5] + 1518500249, 5);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d2[9] + 1518500249, 9);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d2[13] + 1518500249, 13);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d2[2] + 1518500249, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d2[6] + 1518500249, 5);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d2[10] + 1518500249, 9);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d2[14] + 1518500249, 13);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d2[3] + 1518500249, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d2[7] + 1518500249, 5);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d2[11] + 1518500249, 9);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d2[15] + 1518500249, 13);
    }

    protected void round3(int[] d2) {
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d2[0] + 1859775393, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d2[8] + 1859775393, 9);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d2[4] + 1859775393, 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d2[12] + 1859775393, 15);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d2[2] + 1859775393, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d2[10] + 1859775393, 9);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d2[6] + 1859775393, 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d2[14] + 1859775393, 15);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d2[1] + 1859775393, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d2[9] + 1859775393, 9);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d2[5] + 1859775393, 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d2[13] + 1859775393, 15);
        this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d2[3] + 1859775393, 3);
        this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d2[11] + 1859775393, 9);
        this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d2[7] + 1859775393, 11);
        this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d2[15] + 1859775393, 15);
    }
}

