/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.util.EncodingUtils;

class NTLMEngineImpl$NTLMMessage {
    private byte[] messageContents = null;
    private int currentOutputPosition = 0;

    NTLMEngineImpl$NTLMMessage() {
    }

    NTLMEngineImpl$NTLMMessage(String messageBody, int expectedType) {
        this.messageContents = Base64.decodeBase64(messageBody.getBytes(NTLMEngineImpl.access$1000()));
        if (this.messageContents.length < NTLMEngineImpl.access$1100().length) {
            throw new NTLMEngineException("NTLM message decoding error - packet too short");
        }
        for (int i2 = 0; i2 < NTLMEngineImpl.access$1100().length; ++i2) {
            if (this.messageContents[i2] == NTLMEngineImpl.access$1100()[i2]) continue;
            throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
        }
        int type = this.readULong(NTLMEngineImpl.access$1100().length);
        if (type != expectedType) {
            throw new NTLMEngineException("NTLM type " + Integer.toString(expectedType) + " message expected - instead got type " + Integer.toString(type));
        }
        this.currentOutputPosition = this.messageContents.length;
    }

    protected int getPreambleLength() {
        return NTLMEngineImpl.access$1100().length + 4;
    }

    protected int getMessageLength() {
        return this.currentOutputPosition;
    }

    protected byte readByte(int position) {
        if (this.messageContents.length < position + 1) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        return this.messageContents[position];
    }

    protected void readBytes(byte[] buffer, int position) {
        if (this.messageContents.length < position + buffer.length) {
            throw new NTLMEngineException("NTLM: Message too short");
        }
        System.arraycopy(this.messageContents, position, buffer, 0, buffer.length);
    }

    protected int readUShort(int position) {
        return NTLMEngineImpl.access$1200(this.messageContents, position);
    }

    protected int readULong(int position) {
        return NTLMEngineImpl.access$1300(this.messageContents, position);
    }

    protected byte[] readSecurityBuffer(int position) {
        return NTLMEngineImpl.access$1400(this.messageContents, position);
    }

    protected void prepareResponse(int maxlength, int messageType) {
        this.messageContents = new byte[maxlength];
        this.currentOutputPosition = 0;
        this.addBytes(NTLMEngineImpl.access$1100());
        this.addULong(messageType);
    }

    protected void addByte(byte b2) {
        this.messageContents[this.currentOutputPosition] = b2;
        ++this.currentOutputPosition;
    }

    protected void addBytes(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        byte[] arr$ = bytes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte b2;
            this.messageContents[this.currentOutputPosition] = b2 = arr$[i$];
            ++this.currentOutputPosition;
        }
    }

    protected void addUShort(int value) {
        this.addByte((byte)(value & 0xFF));
        this.addByte((byte)(value >> 8 & 0xFF));
    }

    protected void addULong(int value) {
        this.addByte((byte)(value & 0xFF));
        this.addByte((byte)(value >> 8 & 0xFF));
        this.addByte((byte)(value >> 16 & 0xFF));
        this.addByte((byte)(value >> 24 & 0xFF));
    }

    String getResponse() {
        byte[] resp;
        if (this.messageContents.length > this.currentOutputPosition) {
            byte[] tmp = new byte[this.currentOutputPosition];
            System.arraycopy(this.messageContents, 0, tmp, 0, this.currentOutputPosition);
            resp = tmp;
        } else {
            resp = this.messageContents;
        }
        return EncodingUtils.getAsciiString(Base64.encodeBase64(resp));
    }
}

