/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.UnsupportedEncodingException;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl$NTLMMessage;

class NTLMEngineImpl$Type2Message
extends NTLMEngineImpl$NTLMMessage {
    protected byte[] challenge = new byte[8];
    protected String target;
    protected byte[] targetInfo;
    protected int flags;

    NTLMEngineImpl$Type2Message(String message) {
        super(message, 2);
        byte[] bytes;
        this.readBytes(this.challenge, 24);
        this.flags = this.readULong(20);
        if ((this.flags & 1) == 0) {
            throw new NTLMEngineException("NTLM type 2 message indicates no support for Unicode. Flags are: " + Integer.toString(this.flags));
        }
        this.target = null;
        if (this.getMessageLength() >= 20 && (bytes = this.readSecurityBuffer(12)).length != 0) {
            try {
                this.target = new String(bytes, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e2) {
                throw new NTLMEngineException(e2.getMessage(), e2);
            }
        }
        this.targetInfo = null;
        if (this.getMessageLength() >= 48 && (bytes = this.readSecurityBuffer(40)).length != 0) {
            this.targetInfo = bytes;
        }
    }

    byte[] getChallenge() {
        return this.challenge;
    }

    String getTarget() {
        return this.target;
    }

    byte[] getTargetInfo() {
        return this.targetInfo;
    }

    int getFlags() {
        return this.flags;
    }
}

