/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.util.Locale;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$CipherGen;
import org.apache.http.impl.auth.NTLMEngineImpl$NTLMMessage;

class NTLMEngineImpl$Type3Message
extends NTLMEngineImpl$NTLMMessage {
    protected int type2Flags;
    protected byte[] domainBytes;
    protected byte[] hostBytes;
    protected byte[] userBytes;
    protected byte[] lmResp;
    protected byte[] ntResp;
    protected byte[] sessionKey;

    NTLMEngineImpl$Type3Message(String domain, String host, String user, String password, byte[] nonce, int type2Flags, String target, byte[] targetInformation) {
        byte[] userSessionKey;
        this.type2Flags = type2Flags;
        String unqualifiedHost = NTLMEngineImpl.access$1600(host);
        String unqualifiedDomain = NTLMEngineImpl.access$1700(domain);
        NTLMEngineImpl$CipherGen gen = new NTLMEngineImpl$CipherGen(unqualifiedDomain, user, password, nonce, target, targetInformation);
        try {
            if ((type2Flags & 0x800000) != 0 && targetInformation != null && target != null) {
                this.ntResp = gen.getNTLMv2Response();
                this.lmResp = gen.getLMv2Response();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMv2UserSessionKey();
            } else if ((type2Flags & 0x80000) != 0) {
                this.ntResp = gen.getNTLM2SessionResponse();
                this.lmResp = gen.getLM2SessionResponse();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLM2SessionResponseUserSessionKey();
            } else {
                this.ntResp = gen.getNTLMResponse();
                this.lmResp = gen.getLMResponse();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMUserSessionKey();
            }
        }
        catch (NTLMEngineException e2) {
            this.ntResp = new byte[0];
            this.lmResp = gen.getLMResponse();
            userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getLMUserSessionKey();
        }
        this.sessionKey = (byte[])((type2Flags & 0x10) != 0 ? ((type2Flags & 0x40000000) != 0 ? NTLMEngineImpl.RC4(gen.getSecondaryKey(), userSessionKey) : userSessionKey) : null);
        if (NTLMEngineImpl.access$1500() == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        this.hostBytes = unqualifiedHost != null ? unqualifiedHost.getBytes(NTLMEngineImpl.access$1500()) : null;
        this.domainBytes = unqualifiedDomain != null ? unqualifiedDomain.toUpperCase(Locale.ROOT).getBytes(NTLMEngineImpl.access$1500()) : null;
        this.userBytes = user.getBytes(NTLMEngineImpl.access$1500());
    }

    @Override
    String getResponse() {
        int ntRespLen = this.ntResp.length;
        int lmRespLen = this.lmResp.length;
        int domainLen = this.domainBytes != null ? this.domainBytes.length : 0;
        int hostLen = this.hostBytes != null ? this.hostBytes.length : 0;
        int userLen = this.userBytes.length;
        int sessionKeyLen = this.sessionKey != null ? this.sessionKey.length : 0;
        int lmRespOffset = 72;
        int ntRespOffset = 72 + lmRespLen;
        int domainOffset = ntRespOffset + ntRespLen;
        int userOffset = domainOffset + domainLen;
        int hostOffset = userOffset + userLen;
        int sessionKeyOffset = hostOffset + hostLen;
        int finalLength = sessionKeyOffset + sessionKeyLen;
        this.prepareResponse(finalLength, 3);
        this.addUShort(lmRespLen);
        this.addUShort(lmRespLen);
        this.addULong(72);
        this.addUShort(ntRespLen);
        this.addUShort(ntRespLen);
        this.addULong(ntRespOffset);
        this.addUShort(domainLen);
        this.addUShort(domainLen);
        this.addULong(domainOffset);
        this.addUShort(userLen);
        this.addUShort(userLen);
        this.addULong(userOffset);
        this.addUShort(hostLen);
        this.addUShort(hostLen);
        this.addULong(hostOffset);
        this.addUShort(sessionKeyLen);
        this.addUShort(sessionKeyLen);
        this.addULong(sessionKeyOffset);
        this.addULong(this.type2Flags & 0x80 | this.type2Flags & 0x200 | this.type2Flags & 0x80000 | 0x2000000 | this.type2Flags & 0x8000 | this.type2Flags & 0x20 | this.type2Flags & 0x10 | this.type2Flags & 0x20000000 | this.type2Flags & Integer.MIN_VALUE | this.type2Flags & 0x40000000 | this.type2Flags & 0x800000 | this.type2Flags & 1 | this.type2Flags & 4);
        this.addUShort(261);
        this.addULong(2600);
        this.addUShort(3840);
        this.addBytes(this.lmResp);
        this.addBytes(this.ntResp);
        this.addBytes(this.domainBytes);
        this.addBytes(this.userBytes);
        this.addBytes(this.hostBytes);
        if (this.sessionKey != null) {
            this.addBytes(this.sessionKey);
        }
        return super.getResponse();
    }
}

