/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder$KeyManagerDelegate;
import org.apache.http.ssl.SSLContextBuilder$TrustManagerDelegate;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.Args;

@NotThreadSafe
public class SSLContextBuilder {
    static final String TLS = "TLS";
    private String protocol;
    private final Set<KeyManager> keymanagers = new LinkedHashSet<KeyManager>();
    private final Set<TrustManager> trustmanagers = new LinkedHashSet<TrustManager>();
    private SecureRandom secureRandom;

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder useProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore truststore, TrustStrategy trustStrategy) {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] tms = tmfactory.getTrustManagers();
        if (tms != null) {
            if (trustStrategy != null) {
                for (int i2 = 0; i2 < tms.length; ++i2) {
                    TrustManager tm2 = tms[i2];
                    if (!(tm2 instanceof X509TrustManager)) continue;
                    tms[i2] = new SSLContextBuilder$TrustManagerDelegate((X509TrustManager)tm2, trustStrategy);
                }
            }
            for (TrustManager tm3 : tms) {
                this.trustmanagers.add(tm3);
            }
        }
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) {
        return this.loadTrustMaterial(null, trustStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword, TrustStrategy trustStrategy) {
        Args.notNull(file, "Truststore file");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(file);){
            trustStore.load(instream, storePassword);
        }
        return this.loadTrustMaterial(trustStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] storePassword) {
        return this.loadTrustMaterial(file, storePassword, null);
    }

    public SSLContextBuilder loadTrustMaterial(File file) {
        return this.loadTrustMaterial(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword, TrustStrategy trustStrategy) {
        Args.notNull(url, "Truststore URL");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = url.openStream();){
            trustStore.load(instream, storePassword);
        }
        return this.loadTrustMaterial(trustStore, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(URL url, char[] storePassword) {
        return this.loadTrustMaterial(url, storePassword, null);
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword, PrivateKeyStrategy aliasStrategy) {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keyPassword);
        KeyManager[] kms = kmfactory.getKeyManagers();
        if (kms != null) {
            if (aliasStrategy != null) {
                for (int i2 = 0; i2 < kms.length; ++i2) {
                    KeyManager km2 = kms[i2];
                    if (!(km2 instanceof X509ExtendedKeyManager)) continue;
                    kms[i2] = new SSLContextBuilder$KeyManagerDelegate((X509ExtendedKeyManager)km2, aliasStrategy);
                }
            }
            for (KeyManager km3 : kms) {
                this.keymanagers.add(km3);
            }
        }
        return this;
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) {
        return this.loadKeyMaterial(keystore, keyPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) {
        Args.notNull(file, "Keystore file");
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream instream = new FileInputStream(file);){
            identityStore.load(instream, storePassword);
        }
        return this.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] storePassword, char[] keyPassword) {
        return this.loadKeyMaterial(file, storePassword, keyPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) {
        Args.notNull(url, "Keystore URL");
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream instream = url.openStream();){
            identityStore.load(instream, storePassword);
        }
        return this.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(URL url, char[] storePassword, char[] keyPassword) {
        return this.loadKeyMaterial(url, storePassword, keyPassword, null);
    }

    protected void initSSLContext(SSLContext sslcontext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) {
        sslcontext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[keyManagers.size()]) : null, !trustManagers.isEmpty() ? trustManagers.toArray(new TrustManager[trustManagers.size()]) : null, secureRandom);
    }

    public SSLContext build() {
        SSLContext sslcontext = SSLContext.getInstance(this.protocol != null ? this.protocol : TLS);
        this.initSSLContext(sslcontext, this.keymanagers, this.trustmanagers, this.secureRandom);
        return sslcontext;
    }
}

