/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import org.apache.thrift.Option$None;
import org.apache.thrift.Option$Some;

public abstract class Option<T> {
    public abstract boolean isDefined();

    public abstract T get();

    public T or(T other) {
        if (this.isDefined()) {
            return this.get();
        }
        return other;
    }

    public static <T> Option<T> fromNullable(T value) {
        if (value != null) {
            return new Option$Some<T>(value);
        }
        return new Option$None();
    }

    public static <T> Option$Some<T> some(T value) {
        return new Option$Some<T>(value);
    }

    public static <T> Option$None<T> none() {
        return new Option$None();
    }
}

