/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializable;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public abstract class ProcessFunction<I, T extends TBase> {
    private final String methodName;
    private static final YA LOGGER = YB.a(ProcessFunction.class.getName());

    public ProcessFunction(String methodName) {
        this.methodName = methodName;
    }

    public final void process(int seqid, TProtocol iprot, TProtocol oprot, I iface) {
        int msgType;
        TSerializable result;
        block7: {
            T args = this.getEmptyArgsInstance();
            try {
                args.read(iprot);
            }
            catch (TProtocolException e2) {
                iprot.readMessageEnd();
                TApplicationException x2 = new TApplicationException(7, e2.getMessage());
                oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
                x2.write(oprot);
                oprot.writeMessageEnd();
                oprot.getTransport().flush();
                return;
            }
            iprot.readMessageEnd();
            result = null;
            msgType = 2;
            try {
                result = this.getResult(iface, args);
            }
            catch (TTransportException ex2) {
                LOGGER.error("Transport error while processing " + this.getMethodName(), ex2);
                throw ex2;
            }
            catch (TApplicationException ex3) {
                LOGGER.error("Internal application error processing " + this.getMethodName(), ex3);
                result = ex3;
                msgType = 3;
            }
            catch (Exception ex4) {
                LOGGER.error("Internal error processing " + this.getMethodName(), ex4);
                if (this.isOneway()) break block7;
                result = new TApplicationException(6, "Internal error processing " + this.getMethodName());
                msgType = 3;
            }
        }
        if (!this.isOneway()) {
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), (byte)msgType, seqid));
            result.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    private void handleException(int seqid, TProtocol oprot) {
        if (!this.isOneway()) {
            TApplicationException x2 = new TApplicationException(6, "Internal error processing " + this.getMethodName());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x2.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    protected boolean handleRuntimeExceptions() {
        return false;
    }

    protected abstract boolean isOneway();

    public abstract TBase getResult(I var1, T var2);

    public abstract T getEmptyArgsInstance();

    public String getMethodName() {
        return this.methodName;
    }
}

