/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

public class ShortStack {
    private short[] vector;
    private int top = -1;

    public ShortStack(int initialCapacity) {
        this.vector = new short[initialCapacity];
    }

    public short pop() {
        return this.vector[this.top--];
    }

    public void push(short pushed) {
        if (this.vector.length == this.top + 1) {
            this.grow();
        }
        this.vector[++this.top] = pushed;
    }

    private void grow() {
        short[] newVector = new short[this.vector.length * 2];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    public short peek() {
        return this.vector[this.top];
    }

    public void clear() {
        this.top = -1;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("<ShortStack vector:[");
        for (int i2 = 0; i2 < this.vector.length; ++i2) {
            if (i2 != 0) {
                sb2.append(" ");
            }
            if (i2 == this.top) {
                sb2.append(">>");
            }
            sb2.append(this.vector[i2]);
            if (i2 != this.top) continue;
            sb2.append("<<");
        }
        sb2.append("]>");
        return sb2.toString();
    }
}

