/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift.AsyncProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TAsyncProcessor;
import org.apache.thrift.TBase;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.server.AbstractNonblockingServer$AsyncFrameBuffer;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final YA LOGGER = YB.a(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(AbstractNonblockingServer$AsyncFrameBuffer fb2) {
        TProtocol in2 = fb2.getInputProtocol();
        TProtocol out = fb2.getOutputProtocol();
        TMessage msg = in2.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn2 = this.processMap.get(msg.name);
        if (fn2 == null) {
            TProtocolUtil.skip(in2, (byte)12);
            in2.readMessageEnd();
            if (!fn2.isOneway()) {
                TApplicationException x2 = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x2.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb2.responseReady();
            return true;
        }
        TBase args = fn2.getEmptyArgsInstance();
        try {
            args.read(in2);
        }
        catch (TProtocolException e2) {
            in2.readMessageEnd();
            if (!fn2.isOneway()) {
                TApplicationException x3 = new TApplicationException(7, e2.getMessage());
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x3.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb2.responseReady();
            return true;
        }
        in2.readMessageEnd();
        if (fn2.isOneway()) {
            fb2.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn2.getResultHandler(fb2, msg.seqid);
        try {
            fn2.start(this.iface, args, resultHandler);
        }
        catch (Exception e3) {
            resultHandler.onError(e3);
        }
        return true;
    }

    @Override
    public boolean process(TProtocol in2, TProtocol out) {
        return false;
    }
}

