/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.AbstractNonblockingServer$AbstractSelectThread;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBufferState;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;

public class AbstractNonblockingServer$FrameBuffer {
    private final YA LOGGER = YB.a(this.getClass().getName());
    protected final TNonblockingTransport trans_;
    protected final SelectionKey selectionKey_;
    protected final AbstractNonblockingServer$AbstractSelectThread selectThread_;
    protected AbstractNonblockingServer$FrameBufferState state_ = AbstractNonblockingServer$FrameBufferState.READING_FRAME_SIZE;
    protected ByteBuffer buffer_;
    protected final TByteArrayOutputStream response_;
    protected final TMemoryInputTransport frameTrans_;
    protected final TTransport inTrans_;
    protected final TTransport outTrans_;
    protected final TProtocol inProt_;
    protected final TProtocol outProt_;
    protected final ServerContext context_;
    final /* synthetic */ AbstractNonblockingServer this$0;

    public AbstractNonblockingServer$FrameBuffer(AbstractNonblockingServer this$0, TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer$AbstractSelectThread selectThread) {
        this.this$0 = this$0;
        this.trans_ = trans;
        this.selectionKey_ = selectionKey;
        this.selectThread_ = selectThread;
        this.buffer_ = ByteBuffer.allocate(4);
        this.frameTrans_ = new TMemoryInputTransport();
        this.response_ = new TByteArrayOutputStream();
        this.inTrans_ = this$0.inputTransportFactory_.getTransport(this.frameTrans_);
        this.outTrans_ = this$0.outputTransportFactory_.getTransport(new TIOStreamTransport(this.response_));
        this.inProt_ = this$0.inputProtocolFactory_.getProtocol(this.inTrans_);
        this.outProt_ = this$0.outputProtocolFactory_.getProtocol(this.outTrans_);
        this.context_ = this$0.eventHandler_ != null ? this$0.eventHandler_.createContext(this.inProt_, this.outProt_) : null;
    }

    public boolean read() {
        if (this.state_ == AbstractNonblockingServer$FrameBufferState.READING_FRAME_SIZE) {
            if (!this.internalRead()) {
                return false;
            }
            if (this.buffer_.remaining() == 0) {
                int frameSize = this.buffer_.getInt(0);
                if (frameSize <= 0) {
                    this.LOGGER.error("Read an invalid frame size of " + frameSize + ". Are you using TFramedTransport on the client side?");
                    return false;
                }
                if ((long)frameSize > this.this$0.MAX_READ_BUFFER_BYTES) {
                    this.LOGGER.error("Read a frame size of " + frameSize + ", which is bigger than the maximum allowable buffer size for ALL connections.");
                    return false;
                }
                if (this.this$0.readBufferBytesAllocated.get() + (long)frameSize > this.this$0.MAX_READ_BUFFER_BYTES) {
                    return true;
                }
                this.this$0.readBufferBytesAllocated.addAndGet(frameSize + 4);
                this.buffer_ = ByteBuffer.allocate(frameSize + 4);
                this.buffer_.putInt(frameSize);
                this.state_ = AbstractNonblockingServer$FrameBufferState.READING_FRAME;
            } else {
                return true;
            }
        }
        if (this.state_ == AbstractNonblockingServer$FrameBufferState.READING_FRAME) {
            if (!this.internalRead()) {
                return false;
            }
            if (this.buffer_.remaining() == 0) {
                this.selectionKey_.interestOps(0);
                this.state_ = AbstractNonblockingServer$FrameBufferState.READ_FRAME_COMPLETE;
            }
            return true;
        }
        this.LOGGER.error("Read was called but state is invalid (" + (Object)((Object)this.state_) + ")");
        return false;
    }

    public boolean write() {
        if (this.state_ == AbstractNonblockingServer$FrameBufferState.WRITING) {
            try {
                if (this.trans_.write(this.buffer_) < 0) {
                    return false;
                }
            }
            catch (IOException e2) {
                this.LOGGER.warn("Got an IOException during write!", e2);
                return false;
            }
            if (this.buffer_.remaining() == 0) {
                this.prepareRead();
            }
            return true;
        }
        this.LOGGER.error("Write was called, but state is invalid (" + (Object)((Object)this.state_) + ")");
        return false;
    }

    public void changeSelectInterests() {
        if (this.state_ == AbstractNonblockingServer$FrameBufferState.AWAITING_REGISTER_WRITE) {
            this.selectionKey_.interestOps(4);
            this.state_ = AbstractNonblockingServer$FrameBufferState.WRITING;
        } else if (this.state_ == AbstractNonblockingServer$FrameBufferState.AWAITING_REGISTER_READ) {
            this.prepareRead();
        } else if (this.state_ == AbstractNonblockingServer$FrameBufferState.AWAITING_CLOSE) {
            this.close();
            this.selectionKey_.cancel();
        } else {
            this.LOGGER.error("changeSelectInterest was called, but state is invalid (" + (Object)((Object)this.state_) + ")");
        }
    }

    public void close() {
        if (this.state_ == AbstractNonblockingServer$FrameBufferState.READING_FRAME || this.state_ == AbstractNonblockingServer$FrameBufferState.READ_FRAME_COMPLETE || this.state_ == AbstractNonblockingServer$FrameBufferState.AWAITING_CLOSE) {
            this.this$0.readBufferBytesAllocated.addAndGet(-this.buffer_.array().length);
        }
        this.trans_.close();
        if (this.this$0.eventHandler_ != null) {
            this.this$0.eventHandler_.deleteContext(this.context_, this.inProt_, this.outProt_);
        }
    }

    public boolean isFrameFullyRead() {
        return this.state_ == AbstractNonblockingServer$FrameBufferState.READ_FRAME_COMPLETE;
    }

    public void responseReady() {
        this.this$0.readBufferBytesAllocated.addAndGet(-this.buffer_.array().length);
        if (this.response_.len() == 0) {
            this.state_ = AbstractNonblockingServer$FrameBufferState.AWAITING_REGISTER_READ;
            this.buffer_ = null;
        } else {
            this.buffer_ = ByteBuffer.wrap(this.response_.get(), 0, this.response_.len());
            this.state_ = AbstractNonblockingServer$FrameBufferState.AWAITING_REGISTER_WRITE;
        }
        this.requestSelectInterestChange();
    }

    public void invoke() {
        this.frameTrans_.reset(this.buffer_.array());
        this.response_.reset();
        try {
            if (this.this$0.eventHandler_ != null) {
                this.this$0.eventHandler_.processContext(this.context_, this.inTrans_, this.outTrans_);
            }
            this.this$0.processorFactory_.getProcessor(this.inTrans_).process(this.inProt_, this.outProt_);
            this.responseReady();
            return;
        }
        catch (TException te2) {
            this.LOGGER.warn("Exception while invoking!", te2);
        }
        catch (Throwable t2) {
            this.LOGGER.error("Unexpected throwable while invoking!", t2);
        }
        this.state_ = AbstractNonblockingServer$FrameBufferState.AWAITING_CLOSE;
        this.requestSelectInterestChange();
    }

    private boolean internalRead() {
        try {
            return this.trans_.read(this.buffer_) >= 0;
        }
        catch (IOException e2) {
            this.LOGGER.warn("Got an IOException in internalRead!", e2);
            return false;
        }
    }

    private void prepareRead() {
        this.selectionKey_.interestOps(1);
        this.buffer_ = ByteBuffer.allocate(4);
        this.state_ = AbstractNonblockingServer$FrameBufferState.READING_FRAME_SIZE;
    }

    protected void requestSelectInterestChange() {
        if (Thread.currentThread() == this.selectThread_) {
            this.changeSelectInterests();
        } else {
            this.selectThread_.requestSelectInterestChange(this);
        }
    }
}

