/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.thrift.server.AbstractNonblockingServer$AbstractNonblockingServerArgs;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;

public abstract class AbstractNonblockingServer
extends TServer {
    protected final YA LOGGER = YB.a(this.getClass().getName());
    final long MAX_READ_BUFFER_BYTES;
    final AtomicLong readBufferBytesAllocated = new AtomicLong(0L);

    public AbstractNonblockingServer(AbstractNonblockingServer$AbstractNonblockingServerArgs args) {
        super(args);
        this.MAX_READ_BUFFER_BYTES = args.maxReadBufferBytes;
    }

    @Override
    public void serve() {
        if (!this.startThreads()) {
            return;
        }
        if (!this.startListening()) {
            return;
        }
        this.setServing(true);
        this.waitForShutdown();
        this.setServing(false);
        this.stopListening();
    }

    protected abstract boolean startThreads();

    protected abstract void waitForShutdown();

    protected boolean startListening() {
        try {
            this.serverTransport_.listen();
            return true;
        }
        catch (TTransportException ttx) {
            this.LOGGER.error("Failed to start listening on server socket!", ttx);
            return false;
        }
    }

    protected void stopListening() {
        this.serverTransport_.close();
    }

    protected abstract boolean requestInvoke(AbstractNonblockingServer$FrameBuffer var1);
}

