/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TExtensibleServlet$1;
import org.apache.thrift.transport.TIOStreamTransport;

public abstract class TExtensibleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private TProcessor processor;
    private TProtocolFactory inFactory;
    private TProtocolFactory outFactory;
    private Collection<Map.Entry<String, String>> customHeaders;

    protected abstract TProcessor getProcessor();

    protected abstract TProtocolFactory getInProtocolFactory();

    protected abstract TProtocolFactory getOutProtocolFactory();

    public final void init(ServletConfig config) {
        super.init(config);
        this.processor = this.getProcessor();
        this.inFactory = this.getInProtocolFactory();
        this.outFactory = this.getOutProtocolFactory();
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
        if (this.processor == null) {
            throw new ServletException("processor must be set");
        }
        if (this.inFactory == null) {
            throw new ServletException("inFactory must be set");
        }
        if (this.outFactory == null) {
            throw new ServletException("outFactory must be set");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        TIOStreamTransport inTransport = null;
        TIOStreamTransport outTransport = null;
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in2 = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            inTransport = transport = new TIOStreamTransport((InputStream)in2, (OutputStream)out);
            outTransport = transport;
            TProtocol inProtocol = this.inFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.inFactory.getProtocol(outTransport);
            this.processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te2) {
            throw new ServletException((Throwable)te2);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doPost(req, resp);
    }

    public void addCustomHeader(String key, String value) {
        this.customHeaders.add(new TExtensibleServlet$1(this, key, value));
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

