/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServlet$1;
import org.apache.thrift.transport.TIOStreamTransport;

public class TServlet
extends HttpServlet {
    private final TProcessor processor;
    private final TProtocolFactory inProtocolFactory;
    private final TProtocolFactory outProtocolFactory;
    private final Collection<Map.Entry<String, String>> customHeaders;

    public TServlet(TProcessor processor, TProtocolFactory inProtocolFactory, TProtocolFactory outProtocolFactory) {
        this.processor = processor;
        this.inProtocolFactory = inProtocolFactory;
        this.outProtocolFactory = outProtocolFactory;
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
    }

    public TServlet(TProcessor processor, TProtocolFactory protocolFactory) {
        this(processor, protocolFactory, protocolFactory);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        TIOStreamTransport inTransport = null;
        TIOStreamTransport outTransport = null;
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in2 = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            inTransport = transport = new TIOStreamTransport((InputStream)in2, (OutputStream)out);
            outTransport = transport;
            TProtocol inProtocol = this.inProtocolFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.outProtocolFactory.getProtocol(outTransport);
            this.processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te2) {
            throw new ServletException((Throwable)te2);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    public void addCustomHeader(String key, String value) {
        this.customHeaders.add(new TServlet$1(this, key, value));
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

