/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.server.TThreadedSelectorServer$AcceptThread$1;
import org.apache.thrift.server.TThreadedSelectorServer$Args;
import org.apache.thrift.server.TThreadedSelectorServer$Args$AcceptPolicy;
import org.apache.thrift.server.TThreadedSelectorServer$SelectorThread;
import org.apache.thrift.server.TThreadedSelectorServer$SelectorThreadLoadBalancer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;

public class TThreadedSelectorServer$AcceptThread
extends Thread {
    private final TNonblockingServerTransport serverTransport;
    private final Selector acceptSelector;
    private final TThreadedSelectorServer$SelectorThreadLoadBalancer threadChooser;
    final /* synthetic */ TThreadedSelectorServer this$0;

    public TThreadedSelectorServer$AcceptThread(TThreadedSelectorServer this$0, TNonblockingServerTransport serverTransport, TThreadedSelectorServer$SelectorThreadLoadBalancer threadChooser) {
        this.this$0 = this$0;
        this.serverTransport = serverTransport;
        this.threadChooser = threadChooser;
        this.acceptSelector = SelectorProvider.provider().openSelector();
        this.serverTransport.registerSelector(this.acceptSelector);
    }

    @Override
    public void run() {
        try {
            if (this.this$0.eventHandler_ != null) {
                this.this$0.eventHandler_.preServe();
            }
            while (!this.this$0.stopped_) {
                this.select();
            }
        }
        catch (Throwable t2) {
            TThreadedSelectorServer.access$500().error("run() on AcceptThread exiting due to uncaught error", t2);
        }
        finally {
            try {
                this.acceptSelector.close();
            }
            catch (IOException e2) {
                TThreadedSelectorServer.access$500().error("Got an IOException while closing accept selector!", e2);
            }
            this.this$0.stop();
        }
    }

    public void wakeupSelector() {
        this.acceptSelector.wakeup();
    }

    private void select() {
        try {
            this.acceptSelector.select();
            Iterator<SelectionKey> selectedKeys = this.acceptSelector.selectedKeys().iterator();
            while (!this.this$0.stopped_ && selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.handleAccept();
                    continue;
                }
                TThreadedSelectorServer.access$500().warn("Unexpected state in select! " + key.interestOps());
            }
        }
        catch (IOException e2) {
            TThreadedSelectorServer.access$500().warn("Got an IOException while selecting!", e2);
        }
    }

    private void handleAccept() {
        TNonblockingTransport client = this.doAccept();
        if (client != null) {
            TThreadedSelectorServer$SelectorThread targetThread = this.threadChooser.nextThread();
            if (TThreadedSelectorServer$Args.access$700(TThreadedSelectorServer.access$600(this.this$0)) == TThreadedSelectorServer$Args$AcceptPolicy.FAST_ACCEPT || TThreadedSelectorServer.access$800(this.this$0) == null) {
                this.doAddAccept(targetThread, client);
            } else {
                try {
                    TThreadedSelectorServer.access$800(this.this$0).submit(new TThreadedSelectorServer$AcceptThread$1(this, targetThread, client));
                }
                catch (RejectedExecutionException rx2) {
                    TThreadedSelectorServer.access$500().warn("ExecutorService rejected accept registration!", rx2);
                    client.close();
                }
            }
        }
    }

    private TNonblockingTransport doAccept() {
        try {
            return (TNonblockingTransport)this.serverTransport.accept();
        }
        catch (TTransportException tte) {
            TThreadedSelectorServer.access$500().warn("Exception trying to accept!", tte);
            return null;
        }
    }

    private void doAddAccept(TThreadedSelectorServer$SelectorThread thread, TNonblockingTransport client) {
        if (!thread.addAcceptedConnection(client)) {
            client.close();
        }
    }

    static /* synthetic */ void access$900(TThreadedSelectorServer$AcceptThread x0, TThreadedSelectorServer$SelectorThread x1, TNonblockingTransport x2) {
        x0.doAddAccept(x1, x2);
    }
}

