/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import org.apache.thrift.transport.AutoExpandingBufferReadTransport;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TFastFramedTransport
extends TTransport {
    public static final int DEFAULT_BUF_CAPACITY = 1024;
    public static final int DEFAULT_MAX_LENGTH = 0xFA0000;
    private final TTransport underlying;
    private final AutoExpandingBufferWriteTransport writeBuffer;
    private AutoExpandingBufferReadTransport readBuffer;
    private final int initialBufferCapacity;
    private final byte[] i32buf = new byte[4];
    private final int maxLength;

    public TFastFramedTransport(TTransport underlying) {
        this(underlying, 1024, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity) {
        this(underlying, initialBufferCapacity, 0xFA0000);
    }

    public TFastFramedTransport(TTransport underlying, int initialBufferCapacity, int maxLength) {
        this.underlying = underlying;
        this.maxLength = maxLength;
        this.initialBufferCapacity = initialBufferCapacity;
        this.writeBuffer = new AutoExpandingBufferWriteTransport(initialBufferCapacity, 1.5);
        this.readBuffer = new AutoExpandingBufferReadTransport(initialBufferCapacity, 1.5);
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public void open() {
        this.underlying.open();
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        int got = this.readBuffer.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer.read(buf, off, len);
    }

    private void readFrame() {
        this.underlying.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeFrameSize(this.i32buf);
        if (size < 0) {
            this.close();
            throw new TTransportException(5, "Read a negative frame size (" + size + ")!");
        }
        if (size > this.maxLength) {
            this.close();
            throw new TTransportException(5, "Frame size (" + size + ") larger than max length (" + this.maxLength + ")!");
        }
        this.readBuffer.fill(this.underlying, size);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.writeBuffer.write(buf, off, len);
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer.consumeBuffer(len);
    }

    public void clear() {
        this.readBuffer = new AutoExpandingBufferReadTransport(this.initialBufferCapacity, 1.5);
    }

    @Override
    public void flush() {
        int length = this.writeBuffer.getPos();
        TFramedTransport.encodeFrameSize(length, this.i32buf);
        this.underlying.write(this.i32buf, 0, 4);
        this.underlying.write(this.writeBuffer.getBuf().array(), 0, length);
        this.writeBuffer.reset();
        this.underlying.flush();
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer.getBufferPosition();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.readBuffer.getBytesRemainingInBuffer();
    }
}

