/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.thrift.transport.TSSLTransportFactory$TSSLTransportParameters;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerSocket$ServerSocketTransportArgs;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;

public class TSSLTransportFactory {
    public static TServerSocket getServerSocket(int port) {
        return TSSLTransportFactory.getServerSocket(port, 0);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout) {
        return TSSLTransportFactory.getServerSocket(port, clientTimeout, false, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, boolean clientAuth, InetAddress ifAddress) {
        SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        return TSSLTransportFactory.createServer(factory, port, clientTimeout, clientAuth, ifAddress, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, InetAddress ifAddress, TSSLTransportFactory$TSSLTransportParameters params) {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = TSSLTransportFactory.createSSLContext(params);
        return TSSLTransportFactory.createServer(ctx.getServerSocketFactory(), port, clientTimeout, params.clientAuth, ifAddress, params);
    }

    private static TServerSocket createServer(SSLServerSocketFactory factory, int port, int timeout, boolean clientAuth, InetAddress ifAddress, TSSLTransportFactory$TSSLTransportParameters params) {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(port, 100, ifAddress);
            serverSocket.setSoTimeout(timeout);
            serverSocket.setNeedClientAuth(clientAuth);
            if (params != null && params.cipherSuites != null) {
                serverSocket.setEnabledCipherSuites(params.cipherSuites);
            }
            return new TServerSocket((TServerSocket$ServerSocketTransportArgs)new TServerSocket$ServerSocketTransportArgs().serverSocket(serverSocket).clientTimeout(timeout));
        }
        catch (Exception e2) {
            throw new TTransportException("Could not bind to port " + port, (Throwable)e2);
        }
    }

    public static TSocket getClientSocket(String host, int port, int timeout) {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return TSSLTransportFactory.createClient(factory, host, port, timeout);
    }

    public static TSocket getClientSocket(String host, int port) {
        return TSSLTransportFactory.getClientSocket(host, port, 0);
    }

    public static TSocket getClientSocket(String host, int port, int timeout, TSSLTransportFactory$TSSLTransportParameters params) {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = TSSLTransportFactory.createSSLContext(params);
        return TSSLTransportFactory.createClient(ctx.getSocketFactory(), host, port, timeout);
    }

    private static SSLContext createSSLContext(TSSLTransportFactory$TSSLTransportParameters params) {
        SSLContext ctx;
        InputStream in2 = null;
        InputStream is2 = null;
        try {
            ctx = SSLContext.getInstance(params.protocol);
            TrustManagerFactory tmf = null;
            KeyManagerFactory kmf = null;
            if (params.isTrustStoreSet) {
                tmf = TrustManagerFactory.getInstance(params.trustManagerType);
                KeyStore ts2 = KeyStore.getInstance(params.trustStoreType);
                in2 = TSSLTransportFactory.getStoreAsStream(params.trustStore);
                ts2.load(in2, params.trustPass != null ? params.trustPass.toCharArray() : null);
                tmf.init(ts2);
            }
            if (params.isKeyStoreSet) {
                kmf = KeyManagerFactory.getInstance(params.keyManagerType);
                KeyStore ks2 = KeyStore.getInstance(params.keyStoreType);
                is2 = TSSLTransportFactory.getStoreAsStream(params.keyStore);
                ks2.load(is2, params.keyPass.toCharArray());
                kmf.init(ks2, params.keyPass.toCharArray());
            }
            if (params.isKeyStoreSet && params.isTrustStoreSet) {
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else if (params.isKeyStoreSet) {
                ctx.init(kmf.getKeyManagers(), null, null);
            } else {
                ctx.init(null, tmf.getTrustManagers(), null);
            }
        }
        catch (Exception e2) {
            throw new TTransportException("Error creating the transport", (Throwable)e2);
        }
        finally {
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        return ctx;
    }

    private static InputStream getStoreAsStream(String store) {
        try {
            return new FileInputStream(store);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream storeStream = null;
            try {
                storeStream = new URL(store).openStream();
                if (storeStream != null) {
                    return storeStream;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            storeStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(store);
            if (storeStream != null) {
                return storeStream;
            }
            throw new IOException("Could not load file: " + store);
        }
    }

    private static TSocket createClient(SSLSocketFactory factory, String host, int port, int timeout) {
        try {
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(timeout);
            return new TSocket(socket);
        }
        catch (Exception e2) {
            throw new TTransportException("Could not connect to " + host + " on port " + port, (Throwable)e2);
        }
    }
}

