/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.DB;

public abstract class Function {
    private SQLiteConnection conn;
    private DB db;
    long context = 0L;
    long value = 0L;
    int args = 0;

    public static final void create(Connection conn, String name, Function f2) {
        if (conn == null || !(conn instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        if (conn.isClosed()) {
            throw new SQLException("connection closed");
        }
        f2.conn = (SQLiteConnection)conn;
        f2.db = f2.conn.db();
        if (name == null || name.length() > 255) {
            throw new SQLException("invalid function name: '" + name + "'");
        }
        if (f2.db.create_function(name, f2) != 0) {
            throw new SQLException("error creating function");
        }
    }

    public static final void destroy(Connection conn, String name) {
        if (conn == null || !(conn instanceof SQLiteConnection)) {
            throw new SQLException("connection must be to an SQLite db");
        }
        ((SQLiteConnection)conn).db().destroy_function(name);
    }

    protected abstract void xFunc();

    protected final synchronized int args() {
        this.checkContext();
        return this.args;
    }

    protected final synchronized void result(byte[] value) {
        this.checkContext();
        this.db.result_blob(this.context, value);
    }

    protected final synchronized void result(double value) {
        this.checkContext();
        this.db.result_double(this.context, value);
    }

    protected final synchronized void result(int value) {
        this.checkContext();
        this.db.result_int(this.context, value);
    }

    protected final synchronized void result(long value) {
        this.checkContext();
        this.db.result_long(this.context, value);
    }

    protected final synchronized void result() {
        this.checkContext();
        this.db.result_null(this.context);
    }

    protected final synchronized void result(String value) {
        this.checkContext();
        this.db.result_text(this.context, value);
    }

    protected final synchronized void error(String err) {
        this.checkContext();
        this.db.result_error(this.context, err);
    }

    protected final synchronized String value_text(int arg) {
        this.checkValue(arg);
        return this.db.value_text(this, arg);
    }

    protected final synchronized byte[] value_blob(int arg) {
        this.checkValue(arg);
        return this.db.value_blob(this, arg);
    }

    protected final synchronized double value_double(int arg) {
        this.checkValue(arg);
        return this.db.value_double(this, arg);
    }

    protected final synchronized int value_int(int arg) {
        this.checkValue(arg);
        return this.db.value_int(this, arg);
    }

    protected final synchronized long value_long(int arg) {
        this.checkValue(arg);
        return this.db.value_long(this, arg);
    }

    protected final synchronized int value_type(int arg) {
        this.checkValue(arg);
        return this.db.value_type(this, arg);
    }

    private void checkContext() {
        if (this.conn == null || this.conn.db() == null || this.context == 0L) {
            throw new SQLException("no context, not allowed to read value");
        }
    }

    private void checkValue(int arg) {
        if (this.conn == null || this.conn.db() == null || this.value == 0L) {
            throw new SQLException("not in value access state");
        }
        if (arg >= this.args) {
            throw new SQLException("arg " + arg + " out bounds [0," + this.args + ")");
        }
    }
}

