/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.sqlite.SQLiteOpenMode;
import org.sqlite.core.CoreConnection;
import org.sqlite.jdbc3.JDBC3Savepoint;

public abstract class JDBC3Connection
extends CoreConnection {
    private final AtomicInteger savePoint = new AtomicInteger(0);
    private Map<String, Class<?>> typeMap;

    protected JDBC3Connection(String url, String fileName, Properties prop) {
        super(url, fileName, prop);
    }

    public String getCatalog() {
        this.checkOpen();
        return null;
    }

    public void setCatalog(String catalog) {
        this.checkOpen();
    }

    public int getHoldability() {
        this.checkOpen();
        return 2;
    }

    public void setHoldability(int h2) {
        this.checkOpen();
        if (h2 != 2) {
            throw new SQLException("SQLite only supports CLOSE_CURSORS_AT_COMMIT");
        }
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int level) {
        this.checkOpen();
        switch (level) {
            case 8: {
                this.db.exec("PRAGMA read_uncommitted = false;");
                break;
            }
            case 1: {
                this.db.exec("PRAGMA read_uncommitted = true;");
                break;
            }
            default: {
                throw new SQLException("SQLite supports only TRANSACTION_SERIALIZABLE and TRANSACTION_READ_UNCOMMITTED.");
            }
        }
        this.transactionIsolation = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getTypeMap() {
        JDBC3Connection jDBC3Connection = this;
        synchronized (jDBC3Connection) {
            if (this.typeMap == null) {
                this.typeMap = new HashMap();
            }
            return this.typeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMap(Map map) {
        JDBC3Connection jDBC3Connection = this;
        synchronized (jDBC3Connection) {
            this.typeMap = map;
        }
    }

    public boolean isReadOnly() {
        return (this.openModeFlags & SQLiteOpenMode.READONLY.flag) != 0;
    }

    public void setReadOnly(boolean ro2) {
        if (ro2 != this.isReadOnly()) {
            throw new SQLException("Cannot change read-only flag after establishing a connection. Use SQLiteConfig#setReadOnly and SQLiteConfig.createConnection().");
        }
    }

    public String nativeSQL(String sql) {
        return sql;
    }

    public void clearWarnings() {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public boolean getAutoCommit() {
        this.checkOpen();
        return this.autoCommit;
    }

    public void setAutoCommit(boolean ac2) {
        this.checkOpen();
        if (this.autoCommit == ac2) {
            return;
        }
        this.autoCommit = ac2;
        this.db.exec(this.autoCommit ? "commit;" : (String)beginCommandMap.get(this.transactionMode));
    }

    public void commit() {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("commit;");
        this.db.exec((String)beginCommandMap.get(this.transactionMode));
    }

    public void rollback() {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("rollback;");
        this.db.exec((String)beginCommandMap.get(this.transactionMode));
    }

    public Statement createStatement() {
        return this.createStatement(1003, 1007, 2);
    }

    public Statement createStatement(int rsType, int rsConcurr) {
        return this.createStatement(rsType, rsConcurr, 2);
    }

    public abstract Statement createStatement(int var1, int var2, int var3);

    public CallableStatement prepareCall(String sql) {
        return this.prepareCall(sql, 1003, 1007, 2);
    }

    public CallableStatement prepareCall(String sql, int rst, int rsc) {
        return this.prepareCall(sql, rst, rsc, 2);
    }

    public CallableStatement prepareCall(String sql, int rst, int rsc, int rsh) {
        throw new SQLException("SQLite does not support Stored Procedures");
    }

    public PreparedStatement prepareStatement(String sql) {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoC) {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] colInds) {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, String[] colNames) {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int rst, int rsc) {
        return this.prepareStatement(sql, rst, rsc, 2);
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4);

    public Savepoint setSavepoint() {
        this.checkOpen();
        if (this.autoCommit) {
            this.autoCommit = false;
        }
        JDBC3Savepoint sp2 = new JDBC3Savepoint(this.savePoint.incrementAndGet());
        this.db.exec(String.format("SAVEPOINT %s", sp2.getSavepointName()));
        return sp2;
    }

    public Savepoint setSavepoint(String name) {
        this.checkOpen();
        if (this.autoCommit) {
            this.autoCommit = false;
        }
        JDBC3Savepoint sp2 = new JDBC3Savepoint(this.savePoint.incrementAndGet(), name);
        this.db.exec(String.format("SAVEPOINT %s", sp2.getSavepointName()));
        return sp2;
    }

    public void releaseSavepoint(Savepoint savepoint) {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec(String.format("RELEASE SAVEPOINT %s", savepoint.getSavepointName()));
    }

    public void rollback(Savepoint savepoint) {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec(String.format("ROLLBACK TO SAVEPOINT %s", savepoint.getSavepointName()));
    }

    public Struct createStruct(String t2, Object[] attr) {
        throw new SQLException("unsupported by SQLite");
    }
}

