/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.CoreStatement;
import org.sqlite.date.FastDateFormat;

public abstract class JDBC3ResultSet
extends CoreResultSet {
    protected static final Pattern COLUMN_TYPENAME = Pattern.compile("([^\\(]*)");
    protected static final Pattern COLUMN_TYPECAST = Pattern.compile("cast\\(.*?\\s+as\\s+(.*?)\\s*\\)");
    protected static final Pattern COLUMN_PRECISION = Pattern.compile(".*?\\((.*?)\\)");

    protected JDBC3ResultSet(CoreStatement stmt) {
        super(stmt);
    }

    public int findColumn(String col) {
        this.checkOpen();
        Integer index = this.findColumnIndexInCache(col);
        if (index != null) {
            return index;
        }
        for (int i2 = 0; i2 < this.cols.length; ++i2) {
            if (!col.equalsIgnoreCase(this.cols[i2])) continue;
            return this.addColumnIndexInCache(col, i2 + 1);
        }
        throw new SQLException("no such column: '" + col + "'");
    }

    public boolean next() {
        if (!this.open) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 0) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0 && this.row == this.maxRows) {
            return false;
        }
        int statusCode = this.db.step(this.stmt.pointer);
        switch (statusCode) {
            case 101: {
                this.close();
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
        }
        this.db.throwex(statusCode);
        return false;
    }

    public int getType() {
        return 1003;
    }

    public int getFetchSize() {
        return this.limitRows;
    }

    public void setFetchSize(int rows) {
        if (0 > rows || this.maxRows != 0 && rows > this.maxRows) {
            throw new SQLException("fetch size " + rows + " out of bounds " + this.maxRows);
        }
        this.limitRows = rows;
    }

    public int getFetchDirection() {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int d2) {
        this.checkOpen();
        if (d2 != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() {
        return !this.open;
    }

    public boolean isBeforeFirst() {
        return this.open && this.row == 0;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isLast() {
        throw new SQLException("function not yet implemented for SQLite");
    }

    protected void finalize() {
        this.close();
    }

    public int getRow() {
        return this.row;
    }

    public boolean wasNull() {
        return this.db.column_type(this.stmt.pointer, this.markCol(this.lastCol)) == 5;
    }

    public BigDecimal getBigDecimal(int col) {
        String stringValue = this.getString(col);
        if (stringValue == null) {
            return null;
        }
        try {
            return new BigDecimal(stringValue);
        }
        catch (NumberFormatException e2) {
            throw new SQLException("Bad value for type BigDecimal : " + stringValue);
        }
    }

    public BigDecimal getBigDecimal(String col) {
        return this.getBigDecimal(this.findColumn(col));
    }

    public boolean getBoolean(int col) {
        return this.getInt(col) != 0;
    }

    public boolean getBoolean(String col) {
        return this.getBoolean(this.findColumn(col));
    }

    public InputStream getBinaryStream(int col) {
        byte[] bytes = this.getBytes(col);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public InputStream getBinaryStream(String col) {
        return this.getBinaryStream(this.findColumn(col));
    }

    public byte getByte(int col) {
        return (byte)this.getInt(col);
    }

    public byte getByte(String col) {
        return this.getByte(this.findColumn(col));
    }

    public byte[] getBytes(int col) {
        return this.db.column_blob(this.stmt.pointer, this.markCol(col));
    }

    public byte[] getBytes(String col) {
        return this.getBytes(this.findColumn(col));
    }

    public Reader getCharacterStream(int col) {
        return new StringReader(this.getString(col));
    }

    public Reader getCharacterStream(String col) {
        return this.getCharacterStream(this.findColumn(col));
    }

    public Date getDate(int col) {
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Date(this.stmt.conn.dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing date");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col))).getTimeInMillis());
            }
        }
        return new Date(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
    }

    public Date getDate(int col, Calendar cal) {
        this.checkCalendar(cal);
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.stmt.conn.dateStringFormat, cal.getTimeZone());
                    return new Date(dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing time stamp");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col)), cal).getTimeInMillis());
            }
        }
        cal.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
        return new Date(cal.getTime().getTime());
    }

    public Date getDate(String col) {
        return this.getDate(this.findColumn(col), Calendar.getInstance());
    }

    public Date getDate(String col, Calendar cal) {
        return this.getDate(this.findColumn(col), cal);
    }

    public double getDouble(int col) {
        if (this.db.column_type(this.stmt.pointer, this.markCol(col)) == 5) {
            return 0.0;
        }
        return this.db.column_double(this.stmt.pointer, this.markCol(col));
    }

    public double getDouble(String col) {
        return this.getDouble(this.findColumn(col));
    }

    public float getFloat(int col) {
        if (this.db.column_type(this.stmt.pointer, this.markCol(col)) == 5) {
            return 0.0f;
        }
        return (float)this.db.column_double(this.stmt.pointer, this.markCol(col));
    }

    public float getFloat(String col) {
        return this.getFloat(this.findColumn(col));
    }

    public int getInt(int col) {
        return this.db.column_int(this.stmt.pointer, this.markCol(col));
    }

    public int getInt(String col) {
        return this.getInt(this.findColumn(col));
    }

    public long getLong(int col) {
        return this.db.column_long(this.stmt.pointer, this.markCol(col));
    }

    public long getLong(String col) {
        return this.getLong(this.findColumn(col));
    }

    public short getShort(int col) {
        return (short)this.getInt(col);
    }

    public short getShort(String col) {
        return this.getShort(this.findColumn(col));
    }

    public String getString(int col) {
        return this.db.column_text(this.stmt.pointer, this.markCol(col));
    }

    public String getString(String col) {
        return this.getString(this.findColumn(col));
    }

    public Time getTime(int col) {
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Time(this.stmt.conn.dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing time");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col))).getTimeInMillis());
            }
        }
        return new Time(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
    }

    public Time getTime(int col, Calendar cal) {
        this.checkCalendar(cal);
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.stmt.conn.dateStringFormat, cal.getTimeZone());
                    return new Time(dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing time");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col)), cal).getTimeInMillis());
            }
        }
        cal.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
        return new Time(cal.getTime().getTime());
    }

    public Time getTime(String col) {
        return this.getTime(this.findColumn(col));
    }

    public Time getTime(String col, Calendar cal) {
        return this.getTime(this.findColumn(col), cal);
    }

    public Timestamp getTimestamp(int col) {
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Timestamp(this.stmt.conn.dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing time stamp");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col))).getTimeInMillis());
            }
        }
        return new Timestamp(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
    }

    public Timestamp getTimestamp(int col, Calendar cal) {
        if (cal == null) {
            return this.getTimestamp(col);
        }
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.stmt.conn.dateStringFormat, cal.getTimeZone());
                    return new Timestamp(dateFormat.parse(this.db.column_text(this.stmt.pointer, this.markCol(col))).getTime());
                }
                catch (Exception e2) {
                    SQLException error = new SQLException("Error parsing time stamp");
                    error.initCause(e2);
                    throw error;
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(this.db.column_double(this.stmt.pointer, this.markCol(col)), cal).getTimeInMillis());
            }
        }
        cal.setTimeInMillis(this.db.column_long(this.stmt.pointer, this.markCol(col)) * this.stmt.conn.dateMultiplier);
        return new Timestamp(cal.getTime().getTime());
    }

    public Timestamp getTimestamp(String col) {
        return this.getTimestamp(this.findColumn(col));
    }

    public Timestamp getTimestamp(String c2, Calendar ca2) {
        return this.getTimestamp(this.findColumn(c2), ca2);
    }

    public Object getObject(int col) {
        switch (this.db.column_type(this.stmt.pointer, this.markCol(col))) {
            case 1: {
                long val = this.getLong(col);
                if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                    return new Long(val);
                }
                return new Integer((int)val);
            }
            case 2: {
                return new Double(this.getDouble(col));
            }
            case 4: {
                return this.getBytes(col);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(col);
    }

    public Object getObject(String col) {
        return this.getObject(this.findColumn(col));
    }

    public Statement getStatement() {
        return (Statement)((Object)this.stmt);
    }

    public String getCursorName() {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this);
    }

    public String getCatalogName(int col) {
        return this.db.column_table_name(this.stmt.pointer, this.checkCol(col));
    }

    public String getColumnClassName(int col) {
        this.checkCol(col);
        return "java.lang.Object";
    }

    public int getColumnCount() {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int col) {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int col) {
        return this.getColumnName(col);
    }

    public String getColumnName(int col) {
        return this.db.column_name(this.stmt.pointer, this.checkCol(col));
    }

    public int getColumnType(int col) {
        String typeName = this.getColumnTypeName(col);
        int valueType = this.db.column_type(this.stmt.pointer, this.checkCol(col));
        if (valueType == 1 || valueType == 5) {
            if ("BOOLEAN".equals(typeName)) {
                return 16;
            }
            if ("TINYINT".equals(typeName)) {
                return -6;
            }
            if ("SMALLINT".equals(typeName) || "INT2".equals(typeName)) {
                return 5;
            }
            if ("BIGINT".equals(typeName) || "INT8".equals(typeName) || "UNSIGNED BIG INT".equals(typeName)) {
                return -5;
            }
            if ("DATE".equals(typeName) || "DATETIME".equals(typeName)) {
                return 91;
            }
            if ("TIMESTAMP".equals(typeName)) {
                return 93;
            }
            if (valueType == 1 || "INT".equals(typeName) || "INTEGER".equals(typeName) || "MEDIUMINT".equals(typeName)) {
                return 4;
            }
        }
        if (valueType == 2 || valueType == 5) {
            if ("DECIMAL".equals(typeName)) {
                return 3;
            }
            if ("DOUBLE".equals(typeName) || "DOUBLE PRECISION".equals(typeName)) {
                return 8;
            }
            if ("NUMERIC".equals(typeName)) {
                return 2;
            }
            if ("REAL".equals(typeName)) {
                return 7;
            }
            if (valueType == 2 || "FLOAT".equals(typeName)) {
                return 6;
            }
        }
        if (valueType == 3 || valueType == 5) {
            if ("CHARACTER".equals(typeName) || "NCHAR".equals(typeName) || "NATIVE CHARACTER".equals(typeName) || "CHAR".equals(typeName)) {
                return 1;
            }
            if ("CLOB".equals(typeName)) {
                return 2005;
            }
            if ("DATE".equals(typeName) || "DATETIME".equals(typeName)) {
                return 91;
            }
            if (valueType == 3 || "VARCHAR".equals(typeName) || "VARYING CHARACTER".equals(typeName) || "NVARCHAR".equals(typeName) || "TEXT".equals(typeName)) {
                return 12;
            }
        }
        if (valueType == 4 || valueType == 5) {
            if ("BINARY".equals(typeName)) {
                return -2;
            }
            if (valueType == 4 || "BLOB".equals(typeName)) {
                return 2004;
            }
        }
        return 0;
    }

    public String getColumnTypeName(int col) {
        String declType = this.getColumnDeclType(col);
        if (declType != null) {
            Matcher matcher = COLUMN_TYPENAME.matcher(declType);
            matcher.find();
            return matcher.group(1).toUpperCase(Locale.ENGLISH);
        }
        switch (this.db.column_type(this.stmt.pointer, this.checkCol(col))) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 4: {
                return "BLOB";
            }
            case 5: {
                return "NULL";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "NULL";
    }

    public int getPrecision(int col) {
        String declType = this.getColumnDeclType(col);
        if (declType != null) {
            Matcher matcher = COLUMN_PRECISION.matcher(declType);
            return matcher.find() ? Integer.parseInt(matcher.group(1).split(",")[0].trim()) : 0;
        }
        return 0;
    }

    private String getColumnDeclType(int col) {
        String declType = this.db.column_decltype(this.stmt.pointer, this.checkCol(col));
        if (declType == null) {
            Matcher matcher = COLUMN_TYPECAST.matcher(this.db.column_name(this.stmt.pointer, this.checkCol(col)));
            declType = matcher.find() ? matcher.group(1) : null;
        }
        return declType;
    }

    public int getScale(int col) {
        String[] array;
        Matcher matcher;
        String declType = this.getColumnDeclType(col);
        if (declType != null && (matcher = COLUMN_PRECISION.matcher(declType)).find() && (array = matcher.group(1).split(",")).length == 2) {
            return Integer.parseInt(array[1].trim());
        }
        return 0;
    }

    public String getSchemaName(int col) {
        return "";
    }

    public String getTableName(int col) {
        String tableName = this.db.column_table_name(this.stmt.pointer, this.checkCol(col));
        if (tableName == null) {
            return "";
        }
        return tableName;
    }

    public int isNullable(int col) {
        this.checkMeta();
        return this.meta[this.checkCol(col)][1] ? 0 : 1;
    }

    public boolean isAutoIncrement(int col) {
        this.checkMeta();
        return this.meta[this.checkCol(col)][2];
    }

    public boolean isCaseSensitive(int col) {
        return true;
    }

    public boolean isCurrency(int col) {
        return false;
    }

    public boolean isDefinitelyWritable(int col) {
        return true;
    }

    public boolean isReadOnly(int col) {
        return false;
    }

    public boolean isSearchable(int col) {
        return true;
    }

    public boolean isSigned(int col) {
        String typeName = this.getColumnTypeName(col);
        return "NUMERIC".equals(typeName) || "INTEGER".equals(typeName) || "REAL".equals(typeName);
    }

    public boolean isWritable(int col) {
        return true;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    private Calendar julianDateToCalendar(Double jd2) {
        return this.julianDateToCalendar(jd2, Calendar.getInstance());
    }

    private Calendar julianDateToCalendar(Double jd2, Calendar cal) {
        int A2;
        if (jd2 == null) {
            return null;
        }
        double w2 = jd2 + 0.5;
        int Z2 = (int)w2;
        double F2 = w2 - (double)Z2;
        if (Z2 < 2299161) {
            A2 = Z2;
        } else {
            int alpha = (int)(((double)Z2 - 1867216.25) / 36524.25);
            A2 = Z2 + 1 + alpha - (int)((double)alpha / 4.0);
        }
        int B2 = A2 + 1524;
        int C2 = (int)(((double)B2 - 122.1) / 365.25);
        int D2 = (int)(365.25 * (double)C2);
        int E2 = (int)((double)(B2 - D2) / 30.6001);
        int mm2 = E2 - ((double)E2 < 13.5 ? 1 : 13);
        int yyyy = C2 - ((double)mm2 > 2.5 ? 4716 : 4715);
        double jjd = (double)(B2 - D2 - (int)(30.6001 * (double)E2)) + F2;
        int dd2 = (int)jjd;
        double hhd = jjd - (double)dd2;
        int hh2 = (int)(24.0 * hhd);
        double mnd = 24.0 * hhd - (double)hh2;
        int mn2 = (int)(60.0 * mnd);
        double ssd = 60.0 * mnd - (double)mn2;
        int ss2 = (int)(60.0 * ssd);
        double msd = 60.0 * ssd - (double)ss2;
        int ms2 = (int)(1000.0 * msd);
        cal.set(yyyy, mm2 - 1, dd2, hh2, mn2, ss2);
        cal.set(14, ms2);
        if (yyyy < 1) {
            cal.set(0, 0);
            cal.set(1, -(yyyy - 1));
        }
        return cal;
    }

    public void checkCalendar(Calendar cal) {
        if (cal != null) {
            return;
        }
        SQLException e2 = new SQLException("Expected a calendar instance.");
        e2.initCause(new NullPointerException());
        throw e2;
    }
}

