/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public class OSInfo {
    private static HashMap<String, String> archMapping = new HashMap();

    public static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    public static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getHardwareName() {
        String string;
        block7: {
            Process p2 = Runtime.getRuntime().exec("uname -m");
            p2.waitFor();
            InputStream in2 = p2.getInputStream();
            try {
                int readLen = 0;
                ByteArrayOutputStream b2 = new ByteArrayOutputStream();
                byte[] buf = new byte[32];
                while ((readLen = in2.read(buf, 0, buf.length)) >= 0) {
                    b2.write(buf, 0, readLen);
                }
                string = b2.toString();
                if (in2 == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (in2 != null) {
                        in2.close();
                    }
                    throw throwable;
                }
                catch (Throwable e2) {
                    System.err.println("Error while running uname -m: " + e2.getMessage());
                    return "unknown";
                }
            }
            in2.close();
        }
        return string;
    }

    static String resolveArmArchType() {
        if (System.getProperty("os.name").contains("Linux")) {
            String armType = OSInfo.getHardwareName();
            if (armType.startsWith("armv6")) {
                return "armv6";
            }
            if (armType.startsWith("armv7")) {
                return "armv7";
            }
            if (armType.startsWith("armv5")) {
                return "arm";
            }
            if (armType.equals("aarch64")) {
                return "arm64";
            }
            String abi2 = System.getProperty("sun.arch.abi");
            if (abi2 != null && abi2.startsWith("gnueabihf")) {
                return "armv7";
            }
            String javaHome = System.getProperty("java.home");
            try {
                int exitCode = Runtime.getRuntime().exec("which readelf").waitFor();
                if (exitCode == 0) {
                    String[] cmdarray = new String[]{"/bin/sh", "-c", "find '" + javaHome + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                    exitCode = Runtime.getRuntime().exec(cmdarray).waitFor();
                    if (exitCode == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "arm";
    }

    public static String getArchName() {
        String osArch = System.getProperty("os.arch");
        if (OSInfo.isAndroid()) {
            return "android-arm";
        }
        if (osArch.startsWith("arm")) {
            osArch = OSInfo.resolveArmArchType();
        } else {
            String lc2 = osArch.toLowerCase(Locale.US);
            if (archMapping.containsKey(lc2)) {
                return archMapping.get(lc2);
            }
        }
        return OSInfo.translateArchNameToFolderName(osArch);
    }

    static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac") || osName.contains("Darwin")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        if (osName.contains("AIX")) {
            return "AIX";
        }
        return osName.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    static {
        archMapping.put("x86", "x86");
        archMapping.put("i386", "x86");
        archMapping.put("i486", "x86");
        archMapping.put("i586", "x86");
        archMapping.put("i686", "x86");
        archMapping.put("pentium", "x86");
        archMapping.put("x86_64", "x86_64");
        archMapping.put("amd64", "x86_64");
        archMapping.put("em64t", "x86_64");
        archMapping.put("universal", "x86_64");
        archMapping.put("ia64", "ia64");
        archMapping.put("ia64w", "ia64");
        archMapping.put("ia64_32", "ia64_32");
        archMapping.put("ia64n", "ia64_32");
        archMapping.put("ppc", "ppc");
        archMapping.put("power", "ppc");
        archMapping.put("powerpc", "ppc");
        archMapping.put("power_pc", "ppc");
        archMapping.put("power_rs", "ppc");
        archMapping.put("ppc64", "ppc64");
        archMapping.put("power64", "ppc64");
        archMapping.put("powerpc64", "ppc64");
        archMapping.put("power_pc64", "ppc64");
        archMapping.put("power_rs64", "ppc64");
    }
}

