/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public final class pc
implements Cloneable {
    private int[] bits;
    private int size;

    public pc() {
        this.size = 0;
        this.bits = new int[1];
    }

    public pc(int size) {
        this.size = size;
        this.bits = pc.makeArray(size);
    }

    pc(int[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int size) {
        if (size > this.bits.length << 5) {
            int[] newBits = pc.makeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public boolean get(int i2) {
        return (this.bits[i2 / 32] & 1 << (i2 & 0x1F)) != 0;
    }

    public void set(int i2) {
        int n2 = i2 / 32;
        this.bits[n2] = this.bits[n2] | 1 << (i2 & 0x1F);
    }

    public void flip(int i2) {
        int n2 = i2 / 32;
        this.bits[n2] = this.bits[n2] ^ 1 << (i2 & 0x1F);
    }

    public int getNextSet(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = this.bits[bitsOffset] & -(1 << (from & 0x1F));
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = this.bits[bitsOffset];
        }
        int result = (bitsOffset << 5) + Integer.numberOfTrailingZeros(currentBits);
        if (result > this.size) {
            return this.size;
        }
        return result;
    }

    public int getNextUnset(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = ~this.bits[bitsOffset] & -(1 << (from & 0x1F));
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = ~this.bits[bitsOffset];
        }
        int result = (bitsOffset << 5) + Integer.numberOfTrailingZeros(currentBits);
        if (result > this.size) {
            return this.size;
        }
        return result;
    }

    public void setBulk(int i2, int newBits) {
        this.bits[i2 / 32] = newBits;
    }

    public void setRange(int start, int end) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        int i2 = firstInt;
        while (i2 <= lastInt) {
            int firstBit = i2 > firstInt ? 0 : start & 0x1F;
            int lastBit = i2 < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << firstBit);
            int n2 = i2++;
            this.bits[n2] = this.bits[n2] | mask;
        }
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        for (int i2 = firstInt; i2 <= lastInt; ++i2) {
            int firstBit;
            int lastBit = i2 < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << (firstBit = i2 > firstInt ? 0 : start & 0x1F));
            if ((this.bits[i2] & mask) == (value ? mask : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bit) {
        pc pc2 = this;
        pc2.ensureCapacity(pc2.size + 1);
        if (bit) {
            int n2 = this.size / 32;
            this.bits[n2] = this.bits[n2] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int value, int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        pc pc2 = this;
        pc2.ensureCapacity(pc2.size + numBits);
        for (int numBitsLeft = numBits; numBitsLeft > 0; --numBitsLeft) {
            this.appendBit((value >> numBitsLeft - 1 & 1) == 1);
        }
    }

    public void appendBitArray(pc other) {
        int otherSize = other.size;
        pc pc2 = this;
        pc2.ensureCapacity(pc2.size + otherSize);
        for (int i2 = 0; i2 < otherSize; ++i2) {
            this.appendBit(other.get(i2));
        }
    }

    public void xor(pc other) {
        if (this.size != other.size) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] ^ other.bits[i2];
        }
    }

    public void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        for (int i2 = 0; i2 < numBytes; ++i2) {
            int theByte = 0;
            for (int j2 = 0; j2 < 8; ++j2) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j2;
                }
                ++bitOffset;
            }
            array[offset + i2] = (byte)theByte;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int len = (this.size - 1) / 32;
        int oldBitsLen = len + 1;
        for (int i2 = 0; i2 < oldBitsLen; ++i2) {
            long x2 = this.bits[i2];
            x2 = x2 >> 1 & 0x55555555L | (x2 & 0x55555555L) << 1;
            x2 = x2 >> 2 & 0x33333333L | (x2 & 0x33333333L) << 2;
            x2 = x2 >> 4 & 0xF0F0F0FL | (x2 & 0xF0F0F0FL) << 4;
            x2 = x2 >> 8 & 0xFF00FFL | (x2 & 0xFF00FFL) << 8;
            x2 = x2 >> 16 & 0xFFFFL | (x2 & 0xFFFFL) << 16;
            newBits[len - i2] = (int)x2;
        }
        if (this.size != oldBitsLen << 5) {
            int leftOffset = (oldBitsLen << 5) - this.size;
            int currentInt = newBits[0] >>> leftOffset;
            for (int i3 = 1; i3 < oldBitsLen; ++i3) {
                int nextInt = newBits[i3];
                newBits[i3 - 1] = currentInt |= nextInt << 32 - leftOffset;
                currentInt = nextInt >>> leftOffset;
            }
            newBits[oldBitsLen - 1] = currentInt;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        return new int[(size + 31) / 32];
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof pc)) {
            return false;
        }
        pc other = (pc)o2;
        return this.size == other.size && Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.size + this.size / 8 + 1);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i2) ? (char)'X' : '.');
        }
        return result.toString();
    }

    public pc clone() {
        return new pc((int[])this.bits.clone(), this.size);
    }
}

