/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.unsafe;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UnsafeAccess {
    public static final Unsafe UNSAFE;

    private UnsafeAccess() {
        throw new IllegalStateException("No instances!");
    }

    public static boolean isUnsafeAvailable() {
        return UNSAFE != null;
    }

    public static int getAndIncrementInt(Object obj, long offset) {
        int next;
        int current;
        while (!UNSAFE.compareAndSwapInt(obj, offset, current = UNSAFE.getIntVolatile(obj, offset), next = current + 1)) {
        }
        return current;
    }

    public static int getAndAddInt(Object obj, long offset, int n2) {
        int next;
        int current;
        while (!UNSAFE.compareAndSwapInt(obj, offset, current = UNSAFE.getIntVolatile(obj, offset), next = current + n2)) {
        }
        return current;
    }

    public static int getAndSetInt(Object obj, long offset, int newValue) {
        int current;
        while (!UNSAFE.compareAndSwapInt(obj, offset, current = UNSAFE.getIntVolatile(obj, offset), newValue)) {
        }
        return current;
    }

    public static boolean compareAndSwapInt(Object obj, long offset, int expected, int newValue) {
        return UNSAFE.compareAndSwapInt(obj, offset, expected, newValue);
    }

    public static long addressOf(Class<?> clazz, String fieldName) {
        try {
            Field f2 = clazz.getDeclaredField(fieldName);
            return UNSAFE.objectFieldOffset(f2);
        }
        catch (NoSuchFieldException ex2) {
            InternalError ie2 = new InternalError();
            ie2.initCause(ex2);
            throw ie2;
        }
    }

    static {
        Unsafe u2 = null;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            u2 = (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        UNSAFE = u2;
    }
}

