/*
Hidden and Dangerous 2 compression algorithms 0.1
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
    #include <windows.h>
#endif



static /*const*/ unsigned char hd2_01_dump[] = {
    0x55,0x8b,0xec,0x83,0xec,0x18,0x56,0xb8,0xcc,0xcc,0xcc,0xcc,0x89,0x45,0xe8,0x89,
    0x45,0xec,0x89,0x45,0xf0,0x89,0x45,0xf4,0x89,0x45,0xf8,0x89,0x45,0xfc,0x8b,0x45,
    0x08,0x0f,0xb6,0x08,0x85,0xc9,0x75,0x25,0x8b,0x55,0x10,0x83,0xea,0x01,0x89,0x55,
    0xf4,0x8b,0x45,0xf4,0x50,0x8b,0x4d,0x08,0x83,0xc1,0x01,0x51,0x8b,0x55,0x0c,0x52,
    0xe8,0x8b,0x65,0x00,0x00,0x83,0xc4,0x0c,0xe9,0xbd,0x01,0x00,0x00,0xc7,0x45,0xf4,
    0x00,0x00,0x00,0x00,0xc7,0x45,0xf8,0x03,0x00,0x00,0x00,0x8b,0x45,0x08,0x0f,0xb6,
    0x48,0x01,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x0f,0xb6,0x42,0x02,0x03,0xc8,0x66,0x89,
    0x4d,0xfc,0xc6,0x45,0xeb,0x10,0x8b,0x4d,0xf8,0x3b,0x4d,0x10,0x0f,0x83,0x88,0x01,
    0x00,0x00,0x0f,0xb6,0x55,0xeb,0x85,0xd2,0x75,0x29,0x8b,0x45,0x08,0x03,0x45,0xf8,
    0x0f,0xb6,0x08,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,0xb6,0x42,0x01,
    0x03,0xc8,0x66,0x89,0x4d,0xfc,0xc6,0x45,0xeb,0x10,0x8b,0x4d,0xf8,0x83,0xc1,0x02,
    0x89,0x4d,0xf8,0x0f,0xb7,0x55,0xfc,0x81,0xe2,0x00,0x80,0x00,0x00,0x85,0xd2,0x75,
    0x27,0x8b,0x45,0x0c,0x03,0x45,0xf4,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x8a,0x11,0x88,
    0x10,0x8b,0x45,0xf8,0x83,0xc0,0x01,0x89,0x45,0xf8,0x8b,0x4d,0xf4,0x83,0xc1,0x01,
    0x89,0x4d,0xf4,0xe9,0x0a,0x01,0x00,0x00,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,0xb6,
    0x02,0xc1,0xe0,0x04,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x0f,0xb6,0x51,0x01,0xc1,0xfa,
    0x04,0x03,0xc2,0x89,0x45,0xec,0x83,0x7d,0xec,0x00,0x75,0x75,0x8b,0x45,0x08,0x03,
    0x45,0xf8,0x0f,0xb6,0x48,0x01,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,
    0xb6,0x42,0x02,0x8d,0x4c,0x01,0x0f,0x66,0x89,0x4d,0xfe,0x66,0xc7,0x45,0xf2,0x00,
    0x00,0xeb,0x0c,0x66,0x8b,0x55,0xf2,0x66,0x83,0xc2,0x01,0x66,0x89,0x55,0xf2,0x0f,
    0xb7,0x45,0xf2,0x0f,0xb7,0x4d,0xfe,0x83,0xc1,0x01,0x3b,0xc1,0x7d,0x1a,0x0f,0xb7,
    0x55,0xf2,0x8b,0x45,0xf4,0x03,0xc2,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x8b,0x55,0x0c,
    0x8a,0x49,0x03,0x88,0x0c,0x02,0xeb,0xcb,0x8b,0x55,0xf8,0x83,0xc2,0x04,0x89,0x55,
    0xf8,0x0f,0xb7,0x45,0xfe,0x8b,0x4d,0xf4,0x8d,0x54,0x01,0x01,0x89,0x55,0xf4,0xeb,
    0x71,0x8b,0x45,0x08,0x03,0x45,0xf8,0x0f,0xb6,0x48,0x01,0x83,0xe1,0x0f,0x83,0xc1,
    0x02,0x66,0x89,0x4d,0xfe,0x66,0xc7,0x45,0xf2,0x00,0x00,0xeb,0x0c,0x66,0x8b,0x55,
    0xf2,0x66,0x83,0xc2,0x01,0x66,0x89,0x55,0xf2,0x0f,0xb7,0x45,0xf2,0x0f,0xb7,0x4d,
    0xfe,0x83,0xc1,0x01,0x3b,0xc1,0x7d,0x23,0x8b,0x55,0xf4,0x2b,0x55,0xec,0x0f,0xb7,
    0x45,0xf2,0x03,0xd0,0x0f,0xb7,0x4d,0xf2,0x8b,0x45,0xf4,0x03,0xc1,0x8b,0x4d,0x0c,
    0x8b,0x75,0x0c,0x8a,0x14,0x16,0x88,0x14,0x01,0xeb,0xc2,0x8b,0x45,0xf8,0x83,0xc0,
    0x02,0x89,0x45,0xf8,0x0f,0xb7,0x4d,0xfe,0x8b,0x55,0xf4,0x8d,0x44,0x0a,0x01,0x89,
    0x45,0xf4,0x0f,0xb7,0x4d,0xfc,0xd1,0xe1,0x66,0x89,0x4d,0xfc,0x8a,0x55,0xeb,0x80,
    0xea,0x01,0x88,0x55,0xeb,0xe9,0x6c,0xfe,0xff,0xff,0x8b,0x45,0xf4,0x5e,0x83,0xc4,
    0x18,0x3b,0xec,0xe8,0x48,0x62,0x00,0x00,0x8b,0xe5,0x5d,0xc3,/*INT3*/ 0xcc };

static /*const*/ unsigned char hd2_08_dump[] = {
    0x55,0x8b,0xec,0x83,0xec,0x38,0x57,0x8d,0x7d,0xc8,0xb9,0x0e,0x00,0x00,0x00,0xb8,
    0xcc,0xcc,0xcc,0xcc,0xf3,0xab,0xc7,0x45,0xf4,0x00,0x00,0x00,0x00,0x8b,0x45,0x08,
    0x0f,0xb6,0x08,0x83,0xf9,0x0c,0x75,0x09,0xc7,0x45,0xf4,0x01,0x00,0x00,0x00,0xeb,
    0x62,0x8b,0x55,0x08,0x0f,0xb6,0x02,0x83,0xf8,0x10,0x75,0x09,0xc7,0x45,0xf4,0x02,
    0x00,0x00,0x00,0xeb,0x4e,0x8b,0x4d,0x08,0x0f,0xb6,0x11,0x83,0xfa,0x14,0x75,0x09,
    0xc7,0x45,0xf4,0x03,0x00,0x00,0x00,0xeb,0x3a,0x8b,0x45,0x08,0x0f,0xb6,0x08,0x83,
    0xf9,0x18,0x75,0x09,0xc7,0x45,0xf4,0x04,0x00,0x00,0x00,0xeb,0x26,0x8b,0x55,0x08,
    0x0f,0xb6,0x02,0x83,0xf8,0x1c,0x75,0x09,0xc7,0x45,0xf4,0x05,0x00,0x00,0x00,0xeb,
    0x12,0x8b,0x4d,0x08,0x0f,0xb6,0x11,0x83,0xfa,0x20,0x75,0x07,0xc7,0x45,0xf4,0x06,
    0x00,0x00,0x00,0xc7,0x45,0xf8,0x00,0x00,0x00,0x00,0xc7,0x45,0xec,0x01,0x00,0x00,
    0x00,0x8b,0x45,0x08,0x03,0x45,0xec,0x89,0x45,0xfc,0x8b,0x4d,0xfc,0x8b,0x55,0x14,
    0x8b,0x01,0x3b,0x02,0x75,0x46,0x8b,0x4d,0xfc,0x8b,0x55,0x14,0x8b,0x41,0x0c,0x3b,
    0x42,0x0c,0x75,0x38,0x8b,0x4d,0xfc,0x8b,0x55,0x14,0x8b,0x41,0x24,0x3b,0x42,0x24,
    0x75,0x2a,0x6a,0x2c,0x8b,0x4d,0x08,0x03,0x4d,0xec,0x51,0x8b,0x55,0x0c,0x03,0x55,
    0xf8,0x52,0xe8,0x12,0xb7,0x00,0x00,0x83,0xc4,0x0c,0x8b,0x45,0xf8,0x83,0xc0,0x2c,
    0x89,0x45,0xf8,0x8b,0x4d,0xec,0x83,0xc1,0x2c,0x89,0x4d,0xec,0x8b,0x55,0xec,0x3b,
    0x55,0x10,0x0f,0x83,0xe2,0x02,0x00,0x00,0x8b,0x45,0x14,0x0f,0xb7,0x40,0x20,0x8b,
    0x4d,0x14,0x0f,0xb7,0x49,0x16,0x99,0xf7,0xf9,0x83,0xf8,0x02,0x0f,0x85,0xa3,0x02,
    0x00,0x00,0x8b,0x55,0x14,0x0f,0xb7,0x42,0x16,0x83,0xf8,0x02,0x0f,0x85,0x96,0x01,
    0x00,0x00,0xc7,0x45,0xe4,0x04,0x00,0x00,0x00,0x8b,0x4d,0xe4,0x8b,0x55,0xe4,0x83,
    0xea,0x01,0x89,0x55,0xe4,0x85,0xc9,0x74,0x24,0x8b,0x45,0x0c,0x03,0x45,0xf8,0x8b,
    0x4d,0x08,0x03,0x4d,0xec,0x8a,0x11,0x88,0x10,0x8b,0x45,0xf8,0x83,0xc0,0x01,0x89,
    0x45,0xf8,0x8b,0x4d,0xec,0x83,0xc1,0x01,0x89,0x4d,0xec,0xeb,0xcc,0x8b,0x55,0xec,
    0x3b,0x55,0x10,0x0f,0x83,0x4a,0x01,0x00,0x00,0x8b,0x45,0xf8,0x8b,0x4d,0x0c,0x8d,
    0x54,0x01,0xfc,0x89,0x55,0xe0,0x8b,0x45,0xe0,0x66,0x8b,0x08,0x66,0x89,0x4d,0xf2,
    0x8b,0x55,0xf8,0x8b,0x45,0x0c,0x8d,0x4c,0x10,0xfe,0x89,0x4d,0xe0,0x8b,0x55,0xe0,
    0x66,0x8b,0x02,0x66,0x89,0x45,0xea,0xb9,0x01,0x00,0x00,0x00,0x85,0xc9,0x0f,0x84,
    0x0f,0x01,0x00,0x00,0x8b,0x55,0x0c,0x03,0x55,0xf8,0x89,0x55,0xd8,0x8b,0x45,0xf8,
    0x83,0xc0,0x02,0x89,0x45,0xf8,0x8b,0x4d,0x0c,0x03,0x4d,0xf8,0x89,0x4d,0xd4,0x8b,
    0x55,0xf8,0x83,0xc2,0x02,0x89,0x55,0xf8,0x8b,0x45,0x08,0x03,0x45,0xec,0x0f,0xb6,
    0x08,0x83,0xe1,0x7f,0x88,0x4d,0xdf,0x8b,0x55,0x08,0x03,0x55,0xec,0x0f,0xb6,0x02,
    0x25,0x80,0x00,0x00,0x00,0x85,0xc0,0x74,0x1e,0x8b,0x4d,0xf4,0xc1,0xe1,0x08,0x0f,
    0xb6,0x55,0xdf,0x0f,0xbf,0x84,0x51,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x4d,0xf2,0x2b,
    0xc8,0x66,0x89,0x4d,0xf2,0xeb,0x1c,0x8b,0x55,0xf4,0xc1,0xe2,0x08,0x0f,0xb6,0x45,
    0xdf,0x0f,0xbf,0x8c,0x42,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x55,0xf2,0x03,0xd1,0x66,
    0x89,0x55,0xf2,0x8b,0x45,0xec,0x83,0xc0,0x01,0x89,0x45,0xec,0x8b,0x4d,0xd8,0x66,
    0x8b,0x55,0xf2,0x66,0x89,0x11,0x8b,0x45,0x08,0x03,0x45,0xec,0x0f,0xb6,0x08,0x83,
    0xe1,0x7f,0x88,0x4d,0xdf,0x8b,0x55,0x08,0x03,0x55,0xec,0x0f,0xb6,0x02,0x25,0x80,
    0x00,0x00,0x00,0x85,0xc0,0x74,0x1e,0x8b,0x4d,0xf4,0xc1,0xe1,0x08,0x0f,0xb6,0x55,
    0xdf,0x0f,0xbf,0x84,0x51,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x4d,0xea,0x2b,0xc8,0x66,
    0x89,0x4d,0xea,0xeb,0x1c,0x8b,0x55,0xf4,0xc1,0xe2,0x08,0x0f,0xb6,0x45,0xdf,0x0f,
    0xbf,0x8c,0x42,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x55,0xea,0x03,0xd1,0x66,0x89,0x55,
    0xea,0x8b,0x45,0xec,0x83,0xc0,0x01,0x89,0x45,0xec,0x8b,0x4d,0xd4,0x66,0x8b,0x55,
    0xea,0x66,0x89,0x11,0x8b,0x45,0xec,0x3b,0x45,0x10,0x72,0x02,0xeb,0x05,0xe9,0xe4,
    0xfe,0xff,0xff,0xe9,0xfb,0x00,0x00,0x00,0xc7,0x45,0xd0,0x02,0x00,0x00,0x00,0x8b,
    0x4d,0xd0,0x8b,0x55,0xd0,0x83,0xea,0x01,0x89,0x55,0xd0,0x85,0xc9,0x74,0x24,0x8b,
    0x45,0x0c,0x03,0x45,0xf8,0x8b,0x4d,0x08,0x03,0x4d,0xec,0x8a,0x11,0x88,0x10,0x8b,
    0x45,0xf8,0x83,0xc0,0x01,0x89,0x45,0xf8,0x8b,0x4d,0xec,0x83,0xc1,0x01,0x89,0x4d,
    0xec,0xeb,0xcc,0x8b,0x55,0xec,0x3b,0x55,0x10,0x0f,0x83,0xb4,0x00,0x00,0x00,0x8b,
    0x45,0xf8,0x8b,0x4d,0x0c,0x8d,0x54,0x01,0xfe,0x89,0x55,0xcc,0x8b,0x45,0xcc,0x66,
    0x8b,0x08,0x66,0x89,0x4d,0xf2,0xba,0x01,0x00,0x00,0x00,0x85,0xd2,0x0f,0x84,0x90,
    0x00,0x00,0x00,0x8b,0x45,0x0c,0x03,0x45,0xf8,0x89,0x45,0xcc,0x8b,0x4d,0xf8,0x83,
    0xc1,0x02,0x89,0x4d,0xf8,0x8b,0x55,0x08,0x03,0x55,0xec,0x0f,0xb6,0x02,0x83,0xe0,
    0x7f,0x88,0x45,0xcb,0x8b,0x4d,0x08,0x03,0x4d,0xec,0x0f,0xb6,0x11,0x81,0xe2,0x80,
    0x00,0x00,0x00,0x85,0xd2,0x74,0x1e,0x8b,0x45,0xf4,0xc1,0xe0,0x08,0x0f,0xb6,0x4d,
    0xcb,0x0f,0xbf,0x94,0x48,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x45,0xf2,0x2b,0xc2,0x66,
    0x89,0x45,0xf2,0xeb,0x1c,0x8b,0x4d,0xf4,0xc1,0xe1,0x08,0x0f,0xb6,0x55,0xcb,0x0f,
    0xbf,0x84,0x51,0x70,0x6d,0x03,0x10,0x0f,0xbf,0x4d,0xf2,0x03,0xc8,0x66,0x89,0x4d,
    0xf2,0x8b,0x55,0xec,0x83,0xc2,0x01,0x89,0x55,0xec,0x8b,0x45,0xcc,0x66,0x8b,0x4d,
    0xf2,0x66,0x89,0x08,0x8b,0x55,0xec,0x3b,0x55,0x10,0x72,0x02,0xeb,0x05,0xe9,0x63,
    0xff,0xff,0xff,0xeb,0x25,0x8b,0x45,0x10,0x2b,0x45,0xec,0x50,0x8b,0x4d,0x0c,0x03,
    0x4d,0xf8,0x51,0x8b,0x55,0x08,0x03,0x55,0xec,0x52,0xe8,0xf9,0x77,0xff,0xff,0x83,
    0xc4,0x0c,0x8b,0x4d,0xf8,0x03,0xc8,0x89,0x4d,0xf8,0x8b,0x45,0xf8,0x5f,0x83,0xc4,
    0x38,0x3b,0xec,0xe8,0x91,0xb2,0x00,0x00,0x8b,0xe5,0x5d,0xc3,/*INT3*/ 0xcc };

static /*const*/ unsigned char hd2_01raw_dump[] = {
    0x55,0x8b,0xec,0x83,0xec,0x18,0x56,0xb8,0xcc,0xcc,0xcc,0xcc,0x89,0x45,0xe8,0x89,
    0x45,0xec,0x89,0x45,0xf0,0x89,0x45,0xf4,0x89,0x45,0xf8,0x89,0x45,0xfc,0x8b,0x45,
    0x08,0x48,0x89,0x45,0x08,0x8b,0x45,0x10,0x40,0x89,0x45,0x10,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0xc7,0x45,0xf4,
    0x00,0x00,0x00,0x00,0xc7,0x45,0xf8,0x03,0x00,0x00,0x00,0x8b,0x45,0x08,0x0f,0xb6,
    0x48,0x01,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x0f,0xb6,0x42,0x02,0x03,0xc8,0x66,0x89,
    0x4d,0xfc,0xc6,0x45,0xeb,0x10,0x8b,0x4d,0xf8,0x3b,0x4d,0x10,0x0f,0x83,0x88,0x01,
    0x00,0x00,0x0f,0xb6,0x55,0xeb,0x85,0xd2,0x75,0x29,0x8b,0x45,0x08,0x03,0x45,0xf8,
    0x0f,0xb6,0x08,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,0xb6,0x42,0x01,
    0x03,0xc8,0x66,0x89,0x4d,0xfc,0xc6,0x45,0xeb,0x10,0x8b,0x4d,0xf8,0x83,0xc1,0x02,
    0x89,0x4d,0xf8,0x0f,0xb7,0x55,0xfc,0x81,0xe2,0x00,0x80,0x00,0x00,0x85,0xd2,0x75,
    0x27,0x8b,0x45,0x0c,0x03,0x45,0xf4,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x8a,0x11,0x88,
    0x10,0x8b,0x45,0xf8,0x83,0xc0,0x01,0x89,0x45,0xf8,0x8b,0x4d,0xf4,0x83,0xc1,0x01,
    0x89,0x4d,0xf4,0xe9,0x0a,0x01,0x00,0x00,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,0xb6,
    0x02,0xc1,0xe0,0x04,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x0f,0xb6,0x51,0x01,0xc1,0xfa,
    0x04,0x03,0xc2,0x89,0x45,0xec,0x83,0x7d,0xec,0x00,0x75,0x75,0x8b,0x45,0x08,0x03,
    0x45,0xf8,0x0f,0xb6,0x48,0x01,0xc1,0xe1,0x08,0x8b,0x55,0x08,0x03,0x55,0xf8,0x0f,
    0xb6,0x42,0x02,0x8d,0x4c,0x01,0x0f,0x66,0x89,0x4d,0xfe,0x66,0xc7,0x45,0xf2,0x00,
    0x00,0xeb,0x0c,0x66,0x8b,0x55,0xf2,0x66,0x83,0xc2,0x01,0x66,0x89,0x55,0xf2,0x0f,
    0xb7,0x45,0xf2,0x0f,0xb7,0x4d,0xfe,0x83,0xc1,0x01,0x3b,0xc1,0x7d,0x1a,0x0f,0xb7,
    0x55,0xf2,0x8b,0x45,0xf4,0x03,0xc2,0x8b,0x4d,0x08,0x03,0x4d,0xf8,0x8b,0x55,0x0c,
    0x8a,0x49,0x03,0x88,0x0c,0x02,0xeb,0xcb,0x8b,0x55,0xf8,0x83,0xc2,0x04,0x89,0x55,
    0xf8,0x0f,0xb7,0x45,0xfe,0x8b,0x4d,0xf4,0x8d,0x54,0x01,0x01,0x89,0x55,0xf4,0xeb,
    0x71,0x8b,0x45,0x08,0x03,0x45,0xf8,0x0f,0xb6,0x48,0x01,0x83,0xe1,0x0f,0x83,0xc1,
    0x02,0x66,0x89,0x4d,0xfe,0x66,0xc7,0x45,0xf2,0x00,0x00,0xeb,0x0c,0x66,0x8b,0x55,
    0xf2,0x66,0x83,0xc2,0x01,0x66,0x89,0x55,0xf2,0x0f,0xb7,0x45,0xf2,0x0f,0xb7,0x4d,
    0xfe,0x83,0xc1,0x01,0x3b,0xc1,0x7d,0x23,0x8b,0x55,0xf4,0x2b,0x55,0xec,0x0f,0xb7,
    0x45,0xf2,0x03,0xd0,0x0f,0xb7,0x4d,0xf2,0x8b,0x45,0xf4,0x03,0xc1,0x8b,0x4d,0x0c,
    0x8b,0x75,0x0c,0x8a,0x14,0x16,0x88,0x14,0x01,0xeb,0xc2,0x8b,0x45,0xf8,0x83,0xc0,
    0x02,0x89,0x45,0xf8,0x0f,0xb7,0x4d,0xfe,0x8b,0x55,0xf4,0x8d,0x44,0x0a,0x01,0x89,
    0x45,0xf4,0x0f,0xb7,0x4d,0xfc,0xd1,0xe1,0x66,0x89,0x4d,0xfc,0x8a,0x55,0xeb,0x80,
    0xea,0x01,0x88,0x55,0xeb,0xe9,0x6c,0xfe,0xff,0xff,0x8b,0x45,0xf4,0x5e,0x83,0xc4,
    0x18,0x3b,0xec,0x90,0x90,0x90,0x90,0x90,0x8b,0xe5,0x5d,0xc3,/*INT3*/ 0xcc };

static const unsigned char hd2_08_10036d70[] =
    "\x00\x00\x01\x00\x02\x00\x04\x00\x08\x00\x0c\x00\x12\x00\x18\x00"
    "\x20\x00\x29\x00\x32\x00\x3d\x00\x49\x00\x55\x00\x63\x00\x72\x00"
    "\x82\x00\x92\x00\xa4\x00\xb7\x00\xcb\x00\xdf\x00\xf5\x00\x0c\x01"
    "\x24\x01\x3d\x01\x57\x01\x72\x01\x8e\x01\xab\x01\xc9\x01\xe8\x01"
    "\x08\x02\x29\x02\x4b\x02\x6e\x02\x92\x02\xb7\x02\xdd\x02\x04\x03"
    "\x2c\x03\x55\x03\x7f\x03\xab\x03\xd7\x03\x04\x04\x32\x04\x61\x04"
    "\x92\x04\xc3\x04\xf5\x04\x29\x05\x5d\x05\x92\x05\xc9\x05\x00\x06"
    "\x38\x06\x72\x06\xac\x06\xe8\x06\x24\x07\x61\x07\xa0\x07\xdf\x07"
    "\x20\x08\x61\x08\xa4\x08\xe7\x08\x2c\x09\x72\x09\xb8\x09\x00\x0a"
    "\x48\x0a\x92\x0a\xdd\x0a\x28\x0b\x75\x0b\xc3\x0b\x12\x0c\x61\x0c"
    "\xb2\x0c\x04\x0d\x57\x0d\xaa\x0d\xff\x0d\x55\x0e\xac\x0e\x04\x0f"
    "\x5d\x0f\xb7\x0f\x12\x10\x6d\x10\xca\x10\x28\x11\x87\x11\xe7\x11"
    "\x48\x12\xaa\x12\x0d\x13\x71\x13\xd7\x13\x3d\x14\xa4\x14\x0c\x15"
    "\x75\x15\xdf\x15\x4a\x16\xb7\x16\x24\x17\x92\x17\x01\x18\x71\x18"
    "\xe3\x18\x55\x19\xc8\x19\x3d\x1a\xb2\x1a\x28\x1b\xa0\x1b\x18\x1c"
    "\x91\x1c\x0c\x1d\x87\x1d\x04\x1e\x81\x1e\x00\x1f\x7f\x1f\x00\x20"
    "\x00\x00\x01\x00\x03\x00\x06\x00\x0c\x00\x13\x00\x1b\x00\x25\x00"
    "\x30\x00\x3d\x00\x4c\x00\x5c\x00\x6d\x00\x80\x00\x95\x00\xab\x00"
    "\xc3\x00\xdc\x00\xf6\x00\x13\x01\x30\x01\x4f\x01\x70\x01\x93\x01"
    "\xb6\x01\xdc\x01\x03\x02\x2b\x02\x55\x02\x80\x02\xad\x02\xdc\x02"
    "\x0c\x03\x3d\x03\x70\x03\xa5\x03\xdb\x03\x12\x04\x4c\x04\x86\x04"
    "\xc2\x04\x00\x05\x3f\x05\x80\x05\xc2\x05\x06\x06\x4c\x06\x92\x06"
    "\xdb\x06\x25\x07\x70\x07\xbd\x07\x0c\x08\x5c\x08\xad\x08\x00\x09"
    "\x55\x09\xab\x09\x02\x0a\x5c\x0a\xb6\x0a\x12\x0b\x70\x0b\xcf\x0b"
    "\x30\x0c\x92\x0c\xf6\x0c\x5b\x0d\xc2\x0d\x2b\x0e\x95\x0e\x00\x0f"
    "\x6d\x0f\xdb\x0f\x4b\x10\xbd\x10\x30\x11\xa5\x11\x1b\x12\x92\x12"
    "\x0b\x13\x86\x13\x02\x14\x80\x14\xff\x14\x80\x15\x02\x16\x86\x16"
    "\x0b\x17\x92\x17\x1b\x18\xa4\x18\x30\x19\xbd\x19\x4b\x1a\xdb\x1a"
    "\x6d\x1b\x00\x1c\x94\x1c\x2a\x1d\xc2\x1d\x5b\x1e\xf6\x1e\x92\x1f"
    "\x30\x20\xcf\x20\x70\x21\x12\x22\xb6\x22\x5b\x23\x02\x24\xaa\x24"
    "\x54\x25\x00\x26\xad\x26\x5b\x27\x0b\x28\xbd\x28\x70\x29\x24\x2a"
    "\xda\x2a\x92\x2b\x4b\x2c\x06\x2d\xc2\x2d\x80\x2e\x3f\x2f\x00\x30"
    "\x00\x00\x02\x00\x04\x00\x09\x00\x10\x00\x19\x00\x24\x00\x31\x00"
    "\x41\x00\x52\x00\x65\x00\x7a\x00\x92\x00\xab\x00\xc7\x00\xe4\x00"
    "\x04\x01\x25\x01\x49\x01\x6e\x01\x96\x01\xbf\x01\xeb\x01\x19\x02"
    "\x49\x02\x7a\x02\xae\x02\xe4\x02\x1c\x03\x56\x03\x92\x03\xd0\x03"
    "\x10\x04\x52\x04\x96\x04\xdc\x04\x24\x05\x6e\x05\xba\x05\x09\x06"
    "\x59\x06\xab\x06\xff\x06\x56\x07\xae\x07\x09\x08\x65\x08\xc3\x08"
    "\x24\x09\x86\x09\xeb\x09\x52\x0a\xba\x0a\x25\x0b\x92\x0b\x00\x0c"
    "\x71\x0c\xe4\x0c\x59\x0d\xd0\x0d\x48\x0e\xc3\x0e\x40\x0f\xbf\x0f"
    "\x40\x10\xc3\x10\x48\x11\xcf\x11\x59\x12\xe4\x12\x71\x13\x00\x14"
    "\x91\x14\x25\x15\xba\x15\x51\x16\xeb\x16\x86\x17\x24\x18\xc3\x18"
    "\x65\x19\x08\x1a\xae\x1a\x55\x1b\xff\x1b\xab\x1c\x58\x1d\x08\x1e"
    "\xba\x1e\x6e\x1f\x24\x20\xdb\x20\x95\x21\x51\x22\x0f\x23\xcf\x23"
    "\x91\x24\x55\x25\x1b\x26\xe3\x26\xae\x27\x7a\x28\x48\x29\x18\x2a"
    "\xeb\x2a\xbf\x2b\x95\x2c\x6e\x2d\x48\x2e\x24\x2f\x03\x30\xe3\x30"
    "\xc6\x31\xaa\x32\x91\x33\x7a\x34\x64\x35\x51\x36\x40\x37\x30\x38"
    "\x23\x39\x18\x3a\x0f\x3b\x08\x3c\x03\x3d\x00\x3e\xff\x3e\x00\x40"
    "\x00\x00\x02\x00\x05\x00\x0b\x00\x14\x00\x1f\x00\x2d\x00\x3e\x00"
    "\x51\x00\x66\x00\x7e\x00\x99\x00\xb6\x00\xd6\x00\xf8\x00\x1d\x01"
    "\x45\x01\x6e\x01\x9b\x01\xca\x01\xfb\x01\x2f\x02\x66\x02\x9f\x02"
    "\xdb\x02\x19\x03\x5a\x03\x9d\x03\xe3\x03\x2b\x04\x76\x04\xc4\x04"
    "\x14\x05\x66\x05\xbb\x05\x13\x06\x6d\x06\xca\x06\x29\x07\x8b\x07"
    "\xef\x07\x56\x08\xbf\x08\x2b\x09\x9a\x09\x0b\x0a\x7e\x0a\xf4\x0a"
    "\x6d\x0b\xe8\x0b\x66\x0c\xe6\x0c\x69\x0d\xee\x0d\x76\x0e\x01\x0f"
    "\x8d\x0f\x1d\x10\xaf\x10\x44\x11\xdb\x11\x74\x12\x10\x13\xaf\x13"
    "\x50\x14\xf4\x14\x9b\x15\x43\x16\xef\x16\x9d\x17\x4d\x18\x00\x19"
    "\xb6\x19\x6e\x1a\x29\x1b\xe6\x1b\xa6\x1c\x68\x1d\x2d\x1e\xf4\x1e"
    "\xbe\x1f\x8a\x20\x59\x21\x2b\x22\xff\x22\xd6\x23\xaf\x24\x8a\x25"
    "\x69\x26\x49\x27\x2d\x28\x12\x29\xfb\x29\xe6\x2a\xd3\x2b\xc3\x2c"
    "\xb6\x2d\xab\x2e\xa2\x2f\x9c\x30\x99\x31\x98\x32\x9a\x33\x9e\x34"
    "\xa5\x35\xaf\x36\xbb\x37\xc9\x38\xda\x39\xee\x3a\x04\x3c\x1c\x3d"
    "\x37\x3e\x55\x3f\x75\x40\x98\x41\xbd\x42\xe5\x43\x10\x45\x3d\x46"
    "\x6c\x47\x9e\x48\xd3\x49\x0a\x4b\x43\x4c\x80\x4d\xbe\x4e\x00\x50"
    "\x00\x00\x02\x00\x06\x00\x0d\x00\x18\x00\x26\x00\x36\x00\x4a\x00"
    "\x61\x00\x7b\x00\x98\x00\xb8\x00\xdb\x00\x01\x01\x2a\x01\x56\x01"
    "\x86\x01\xb8\x01\xed\x01\x26\x02\x61\x02\x9f\x02\xe1\x02\x26\x03"
    "\x6d\x03\xb8\x03\x06\x04\x56\x04\xaa\x04\x01\x05\x5b\x05\xb8\x05"
    "\x18\x06\x7b\x06\xe1\x06\x4a\x07\xb6\x07\x25\x08\x98\x08\x0d\x09"
    "\x85\x09\x01\x0a\x7f\x0a\x01\x0b\x85\x0b\x0d\x0c\x98\x0c\x25\x0d"
    "\xb6\x0d\x4a\x0e\xe1\x0e\x7b\x0f\x18\x10\xb8\x10\x5b\x11\x01\x12"
    "\xaa\x12\x56\x13\x05\x14\xb8\x14\x6d\x15\x25\x16\xe1\x16\x9f\x17"
    "\x61\x18\x25\x19\xed\x19\xb7\x1a\x85\x1b\x56\x1c\x2a\x1d\x01\x1e"
    "\xda\x1e\xb7\x1f\x97\x20\x7a\x21\x60\x22\x4a\x23\x36\x24\x25\x25"
    "\x17\x26\x0d\x27\x05\x28\x00\x29\xff\x29\x00\x2b\x05\x2c\x0c\x2d"
    "\x17\x2e\x25\x2f\x36\x30\x49\x31\x60\x32\x7a\x33\x97\x34\xb7\x35"
    "\xda\x36\x00\x38\x29\x39\x55\x3a\x85\x3b\xb7\x3c\xec\x3d\x25\x3f"
    "\x60\x40\x9e\x41\xe0\x42\x25\x44\x6c\x45\xb7\x46\x04\x48\x55\x49"
    "\xa9\x4a\x00\x4c\x5a\x4d\xb7\x4e\x17\x50\x7a\x51\xe0\x52\x49\x54"
    "\xb5\x55\x24\x57\x96\x58\x0c\x5a\x84\x5b\x00\x5d\x7e\x5e\x00\x60"
    "\x00\x00\x02\x00\x07\x00\x0f\x00\x1c\x00\x2c\x00\x3f\x00\x57\x00"
    "\x71\x00\x8f\x00\xb1\x00\xd7\x00\xff\x00\x2c\x01\x5c\x01\x8f\x01"
    "\xc7\x01\x01\x02\x3f\x02\x81\x02\xc7\x02\x0f\x03\x5c\x03\xac\x03"
    "\xff\x03\x57\x04\xb1\x04\x0f\x05\x71\x05\xd7\x05\x3f\x06\xac\x06"
    "\x1c\x07\x8f\x07\x06\x08\x81\x08\xff\x08\x81\x09\x06\x0a\x8f\x0a"
    "\x1c\x0b\xac\x0b\x3f\x0c\xd6\x0c\x71\x0d\x0f\x0e\xb1\x0e\x56\x0f"
    "\xff\x0f\xac\x10\x5c\x11\x0f\x12\xc6\x12\x81\x13\x3f\x14\x01\x15"
    "\xc6\x15\x8f\x16\x5c\x17\x2c\x18\xff\x18\xd6\x19\xb1\x1a\x8f\x1b"
    "\x71\x1c\x56\x1d\x3f\x1e\x2b\x1f\x1b\x20\x0f\x21\x06\x22\x01\x23"
    "\xff\x23\x01\x25\x06\x26\x0f\x27\x1b\x28\x2b\x29\x3f\x2a\x56\x2b"
    "\x71\x2c\x8f\x2d\xb1\x2e\xd6\x2f\xff\x30\x2b\x32\x5b\x33\x8f\x34"
    "\xc6\x35\x00\x37\x3f\x38\x80\x39\xc6\x3a\x0f\x3c\x5b\x3d\xab\x3e"
    "\xfe\x3f\x56\x41\xb0\x42\x0e\x44\x70\x45\xd5\x46\x3e\x48\xab\x49"
    "\x1b\x4b\x8e\x4c\x05\x4e\x80\x4f\xfe\x50\x80\x52\x05\x54\x8e\x55"
    "\x1b\x57\xab\x58\x3e\x5a\xd5\x5b\x70\x5d\x0e\x5f\xb0\x60\x55\x62"
    "\xfe\x63\xaa\x65\x5a\x67\x0e\x69\xc5\x6a\x80\x6c\x3e\x6e\x00\x70"
    "\x00\x00\x02\x00\x08\x00\x12\x00\x20\x00\x32\x00\x49\x00\x63\x00"
    "\x82\x00\xa4\x00\xcb\x00\xf5\x00\x24\x01\x57\x01\x8e\x01\xc9\x01"
    "\x08\x02\x4b\x02\x92\x02\xdd\x02\x2c\x03\x7f\x03\xd7\x03\x32\x04"
    "\x92\x04\xf5\x04\x5d\x05\xc9\x05\x38\x06\xac\x06\x24\x07\xa0\x07"
    "\x20\x08\xa4\x08\x2c\x09\xb8\x09\x48\x0a\xdd\x0a\x75\x0b\x11\x0c"
    "\xb2\x0c\x57\x0d\xff\x0d\xac\x0e\x5d\x0f\x11\x10\xca\x10\x87\x11"
    "\x48\x12\x0d\x13\xd6\x13\xa4\x14\x75\x15\x4a\x16\x24\x17\x01\x18"
    "\xe2\x18\xc8\x19\xb2\x1a\x9f\x1b\x91\x1c\x87\x1d\x81\x1e\x7f\x1f"
    "\x81\x20\x87\x21\x91\x22\x9f\x23\xb1\x24\xc8\x25\xe2\x26\x01\x28"
    "\x23\x29\x4a\x2a\x74\x2b\xa3\x2c\xd6\x2d\x0d\x2f\x47\x30\x86\x31"
    "\xc9\x32\x11\x34\x5c\x35\xab\x36\xfe\x37\x56\x39\xb1\x3a\x10\x3c"
    "\x74\x3d\xdb\x3e\x47\x40\xb7\x41\x2b\x43\xa2\x44\x1e\x46\x9e\x47"
    "\x22\x49\xaa\x4a\x37\x4c\xc7\x4d\x5b\x4f\xf3\x50\x90\x52\x30\x54"
    "\xd5\x55\x7d\x57\x2a\x59\xdb\x5a\x90\x5c\x48\x5e\x05\x60\xc6\x61"
    "\x8b\x63\x54\x65\x22\x67\xf3\x68\xc8\x6a\xa1\x6c\x7f\x6e\x60\x70"
    "\x46\x72\x30\x74\x1d\x76\x0f\x78\x05\x7a\xff\x7b\xfd\x7d\xff\x7f";



int (__cdecl *hd2_01)(void *in, void *out, int insz) = NULL;
int (__cdecl *hd2_08)(void *in, void *out, int insz, void *delta_2c) = NULL;
int (__cdecl *hd2_01raw)(void *in, void *out, int insz) = NULL;



// anti DEP limitation, allocation is necessary
void *hd2_alloc(void *dump, int dumpsz) {
    int     pagesz;
    void    *ret;

    pagesz = (dumpsz + 4095) & (~4095); // useful for pages? mah

#ifdef WIN32
    ret = VirtualAlloc(
        NULL,
        pagesz,
        MEM_COMMIT | MEM_RESERVE,
        PAGE_EXECUTE_READWRITE);    // write for memcpy
#else
    ret = malloc(pagesz);
    mprotect(
        ret,
        pagesz,
        PROT_EXEC | PROT_WRITE);    // write for memcpy
#endif
    memcpy(ret, dump, dumpsz);
    return(ret);
}



void hd2_init(void) {
    unsigned char   *p;

    if(!hd2_01) {
        hd2_01 = hd2_alloc(hd2_01_dump, sizeof(hd2_01_dump));
        p = (unsigned char *)hd2_01;
        *(int *)(p + 0x41) = ((unsigned char *)memcpy) - (p + 0x41 + 4);
        memset(p + 0x213, 0x90, 5);
    }
    if(!hd2_08) {
        hd2_08 = hd2_alloc(hd2_08_dump, sizeof(hd2_08_dump));

        #define PATCHIT(X,Y) *(int *)((char *)hd2_08 + X) = (int)(Y);
        PATCHIT(0x00000207, hd2_08_10036d70) // movsx eax, word ptr [ecx+edx*2+10036D70]
        PATCHIT(0x00000225, hd2_08_10036d70) // movsx ecx, word ptr [edx+eax*2+10036D70]
        PATCHIT(0x00000275, hd2_08_10036d70) // movsx eax, word ptr [ecx+edx*2+10036D70]
        PATCHIT(0x00000293, hd2_08_10036d70) // movsx ecx, word ptr [edx+eax*2+10036D70]
        PATCHIT(0x00000375, hd2_08_10036d70) // movsx edx, word ptr [eax+ecx*2+10036D70]
        PATCHIT(0x00000393, hd2_08_10036d70) // movsx eax, word ptr [ecx+edx*2+10036D70]
        #undef PATCHIT

        p = (unsigned char *)hd2_08;
        *(int *)(p + 0xe3)  = ((unsigned char *)memcpy) - (p + 0xe3 + 4);
        *(int *)(p + 0x3db) = ((unsigned char *)hd2_01) - (p + 0x3db + 4);
        memset(p + 0x3f3, 0x90, 5);
    }
    if(!hd2_01raw) {
        hd2_01raw = hd2_alloc(hd2_01raw_dump, sizeof(hd2_01raw_dump));
        p = (unsigned char *)hd2_01raw;
        *(int *)(p + 0x41) = ((unsigned char *)memcpy) - (p + 0x41 + 4);
        memset(p + 0x213, 0x90, 5);
    }
}
