//------------------------------
// ELSCoder.cpp
// integrated by Jason Hughes
// taken from Witter's internet 
// publicized "elscoder.pdf"
// Orign Systems
// 1998
//------------------------------

#include "first.h"
#include "ELSCoder.h"

#define ALACRITOUS   // this changes the way it predicts the probability... 

#include <stdio.h>
#include <stdlib.h>

u_int16 ELSCoder::allowable[2*JOTS_PER_BYTE] = 
		{
			1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
			2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
			3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
			4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
			6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
			7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
			8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9,
			9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10,
			10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
			10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
			11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12,
			12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
			13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15,
			15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16,
			16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17,
			17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19,
			19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20,
			21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22,
			22, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24,
			24, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26,
			27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 29, 29,
			29, 29, 30, 30, 30, 30, 30, 31, 31, 31, 31, 32,
			32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34,
			35, 35, 35, 35, 36, 36, 36, 36, 37, 37, 37, 38,
			38, 38, 38, 39, 39, 39, 39, 40, 40, 40, 41, 41,
			41, 42, 42, 42, 42, 43, 43, 43, 44, 44, 44, 45,
			45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 48, 49,
			49, 49, 50, 50, 51, 51, 51, 52, 52, 52, 53, 53,
			54, 54, 54, 55, 55, 56, 56, 56, 57, 57, 58, 58,
			58, 59, 59, 60, 60, 61, 61, 62, 62, 62, 63, 63,
			64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69,
			70, 70, 71, 71, 72, 72, 73, 73, 74, 74, 75, 75,
			76, 77, 77, 78, 78, 79, 79, 80, 81, 81, 82, 82,
			83, 84, 84, 85, 85, 86, 87, 87, 88, 89, 89, 90,
			91, 91, 92, 93, 93, 94, 95, 95, 96, 97, 97, 98,
			99, 100, 100, 101, 102, 103, 103, 104, 105, 106, 106, 107,
			108, 109, 110, 110, 111, 112, 113, 114, 114, 115, 116, 117,
			118, 119, 120, 121, 121, 122, 123, 124, 125, 126, 127, 128,
			129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140,
			141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
			153, 155, 156, 157, 158, 159, 160, 162, 163, 164, 165, 166,
			168, 169, 170, 171, 173, 174, 175, 176, 178, 179, 180, 182,
			183, 184, 186, 187, 188, 190, 191, 193, 194, 196, 197, 198,
			200, 201, 203, 204, 206, 207, 209, 210, 212, 214, 215, 217,
			218, 220, 221, 223, 225, 226, 228, 230, 231, 233, 235, 237,
			238, 240, 242, 244, 245, 247, 249, 251, 253, 255, 256, 258,
			260, 262, 264, 266, 268, 270, 272, 274, 276, 278, 280, 282,
			284, 286, 288, 290, 292, 294, 297, 299, 301, 303, 305, 308,
			310, 312, 315, 317, 319, 322, 324, 326, 329, 331, 334, 336,
			339, 341, 344, 346, 349, 351, 354, 356, 359, 362, 364, 367,
			370, 373, 375, 378, 381, 384, 386, 389, 392, 395, 398, 401,
			404, 407, 410, 413, 416, 419, 422, 425, 428, 432, 435, 438,
			441, 444, 448, 451, 454, 458, 461, 464, 468, 471, 475, 478,
			482, 485, 489, 493, 496, 500, 504, 507, 511, 515, 519, 522,
			526, 530, 534, 538, 542, 546, 550, 554, 558, 562, 566, 571,
			575, 579, 583, 588, 592, 596, 601, 605, 610, 614, 619, 623,
			628, 633, 637, 642, 647, 651, 656, 661, 666, 671, 676, 681,
			686, 691, 696, 701, 706, 712, 717, 722, 727, 733, 738, 744,
			749, 755, 760, 766, 771, 777, 783, 789, 795, 800, 806, 812,
			818, 824, 830, 837, 843, 849, 855, 861, 868, 874, 881, 887,
			894, 900, 907, 914, 920, 927, 934, 941, 948, 955, 962, 969,
			976, 983, 991, 998, 1005, 1013, 1020, 1028, 1035, 1043, 1051, 1058,
			1066, 1074, 1082, 1090, 1098, 1106, 1114, 1123, 1131, 1139, 1148, 1156,
			1165, 1173, 1182, 1191, 1199, 1208, 1217, 1226, 1235, 1244, 1254, 1263,
			1272, 1281, 1291, 1300, 1310, 1320, 1329, 1339, 1349, 1359, 1369, 1379,
			1389, 1400, 1410, 1420, 1431, 1442, 1452, 1463, 1474, 1485, 1496, 1507,
			1518, 1529, 1540, 1552, 1563, 1575, 1586, 1598, 1610, 1622, 1633, 1646,
			1658, 1670, 1682, 1695, 1707, 1720, 1732, 1745, 1758, 1771, 1784, 1797,
			1811, 1824, 1837, 1851, 1865, 1878, 1892, 1906, 1920, 1935, 1949, 1963,
			1978, 1992, 2007, 2022, 2037, 2052, 2067, 2082, 2098, 2113, 2129, 2144,
			2160, 2176, 2192, 2208, 2225, 2241, 2258, 2274, 2291, 2308, 2325, 2342,
			2359, 2377, 2394, 2412, 2430, 2448, 2466, 2484, 2502, 2521, 2540, 2558,
			2577, 2596, 2615, 2635, 2654, 2674, 2693, 2713, 2733, 2754, 2774, 2794,
			2815, 2836, 2857, 2878, 2899, 2920, 2942, 2964, 2986, 3008, 3030, 3052,
			3075, 3097, 3120, 3143, 3166, 3190, 3213, 3237, 3261, 3285, 3309, 3334,
			3358, 3383, 3408, 3433, 3459, 3484, 3510, 3536, 3562, 3588, 3615, 3641,
			3668, 3695, 3723, 3750, 3778, 3806, 3834, 3862, 3890, 3919, 3948, 3977,
			4007, 4036, 4066, 4096, 4126, 4157, 4187, 4218, 4249, 4281, 4312, 4344,
			4376, 4409, 4441, 4474, 4507, 4540, 4574, 4607, 4641, 4676, 4710, 4745,
			4780, 4815, 4851, 4887, 4923, 4959, 4996, 5033, 5070, 5107, 5145, 5183,
			5221, 5260, 5298, 5338, 5377, 5417, 5457, 5497, 5537, 5578, 5620, 5661,
			5703, 5745, 5787, 5830, 5873, 5916, 5960, 6004, 6048, 6093, 6138, 6183,
			6229, 6275, 6321, 6368, 6415, 6462, 6510, 6558, 6606, 6655, 6704, 6754,
			6804, 6854, 6904, 6955, 7007, 7058, 7111, 7163, 7216, 7269, 7323, 7377,
			7431, 7486, 7542, 7597, 7653, 7710, 7767, 7824, 7882, 7940, 7999, 8058,
			8117, 8177, 8237, 8298, 8359, 8421, 8483, 8546, 8609, 8672, 8736, 8801,
			8866, 8931, 8997, 9064, 9131, 9198, 9266, 9334, 9403, 9473, 9543, 9613,
			9684, 9755, 9827, 9900, 9973,10047,10121,10196,10271,10347,10423,10500,
			10577,10655,10734,10813,10893,10974,11055,11136,11218,11301,11385,11469,
			11553,11639,11725,11811,11898,11986,12075,12164,12253,12344,12435,12527,
			12619,12712,12806,12901,12996,13092,13189,13286,13384,13483,13582,13683,
			13784,13885,13988,14091,14195,14300,14405,14512,14619,14727,14835,14945,
			15055,15166,15278,15391,15505,15619,15735,15851,15968,16086,16204,16324,
			16444,16566,16688,16811,16935,17060,17186,17313,17441,17570,17699,17830,
			17962,18094,18228,18362,18498,18634,18772,18910,19050,19191,19332,19475,
			19619,19764,19909,20056,20204,20354,20504,20655,20808,20961,21116,21272,
			21429,21587,21746,21907,22069,22232,22396,22561,22727,22895,23064,23234,
			23406,23579,23753,23928,24105,24283,24462,24642,24824,25008,25192,25378,
			25565,25754,25944,26136,26329,26523,26719,26916,27115,27315,27517,27720,
			27924,28130,28338,28547,28758,28970,29184,29399,29616,29835,30055,30277,
			30501,30726,30953,31181,31411,31643,31877,32112,32349,32588,32828,33071,
			33315,33561,33808,34058,34309,34563,34818,35075,35334,35594,35857,36122,
			36388,36657,36928,37200,37475,37751,38030,38311,38594,38878,39165,39455,
			39746,40039,40335,40632,40932,41235,41539,41846,42154,42466,42779,43095,
			43413,43733,44056,44381,44709,45039,45371,45706,46044,46384,46726,47071,
			47418,47768,48121,48476,48834,49194,49558,49923,50292,50663,51037,51414,
			51793,52176,52561,52949,53340,53733,54130,54529,54932,55337,55746,56157,
			56572,56989,57410,57834,58261,58691,59124,59561,60000,60443,60889,61339,
			61791,62248,62707,63170,63636,64106,64579,65056 
		};

ELSCoder::LadderStruct ELSCoder::ladder[256] = 
		{
#ifdef ALACRITOUS
			/* 0:0.50000 */ { allowable+ 665, 89, 101, 1, 2 },
			/* 1:0.33333 */ { allowable+ 692, 62, 138, 3, 4 },
			/* 2:0.66667 */ { allowable+ 616, 138, 62, 5, 6 },
			/* 3:0.23667 */ { allowable+ 716, 38, 194, 7, 8 },
			/* 4:0.52667 */ { allowable+ 653, 101, 89, 9, 10 },
			/* 5:0.47333 */ { allowable+ 665, 89, 101, 11, 12 },
			/* 6:0.76333 */ { allowable+ 560, 194, 38, 13, 14 },
			/* 7:0.17829 */ { allowable+ 727, 27, 236, 15, 16 },
			/* 8:0.42496 */ { allowable+ 679, 75, 118, 17, 18 },
			/* 9:0.39676 */ { allowable+ 689, 65, 133, 19, 20 },
			/* 10:0.64342 */ { allowable+ 616, 138, 62, 21, 22 },
			/* 11:0.35658 */ { allowable+ 692, 62, 138, 23, 24 },
			/* 12:0.60324 */ { allowable+ 621, 133, 65, 25, 26 },
			/* 13:0.57504 */ { allowable+ 636, 118, 75, 27, 28 },
			/* 14:0.82171 */ { allowable+ 518, 236, 27, 29, 30 },
			/* 15:0.14204 */ { allowable+ 732, 22, 262, 31, 32 },
			/* 16:0.34537 */ { allowable+ 692, 62, 138, 33, 34 },
			/* 17:0.33855 */ { allowable+ 692, 62, 138, 35, 36 },
			/* 18:0.54188 */ { allowable+ 646, 108, 83, 37, 38 },
			/* 19:0.31608 */ { allowable+ 704, 50, 162, 39, 40 },
			/* 20:0.51942 */ { allowable+ 653, 101, 89, 41, 42 },
			/* 21:0.51259 */ { allowable+ 653, 101, 89, 43, 44 },
			/* 22:0.71593 */ { allowable+ 580, 174, 45, 45, 46 },
			/* 23:0.28407 */ { allowable+ 709, 45, 174, 47, 48 },
			/* 24:0.48741 */ { allowable+ 665, 89, 101, 49, 50 },
			/* 25:0.48058 */ { allowable+ 665, 89, 101, 51, 52 },
			/* 26:0.68392 */ { allowable+ 592, 162, 50, 53, 54 },
			/* 27:0.45812 */ { allowable+ 671, 83, 108, 55, 56 },
			/* 28:0.66145 */ { allowable+ 616, 138, 62, 57, 58 },
			/* 29:0.65463 */ { allowable+ 616, 138, 62, 59, 60 },
			/* 30:0.85796 */ { allowable+ 492, 262, 22, 61, 62 },
			/* 31:0.11931 */ { allowable+ 737, 17, 295, 63, 64 },
			/* 32:0.27931 */ { allowable+ 709, 45, 174, 65, 66 },
			/* 33:0.29011 */ { allowable+ 709, 45, 174, 67, 68 },
			/* 34:0.45011 */ { allowable+ 671, 83, 108, 69, 70 },
			/* 35:0.28438 */ { allowable+ 709, 45, 174, 71, 72 },
			/* 36:0.44438 */ { allowable+ 679, 75, 118, 73, 74 },
			/* 37:0.45518 */ { allowable+ 671, 83, 108, 75, 76 },
			/* 38:0.61518 */ { allowable+ 621, 133, 65, 77, 78 },
			/* 39:0.26551 */ { allowable+ 713, 41, 185, 79, 80 },
			/* 40:0.42551 */ { allowable+ 679, 75, 118, 81, 82 },
			/* 41:0.43631 */ { allowable+ 679, 75, 118, 83, 84 },
			/* 42:0.59631 */ { allowable+ 636, 118, 75, 85, 86 },
			/* 43:0.43058 */ { allowable+ 679, 75, 118, 87, 88 },
			/* 44:0.59058 */ { allowable+ 636, 118, 75, 89, 90 },
			/* 45:0.60138 */ { allowable+ 621, 133, 65, 91, 92 },
			/* 46:0.76138 */ { allowable+ 560, 194, 38, 93, 94 },
			/* 47:0.23862 */ { allowable+ 716, 38, 194, 95, 96 },
			/* 48:0.39862 */ { allowable+ 689, 65, 133, 97, 98 },
			/* 49:0.40942 */ { allowable+ 679, 75, 118, 99, 100 },
			/* 50:0.56942 */ { allowable+ 636, 118, 75, 101, 102 },
			/* 51:0.40369 */ { allowable+ 679, 75, 118, 103, 104 },
			/* 52:0.56369 */ { allowable+ 636, 118, 75, 105, 106 },
			/* 53:0.57449 */ { allowable+ 636, 118, 75, 107, 108 },
			/* 54:0.73449 */ { allowable+ 569, 185, 41, 109, 110 },
			/* 55:0.38482 */ { allowable+ 689, 65, 133, 111, 112 },
			/* 56:0.54482 */ { allowable+ 646, 108, 83, 113, 114 },
			/* 57:0.55562 */ { allowable+ 636, 118, 75, 115, 116 },
			/* 58:0.71562 */ { allowable+ 580, 174, 45, 117, 118 },
			/* 59:0.54989 */ { allowable+ 646, 108, 83, 119, 120 },
			/* 60:0.70989 */ { allowable+ 580, 174, 45, 121, 122 },
			/* 61:0.72069 */ { allowable+ 580, 174, 45, 123, 124 },
			/* 62:0.88069 */ { allowable+ 459, 295, 17, 125, 126 },
			/* 63:0.10539 */ { allowable+ 738, 16, 303, 152, 161 },
			/* 64:0.22206 */ { allowable+ 721, 33, 211, 165, 172 },
			/* 65:0.24672 */ { allowable+ 716, 38, 194, 167, 174 },
			/* 66:0.36339 */ { allowable+ 692, 62, 138, 177, 183 },
			/* 67:0.25626 */ { allowable+ 713, 41, 185, 168, 175 },
			/* 68:0.37293 */ { allowable+ 692, 62, 138, 178, 184 },
			/* 69:0.39760 */ { allowable+ 689, 65, 133, 180, 186 },
			/* 70:0.51426 */ { allowable+ 653, 101, 89, 189, 195 },
			/* 71:0.25120 */ { allowable+ 713, 41, 185, 168, 174 },
			/* 72:0.36787 */ { allowable+ 692, 62, 138, 177, 183 },
			/* 73:0.39254 */ { allowable+ 689, 65, 133, 179, 185 },
			/* 74:0.50920 */ { allowable+ 653, 101, 89, 188, 194 },
			/* 75:0.40208 */ { allowable+ 679, 75, 118, 180, 186 },
			/* 76:0.51874 */ { allowable+ 653, 101, 89, 189, 195 },
			/* 77:0.54341 */ { allowable+ 646, 108, 83, 191, 197 },
			/* 78:0.66008 */ { allowable+ 616, 138, 62, 200, 206 },
			/* 79:0.23453 */ { allowable+ 716, 38, 194, 166, 173 },
			/* 80:0.35120 */ { allowable+ 692, 62, 138, 176, 182 },
			/* 81:0.37587 */ { allowable+ 689, 65, 133, 178, 184 },
			/* 82:0.49253 */ { allowable+ 665, 89, 101, 187, 193 },
			/* 83:0.38541 */ { allowable+ 689, 65, 133, 179, 185 },
			/* 84:0.50207 */ { allowable+ 653, 101, 89, 188, 194 },
			/* 85:0.52674 */ { allowable+ 653, 101, 89, 190, 196 },
			/* 86:0.64341 */ { allowable+ 616, 138, 62, 198, 205 },
			/* 87:0.38034 */ { allowable+ 689, 65, 133, 178, 184 },
			/* 88:0.49701 */ { allowable+ 665, 89, 101, 187, 193 },
			/* 89:0.52168 */ { allowable+ 653, 101, 89, 189, 195 },
			/* 90:0.63834 */ { allowable+ 616, 138, 62, 198, 204 },
			/* 91:0.53122 */ { allowable+ 653, 101, 89, 190, 196 },
			/* 92:0.64788 */ { allowable+ 616, 138, 62, 199, 205 },
			/* 93:0.67255 */ { allowable+ 592, 162, 50, 201, 207 },
			/* 94:0.78922 */ { allowable+ 543, 211, 33, 210, 217 },
			/* 95:0.21078 */ { allowable+ 721, 33, 211, 164, 171 },
			/* 96:0.32745 */ { allowable+ 704, 50, 162, 174, 180 },
			/* 97:0.35212 */ { allowable+ 692, 62, 138, 176, 182 },
			/* 98:0.46878 */ { allowable+ 665, 89, 101, 185, 191 },
			/* 99:0.36166 */ { allowable+ 692, 62, 138, 177, 183 },
			/* 100:0.47832 */ { allowable+ 665, 89, 101, 186, 192 },
			/* 101:0.50299 */ { allowable+ 653, 101, 89, 188, 194 },
			/* 102:0.61966 */ { allowable+ 621, 133, 65, 197, 203 },
			/* 103:0.35659 */ { allowable+ 692, 62, 138, 176, 183 },
			/* 104:0.47326 */ { allowable+ 665, 89, 101, 185, 191 },
			/* 105:0.49793 */ { allowable+ 665, 89, 101, 187, 193 },
			/* 106:0.61459 */ { allowable+ 621, 133, 65, 196, 202 },
			/* 107:0.50747 */ { allowable+ 653, 101, 89, 188, 194 },
			/* 108:0.62413 */ { allowable+ 621, 133, 65, 197, 203 },
			/* 109:0.64880 */ { allowable+ 616, 138, 62, 199, 205 },
			/* 110:0.76547 */ { allowable+ 560, 194, 38, 208, 215 },
			/* 111:0.33992 */ { allowable+ 692, 62, 138, 175, 181 },
			/* 112:0.45659 */ { allowable+ 671, 83, 108, 184, 190 },
			/* 113:0.48126 */ { allowable+ 665, 89, 101, 186, 192 },
			/* 114:0.59792 */ { allowable+ 636, 118, 75, 195, 201 },
			/* 115:0.49080 */ { allowable+ 665, 89, 101, 187, 193 },
			/* 116:0.60746 */ { allowable+ 621, 133, 65, 196, 202 },
			/* 117:0.63213 */ { allowable+ 616, 138, 62, 198, 204 },
			/* 118:0.74880 */ { allowable+ 569, 185, 41, 207, 213 },
			/* 119:0.48574 */ { allowable+ 665, 89, 101, 186, 192 },
			/* 120:0.60240 */ { allowable+ 621, 133, 65, 195, 201 },
			/* 121:0.62707 */ { allowable+ 616, 138, 62, 197, 203 },
			/* 122:0.74374 */ { allowable+ 569, 185, 41, 206, 213 },
			/* 123:0.63661 */ { allowable+ 616, 138, 62, 198, 204 },
			/* 124:0.75328 */ { allowable+ 560, 194, 38, 207, 214 },
			/* 125:0.77794 */ { allowable+ 543, 211, 33, 209, 216 },
			/* 126:0.89461 */ { allowable+ 451, 303, 16, 220, 229 },
			/* 127:0.00004 */ { allowable+ 753, 1, 716, 127, 141 },
			/* 128:0.00034 */ { allowable+ 753, 1, 716, 127, 141 },
			/* 129:0.00094 */ { allowable+ 753, 1, 716, 128, 141 },
			/* 130:0.00184 */ { allowable+ 753, 1, 716, 129, 141 },
			/* 131:0.00305 */ { allowable+ 753, 1, 716, 130, 141 },
			/* 132:0.00455 */ { allowable+ 753, 1, 716, 131, 142 },
			/* 133:0.00635 */ { allowable+ 753, 1, 716, 132, 142 },
			/* 134:0.00845 */ { allowable+ 753, 1, 716, 133, 143 },
			/* 135:0.01084 */ { allowable+ 752, 2, 606, 134, 143 },
			/* 136:0.01353 */ { allowable+ 752, 2, 606, 135, 144 },
			/* 137:0.01651 */ { allowable+ 751, 3, 538, 136, 144 },
			/* 138:0.01978 */ { allowable+ 751, 3, 538, 137, 145 },
			/* 139:0.02335 */ { allowable+ 750, 4, 496, 138, 145 },
			/* 140:0.02720 */ { allowable+ 750, 4, 496, 139, 146 },
			/* 141:0.03133 */ { allowable+ 749, 5, 462, 140, 147 },
			/* 142:0.03575 */ { allowable+ 749, 5, 462, 141, 147 },
			/* 143:0.04044 */ { allowable+ 748, 6, 436, 142, 148 },
			/* 144:0.04542 */ { allowable+ 748, 6, 436, 143, 149 },
			/* 145:0.05066 */ { allowable+ 747, 7, 415, 144, 150 },
			/* 146:0.05618 */ { allowable+ 745, 9, 380, 145, 151 },
			/* 147:0.06196 */ { allowable+ 745, 9, 380, 146, 151 },
			/* 148:0.06801 */ { allowable+ 744, 10, 366, 147, 152 },
			/* 149:0.07432 */ { allowable+ 743, 11, 353, 148, 153 },
			/* 150:0.08089 */ { allowable+ 741, 13, 330, 149, 154 },
			/* 151:0.08771 */ { allowable+ 741, 13, 330, 150, 155 },
			/* 152:0.09477 */ { allowable+ 741, 13, 330, 151, 156 },
			/* 153:0.10208 */ { allowable+ 738, 16, 303, 152, 156 },
			/* 154:0.10963 */ { allowable+ 738, 16, 303, 153, 157 },
			/* 155:0.11742 */ { allowable+ 737, 17, 295, 154, 158 },
			/* 156:0.12543 */ { allowable+ 736, 18, 288, 155, 159 },
			/* 157:0.13367 */ { allowable+ 732, 22, 262, 156, 160 },
			/* 158:0.14213 */ { allowable+ 732, 22, 262, 157, 161 },
			/* 159:0.15081 */ { allowable+ 731, 23, 256, 158, 162 },
			/* 160:0.15970 */ { allowable+ 731, 23, 256, 159, 163 },
			/* 161:0.16879 */ { allowable+ 727, 27, 236, 160, 164 },
			/* 162:0.17808 */ { allowable+ 727, 27, 236, 161, 165 },
			/* 163:0.18757 */ { allowable+ 727, 27, 236, 162, 165 },
			/* 164:0.19724 */ { allowable+ 722, 32, 215, 163, 166 },
			/* 165:0.20710 */ { allowable+ 721, 33, 211, 164, 167 },
			/* 166:0.21713 */ { allowable+ 721, 33, 211, 165, 168 },
			/* 167:0.22734 */ { allowable+ 716, 38, 194, 166, 169 },
			/* 168:0.23771 */ { allowable+ 716, 38, 194, 167, 170 },
			/* 169:0.24823 */ { allowable+ 716, 38, 194, 168, 171 },
			/* 170:0.25891 */ { allowable+ 713, 41, 185, 169, 172 },
			/* 171:0.26973 */ { allowable+ 709, 45, 174, 170, 173 },
			/* 172:0.28069 */ { allowable+ 709, 45, 174, 171, 174 },
			/* 173:0.29179 */ { allowable+ 709, 45, 174, 172, 175 },
			/* 174:0.30300 */ { allowable+ 704, 50, 162, 173, 176 },
			/* 175:0.31434 */ { allowable+ 704, 50, 162, 174, 177 },
			/* 176:0.32579 */ { allowable+ 704, 50, 162, 175, 178 },
			/* 177:0.33734 */ { allowable+ 692, 62, 138, 176, 179 },
			/* 178:0.34900 */ { allowable+ 692, 62, 138, 177, 180 },
			/* 179:0.36074 */ { allowable+ 692, 62, 138, 178, 181 },
			/* 180:0.37257 */ { allowable+ 692, 62, 138, 179, 182 },
			/* 181:0.38447 */ { allowable+ 689, 65, 133, 180, 183 },
			/* 182:0.39644 */ { allowable+ 689, 65, 133, 181, 184 },
			/* 183:0.40848 */ { allowable+ 679, 75, 118, 182, 184 },
			/* 184:0.42057 */ { allowable+ 679, 75, 118, 183, 185 },
			/* 185:0.43271 */ { allowable+ 679, 75, 118, 184, 186 },
			/* 186:0.44489 */ { allowable+ 671, 83, 108, 185, 187 },
			/* 187:0.45710 */ { allowable+ 671, 83, 108, 186, 188 },
			/* 188:0.46934 */ { allowable+ 665, 89, 101, 187, 189 },
			/* 189:0.48160 */ { allowable+ 665, 89, 101, 188, 190 },
			/* 190:0.49386 */ { allowable+ 665, 89, 101, 189, 191 },
			/* 191:0.50614 */ { allowable+ 653, 101, 89, 190, 192 },
			/* 192:0.51840 */ { allowable+ 653, 101, 89, 191, 193 },
			/* 193:0.53066 */ { allowable+ 653, 101, 89, 192, 194 },
			/* 194:0.54290 */ { allowable+ 646, 108, 83, 193, 195 },
			/* 195:0.55511 */ { allowable+ 646, 108, 83, 194, 196 },
			/* 196:0.56729 */ { allowable+ 636, 118, 75, 195, 197 },
			/* 197:0.57943 */ { allowable+ 636, 118, 75, 196, 198 },
			/* 198:0.59152 */ { allowable+ 636, 118, 75, 197, 199 },
			/* 199:0.60356 */ { allowable+ 621, 133, 65, 197, 200 },
			/* 200:0.61553 */ { allowable+ 621, 133, 65, 198, 201 },
			/* 201:0.62743 */ { allowable+ 616, 138, 62, 199, 202 },
			/* 202:0.63926 */ { allowable+ 616, 138, 62, 200, 203 },
			/* 203:0.65100 */ { allowable+ 616, 138, 62, 201, 204 },
			/* 204:0.66266 */ { allowable+ 616, 138, 62, 202, 205 },
			/* 205:0.67421 */ { allowable+ 592, 162, 50, 203, 206 },
			/* 206:0.68566 */ { allowable+ 592, 162, 50, 204, 207 },
			/* 207:0.69700 */ { allowable+ 592, 162, 50, 205, 208 },
			/* 208:0.70821 */ { allowable+ 580, 174, 45, 206, 209 },
			/* 209:0.71931 */ { allowable+ 580, 174, 45, 207, 210 },
			/* 210:0.73027 */ { allowable+ 580, 174, 45, 208, 211 },
			/* 211:0.74109 */ { allowable+ 569, 185, 41, 209, 212 },
			/* 212:0.75177 */ { allowable+ 560, 194, 38, 210, 213 },
			/* 213:0.76229 */ { allowable+ 560, 194, 38, 211, 214 },
			/* 214:0.77266 */ { allowable+ 560, 194, 38, 212, 215 },
			/* 215:0.78287 */ { allowable+ 543, 211, 33, 213, 216 },
			/* 216:0.79290 */ { allowable+ 543, 211, 33, 214, 217 },
			/* 217:0.80276 */ { allowable+ 539, 215, 32, 215, 218 },
			/* 218:0.81243 */ { allowable+ 518, 236, 27, 216, 219 },
			/* 219:0.82192 */ { allowable+ 518, 236, 27, 216, 220 },
			/* 220:0.83121 */ { allowable+ 518, 236, 27, 217, 221 },
			/* 221:0.84030 */ { allowable+ 498, 256, 23, 218, 222 },
			/* 222:0.84919 */ { allowable+ 498, 256, 23, 219, 223 },
			/* 223:0.85787 */ { allowable+ 492, 262, 22, 220, 224 },
			/* 224:0.86633 */ { allowable+ 492, 262, 22, 221, 225 },
			/* 225:0.87457 */ { allowable+ 466, 288, 18, 222, 226 },
			/* 226:0.88258 */ { allowable+ 459, 295, 17, 223, 227 },
			/* 227:0.89037 */ { allowable+ 451, 303, 16, 224, 228 },
			/* 228:0.89792 */ { allowable+ 451, 303, 16, 225, 229 },
			/* 229:0.90523 */ { allowable+ 424, 330, 13, 225, 230 },
			/* 230:0.91229 */ { allowable+ 424, 330, 13, 226, 231 },
			/* 231:0.91911 */ { allowable+ 424, 330, 13, 227, 232 },
			/* 232:0.92568 */ { allowable+ 401, 353, 11, 228, 233 },
			/* 233:0.93199 */ { allowable+ 388, 366, 10, 229, 234 },
			/* 234:0.93804 */ { allowable+ 374, 380, 9, 230, 235 },
			/* 235:0.94382 */ { allowable+ 374, 380, 9, 230, 236 },
			/* 236:0.94934 */ { allowable+ 339, 415, 7, 231, 237 },
			/* 237:0.95458 */ { allowable+ 318, 436, 6, 232, 238 },
			/* 238:0.95956 */ { allowable+ 318, 436, 6, 233, 239 },
			/* 239:0.96425 */ { allowable+ 292, 462, 5, 234, 240 },
			/* 240:0.96867 */ { allowable+ 292, 462, 5, 234, 241 },
			/* 241:0.97280 */ { allowable+ 258, 496, 4, 235, 242 },
			/* 242:0.97665 */ { allowable+ 258, 496, 4, 236, 243 },
			/* 243:0.98022 */ { allowable+ 216, 538, 3, 236, 244 },
			/* 244:0.98349 */ { allowable+ 216, 538, 3, 237, 245 },
			/* 245:0.98647 */ { allowable+ 148, 606, 2, 237, 246 },
			/* 246:0.98916 */ { allowable+ 148, 606, 2, 238, 247 },
			/* 247:0.99155 */ { allowable+ 38, 716, 1, 238, 248 },
			/* 248:0.99365 */ { allowable+ 38, 716, 1, 239, 249 },
			/* 249:0.99545 */ { allowable+ 38, 716, 1, 239, 250 },
			/* 250:0.99695 */ { allowable+ 38, 716, 1, 240, 251 },
			/* 251:0.99816 */ { allowable+ 38, 716, 1, 240, 252 },
			/* 252:0.99906 */ { allowable+ 38, 716, 1, 240, 253 },
			/* 253:0.99966 */ { allowable+ 38, 716, 1, 240, 254 },
			/* 254:0.99996 */ { allowable+ 38, 716, 1, 240, 254 },
#else
			/* 0:0.50000 */ { allowable+ 665, 89, 101, 1, 2 },
			/* 1:0.32281 */ { allowable+ 704, 50, 162, 3, 4 },
			/* 2:0.65614 */ { allowable+ 616, 138, 62, 5, 6 },
			/* 3:0.14678 */ { allowable+ 731, 23, 256, 7, 8 },
			/* 4:0.43678 */ { allowable+ 679, 75, 118, 9, 10 },
			/* 5:0.52228 */ { allowable+ 653, 101, 89, 11, 12 },
			/* 6:0.81228 */ { allowable+ 518, 236, 27, 13, 14 },
			/* 7:0.03670 */ { allowable+ 749, 5, 462, 15, 16 },
			/* 8:0.20427 */ { allowable+ 721, 33, 211, 17, 18 },
			/* 9:0.30122 */ { allowable+ 704, 50, 162, 19, 20 },
			/* 10:0.54788 */ { allowable+ 646, 108, 83, 21, 22 },
			/* 11:0.40125 */ { allowable+ 679, 75, 118, 23, 24 },
			/* 12:0.64791 */ { allowable+ 616, 138, 62, 25, 26 },
			/* 13:0.73060 */ { allowable+ 580, 174, 45, 27, 28 },
			/* 14:0.97727 */ { allowable+ 216, 538, 3, 29, 30 },
			/* 15:0.00917 */ { allowable+ 752, 2, 606, 31, 32 },
			/* 16:0.04451 */ { allowable+ 748, 6, 436, 33, 34 },
			/* 17:0.07792 */ { allowable+ 743, 11, 353, 35, 36 },
			/* 18:0.28125 */ { allowable+ 709, 45, 174, 37, 38 },
			/* 19:0.18273 */ { allowable+ 727, 27, 236, 39, 40 },
			/* 20:0.38606 */ { allowable+ 689, 65, 133, 41, 42 },
			/* 21:0.44983 */ { allowable+ 671, 83, 108, 43, 44 },
			/* 22:0.65317 */ { allowable+ 616, 138, 62, 45, 46 },
			/* 23:0.29689 */ { allowable+ 704, 50, 162, 47, 48 },
			/* 24:0.50022 */ { allowable+ 653, 101, 89, 49, 50 },
			/* 25:0.55589 */ { allowable+ 636, 118, 75, 51, 52 },
			/* 26:0.75922 */ { allowable+ 560, 194, 38, 53, 54 },
			/* 27:0.64678 */ { allowable+ 616, 138, 62, 55, 56 },
			/* 28:0.85011 */ { allowable+ 498, 256, 23, 57, 58 },
			/* 29:0.97318 */ { allowable+ 258, 496, 4, 59, 60 },
			/* 30:0.99432 */ { allowable+ 38, 716, 1, 61, 62 },
			/* 31:0.00229 */ { allowable+ 753, 1, 716, 63, 64 },
			/* 32:0.01163 */ { allowable+ 752, 2, 606, 65, 66 },
			/* 33:0.01113 */ { allowable+ 752, 2, 606, 67, 68 },
			/* 34:0.05438 */ { allowable+ 746, 8, 397, 69, 70 },
			/* 35:0.01948 */ { allowable+ 751, 3, 538, 71, 72 },
			/* 36:0.09947 */ { allowable+ 741, 13, 330, 73, 74 },
			/* 37:0.18492 */ { allowable+ 727, 27, 236, 75, 76 },
			/* 38:0.34492 */ { allowable+ 692, 62, 138, 77, 78 },
			/* 39:0.07689 */ { allowable+ 743, 11, 353, 79, 80 },
			/* 40:0.23689 */ { allowable+ 716, 38, 194, 81, 82 },
			/* 41:0.29603 */ { allowable+ 704, 50, 162, 83, 84 },
			/* 42:0.45603 */ { allowable+ 671, 83, 108, 85, 86 },
			/* 43:0.36736 */ { allowable+ 692, 62, 138, 87, 88 },
			/* 44:0.52736 */ { allowable+ 653, 101, 89, 89, 90 },
			/* 45:0.57984 */ { allowable+ 636, 118, 75, 91, 92 },
			/* 46:0.73984 */ { allowable+ 569, 185, 41, 93, 94 },
			/* 47:0.20446 */ { allowable+ 721, 33, 211, 95, 96 },
			/* 48:0.36446 */ { allowable+ 692, 62, 138, 97, 98 },
			/* 49:0.42524 */ { allowable+ 679, 75, 118, 99, 100 },
			/* 50:0.58524 */ { allowable+ 636, 118, 75, 101, 102 },
			/* 51:0.48500 */ { allowable+ 665, 89, 101, 103, 104 },
			/* 52:0.64500 */ { allowable+ 616, 138, 62, 105, 106 },
			/* 53:0.69813 */ { allowable+ 592, 162, 50, 107, 108 },
			/* 54:0.85813 */ { allowable+ 492, 262, 22, 109, 110 },
			/* 55:0.57456 */ { allowable+ 636, 118, 75, 111, 112 },
			/* 56:0.73456 */ { allowable+ 569, 185, 41, 113, 114 },
			/* 57:0.79610 */ { allowable+ 543, 211, 33, 115, 116 },
			/* 58:0.95610 */ { allowable+ 318, 436, 6, 117, 118 },
			/* 59:0.96730 */ { allowable+ 292, 462, 5, 119, 120 },
			/* 60:0.99330 */ { allowable+ 38, 716, 1, 121, 122 },
			/* 61:0.99328 */ { allowable+ 38, 716, 1, 123, 124 },
			/* 62:0.99858 */ { allowable+ 38, 716, 1, 125, 126 },
			/* 63:0.00057 */ { allowable+ 753, 1, 716, 127, 130 },
			/* 64:0.00334 */ { allowable+ 753, 1, 716, 129, 132 },
			/* 65:0.00291 */ { allowable+ 753, 1, 716, 129, 132 },
			/* 66:0.01407 */ { allowable+ 752, 2, 606, 131, 137 },
			/* 67:0.00278 */ { allowable+ 753, 1, 716, 129, 132 },
			/* 68:0.01358 */ { allowable+ 752, 2, 606, 131, 137 },
			/* 69:0.01359 */ { allowable+ 752, 2, 606, 131, 137 },
			/* 70:0.06867 */ { allowable+ 744, 10, 366, 137, 151 },
			/* 71:0.00487 */ { allowable+ 753, 1, 716, 129, 133 },
			/* 72:0.02358 */ { allowable+ 750, 4, 496, 133, 141 },
			/* 73:0.01347 */ { allowable+ 752, 2, 606, 131, 137 },
			/* 74:0.13014 */ { allowable+ 736, 18, 288, 150, 159 },
			/* 75:0.10736 */ { allowable+ 738, 16, 303, 146, 157 },
			/* 76:0.22403 */ { allowable+ 721, 33, 211, 162, 169 },
			/* 77:0.28197 */ { allowable+ 709, 45, 174, 168, 175 },
			/* 78:0.39863 */ { allowable+ 689, 65, 133, 179, 185 },
			/* 79:0.01922 */ { allowable+ 751, 3, 538, 132, 139 },
			/* 80:0.09846 */ { allowable+ 741, 13, 330, 144, 155 },
			/* 81:0.16535 */ { allowable+ 731, 23, 256, 155, 163 },
			/* 82:0.28202 */ { allowable+ 709, 45, 174, 168, 175 },
			/* 83:0.22875 */ { allowable+ 716, 38, 194, 163, 170 },
			/* 84:0.34541 */ { allowable+ 692, 62, 138, 174, 181 },
			/* 85:0.39516 */ { allowable+ 689, 65, 133, 178, 184 },
			/* 86:0.51183 */ { allowable+ 653, 101, 89, 189, 195 },
			/* 87:0.30158 */ { allowable+ 704, 50, 162, 170, 177 },
			/* 88:0.41825 */ { allowable+ 679, 75, 118, 181, 187 },
			/* 89:0.46952 */ { allowable+ 665, 89, 101, 185, 191 },
			/* 90:0.58618 */ { allowable+ 636, 118, 75, 195, 201 },
			/* 91:0.52532 */ { allowable+ 653, 101, 89, 190, 196 },
			/* 92:0.64199 */ { allowable+ 616, 138, 62, 199, 206 },
			/* 93:0.69473 */ { allowable+ 592, 162, 50, 204, 211 },
			/* 94:0.81140 */ { allowable+ 518, 236, 27, 215, 223 },
			/* 95:0.13193 */ { allowable+ 736, 18, 288, 150, 159 },
			/* 96:0.24859 */ { allowable+ 716, 38, 194, 165, 172 },
			/* 97:0.29904 */ { allowable+ 704, 50, 162, 170, 176 },
			/* 98:0.41571 */ { allowable+ 679, 75, 118, 180, 186 },
			/* 99:0.36249 */ { allowable+ 692, 62, 138, 176, 182 },
			/* 100:0.47915 */ { allowable+ 665, 89, 101, 186, 192 },
			/* 101:0.53008 */ { allowable+ 653, 101, 89, 190, 196 },
			/* 102:0.64675 */ { allowable+ 616, 138, 62, 200, 206 },
			/* 103:0.42473 */ { allowable+ 679, 75, 118, 181, 187 },
			/* 104:0.54139 */ { allowable+ 646, 108, 83, 191, 197 },
			/* 105:0.59256 */ { allowable+ 636, 118, 75, 195, 201 },
			/* 106:0.70923 */ { allowable+ 580, 174, 45, 206, 212 },
			/* 107:0.64954 */ { allowable+ 616, 138, 62, 200, 206 },
			/* 108:0.76621 */ { allowable+ 560, 194, 38, 211, 218 },
			/* 109:0.81883 */ { allowable+ 518, 236, 27, 216, 224 },
			/* 110:0.93550 */ { allowable+ 374, 380, 9, 231, 246 },
			/* 111:0.52068 */ { allowable+ 653, 101, 89, 189, 195 },
			/* 112:0.63734 */ { allowable+ 616, 138, 62, 199, 205 },
			/* 113:0.69021 */ { allowable+ 592, 162, 50, 204, 210 },
			/* 114:0.80688 */ { allowable+ 539, 215, 32, 215, 222 },
			/* 115:0.75187 */ { allowable+ 560, 194, 38, 209, 217 },
			/* 116:0.86854 */ { allowable+ 466, 288, 18, 222, 231 },
			/* 117:0.94624 */ { allowable+ 357, 397, 8, 233, 245 },
			/* 118:0.98903 */ { allowable+ 148, 606, 2, 245, 250 },
			/* 119:0.95945 */ { allowable+ 318, 436, 6, 236, 246 },
			/* 120:0.99182 */ { allowable+ 38, 716, 1, 247, 251 },
			/* 121:0.99226 */ { allowable+ 38, 716, 1, 247, 251 },
			/* 122:0.99832 */ { allowable+ 38, 716, 1, 250, 253 },
			/* 123:0.99224 */ { allowable+ 38, 716, 1, 247, 251 },
			/* 124:0.99832 */ { allowable+ 38, 716, 1, 250, 253 },
			/* 125:0.99753 */ { allowable+ 38, 716, 1, 250, 252 },
			/* 126:0.99964 */ { allowable+ 38, 716, 1, 251, 254 },
			/* 127:0.00004 */ { allowable+ 753, 1, 716, 127, 129 },
			/* 128:0.00034 */ { allowable+ 753, 1, 716, 127, 130 },
			/* 129:0.00094 */ { allowable+ 753, 1, 716, 128, 130 },
			/* 130:0.00184 */ { allowable+ 753, 1, 716, 128, 131 },
			/* 131:0.00305 */ { allowable+ 753, 1, 716, 129, 132 },
			/* 132:0.00455 */ { allowable+ 753, 1, 716, 129, 133 },
			/* 133:0.00635 */ { allowable+ 753, 1, 716, 130, 134 },
			/* 134:0.00845 */ { allowable+ 753, 1, 716, 130, 135 },
			/* 135:0.01084 */ { allowable+ 752, 2, 606, 131, 136 },
			/* 136:0.01353 */ { allowable+ 752, 2, 606, 131, 137 },
			/* 137:0.01651 */ { allowable+ 751, 3, 538, 132, 138 },
			/* 138:0.01978 */ { allowable+ 751, 3, 538, 132, 139 },
			/* 139:0.02335 */ { allowable+ 750, 4, 496, 129, 141 },
			/* 140:0.02720 */ { allowable+ 750, 4, 496, 132, 142 },
			/* 141:0.03133 */ { allowable+ 749, 5, 462, 134, 143 },
			/* 142:0.03575 */ { allowable+ 749, 5, 462, 136, 143 },
			/* 143:0.04044 */ { allowable+ 748, 6, 436, 137, 144 },
			/* 144:0.04542 */ { allowable+ 748, 6, 436, 139, 145 },
			/* 145:0.05066 */ { allowable+ 747, 7, 415, 140, 146 },
			/* 146:0.05618 */ { allowable+ 745, 9, 380, 142, 147 },
			/* 147:0.06196 */ { allowable+ 745, 9, 380, 143, 148 },
			/* 148:0.06801 */ { allowable+ 744, 10, 366, 144, 149 },
			/* 149:0.07432 */ { allowable+ 743, 11, 353, 145, 150 },
			/* 150:0.08089 */ { allowable+ 741, 13, 330, 147, 151 },
			/* 151:0.08771 */ { allowable+ 741, 13, 330, 148, 152 },
			/* 152:0.09477 */ { allowable+ 741, 13, 330, 149, 153 },
			/* 153:0.10208 */ { allowable+ 738, 16, 303, 150, 154 },
			/* 154:0.10963 */ { allowable+ 738, 16, 303, 151, 155 },
			/* 155:0.11742 */ { allowable+ 737, 17, 295, 152, 156 },
			/* 156:0.12543 */ { allowable+ 736, 18, 288, 153, 157 },
			/* 157:0.13367 */ { allowable+ 732, 22, 262, 155, 158 },
			/* 158:0.14213 */ { allowable+ 732, 22, 262, 156, 159 },
			/* 159:0.15081 */ { allowable+ 731, 23, 256, 157, 160 },
			/* 160:0.15970 */ { allowable+ 731, 23, 256, 158, 161 },
			/* 161:0.16879 */ { allowable+ 727, 27, 236, 159, 162 },
			/* 162:0.17808 */ { allowable+ 727, 27, 236, 160, 163 },
			/* 163:0.18757 */ { allowable+ 727, 27, 236, 161, 164 },
			/* 164:0.19724 */ { allowable+ 722, 32, 215, 162, 165 },
			/* 165:0.20710 */ { allowable+ 721, 33, 211, 163, 166 },
			/* 166:0.21713 */ { allowable+ 721, 33, 211, 164, 167 },
			/* 167:0.22734 */ { allowable+ 716, 38, 194, 165, 168 },
			/* 168:0.23771 */ { allowable+ 716, 38, 194, 166, 169 },
			/* 169:0.24823 */ { allowable+ 716, 38, 194, 167, 170 },
			/* 170:0.25891 */ { allowable+ 713, 41, 185, 168, 171 },
			/* 171:0.26973 */ { allowable+ 709, 45, 174, 169, 172 },
			/* 172:0.28069 */ { allowable+ 709, 45, 174, 170, 173 },
			/* 173:0.29179 */ { allowable+ 709, 45, 174, 171, 174 },
			/* 174:0.30300 */ { allowable+ 704, 50, 162, 172, 175 },
			/* 175:0.31434 */ { allowable+ 704, 50, 162, 173, 176 },
			/* 176:0.32579 */ { allowable+ 704, 50, 162, 174, 177 },
			/* 177:0.33734 */ { allowable+ 692, 62, 138, 176, 178 },
			/* 178:0.34900 */ { allowable+ 692, 62, 138, 177, 179 },
			/* 179:0.36074 */ { allowable+ 692, 62, 138, 178, 180 },
			/* 180:0.37257 */ { allowable+ 692, 62, 138, 179, 181 },
			/* 181:0.38447 */ { allowable+ 689, 65, 133, 180, 182 },
			/* 182:0.39644 */ { allowable+ 689, 65, 133, 181, 183 },
			/* 183:0.40848 */ { allowable+ 679, 75, 118, 182, 184 },
			/* 184:0.42057 */ { allowable+ 679, 75, 118, 183, 185 },
			/* 185:0.43271 */ { allowable+ 679, 75, 118, 184, 186 },
			/* 186:0.44489 */ { allowable+ 671, 83, 108, 185, 187 },
			/* 187:0.45710 */ { allowable+ 671, 83, 108, 186, 188 },
			/* 188:0.46934 */ { allowable+ 665, 89, 101, 187, 189 },
			/* 189:0.48160 */ { allowable+ 665, 89, 101, 188, 190 },
			/* 190:0.49386 */ { allowable+ 665, 89, 101, 189, 191 },
			/* 191:0.50614 */ { allowable+ 653, 101, 89, 190, 192 },
			/* 192:0.51840 */ { allowable+ 653, 101, 89, 191, 193 },
			/* 193:0.53066 */ { allowable+ 653, 101, 89, 192, 194 },
			/* 194:0.54290 */ { allowable+ 646, 108, 83, 193, 195 },
			/* 195:0.55511 */ { allowable+ 646, 108, 83, 194, 196 },
			/* 196:0.56729 */ { allowable+ 636, 118, 75, 195, 197 },
			/* 197:0.57943 */ { allowable+ 636, 118, 75, 196, 198 },
			/* 198:0.59152 */ { allowable+ 636, 118, 75, 197, 199 },
			/* 199:0.60356 */ { allowable+ 621, 133, 65, 198, 200 },
			/* 200:0.61553 */ { allowable+ 621, 133, 65, 199, 201 },
			/* 201:0.62743 */ { allowable+ 616, 138, 62, 200, 202 },
			/* 202:0.63926 */ { allowable+ 616, 138, 62, 201, 203 },
			/* 203:0.65100 */ { allowable+ 616, 138, 62, 202, 204 },
			/* 204:0.66266 */ { allowable+ 616, 138, 62, 203, 205 },
			/* 205:0.67421 */ { allowable+ 592, 162, 50, 204, 207 },
			/* 206:0.68566 */ { allowable+ 592, 162, 50, 205, 208 },
			/* 207:0.69700 */ { allowable+ 592, 162, 50, 206, 209 },
			/* 208:0.70821 */ { allowable+ 580, 174, 45, 207, 210 },
			/* 209:0.71931 */ { allowable+ 580, 174, 45, 208, 211 },
			/* 210:0.73027 */ { allowable+ 580, 174, 45, 209, 212 },
			/* 211:0.74109 */ { allowable+ 569, 185, 41, 210, 213 },
			/* 212:0.75177 */ { allowable+ 560, 194, 38, 211, 214 },
			/* 213:0.76229 */ { allowable+ 560, 194, 38, 212, 215 },
			/* 214:0.77266 */ { allowable+ 560, 194, 38, 213, 216 },
			/* 215:0.78287 */ { allowable+ 543, 211, 33, 214, 217 },
			/* 216:0.79290 */ { allowable+ 543, 211, 33, 215, 218 },
			/* 217:0.80276 */ { allowable+ 539, 215, 32, 216, 219 },
			/* 218:0.81243 */ { allowable+ 518, 236, 27, 217, 220 },
			/* 219:0.82192 */ { allowable+ 518, 236, 27, 218, 221 },
			/* 220:0.83121 */ { allowable+ 518, 236, 27, 219, 222 },
			/* 221:0.84030 */ { allowable+ 498, 256, 23, 220, 223 },
			/* 222:0.84919 */ { allowable+ 498, 256, 23, 221, 224 },
			/* 223:0.85787 */ { allowable+ 492, 262, 22, 222, 225 },
			/* 224:0.86633 */ { allowable+ 492, 262, 22, 223, 226 },
			/* 225:0.87457 */ { allowable+ 466, 288, 18, 224, 228 },
			/* 226:0.88258 */ { allowable+ 459, 295, 17, 225, 229 },
			/* 227:0.89037 */ { allowable+ 451, 303, 16, 226, 230 },
			/* 228:0.89792 */ { allowable+ 451, 303, 16, 227, 231 },
			/* 229:0.90523 */ { allowable+ 424, 330, 13, 228, 232 },
			/* 230:0.91229 */ { allowable+ 424, 330, 13, 229, 233 },
			/* 231:0.91911 */ { allowable+ 424, 330, 13, 230, 234 },
			/* 232:0.92568 */ { allowable+ 401, 353, 11, 231, 236 },
			/* 233:0.93199 */ { allowable+ 388, 366, 10, 232, 237 },
			/* 234:0.93804 */ { allowable+ 374, 380, 9, 233, 238 },
			/* 235:0.94382 */ { allowable+ 374, 380, 9, 234, 239 },
			/* 236:0.94934 */ { allowable+ 339, 415, 7, 235, 241 },
			/* 237:0.95458 */ { allowable+ 318, 436, 6, 236, 242 },
			/* 238:0.95956 */ { allowable+ 318, 436, 6, 237, 244 },
			/* 239:0.96425 */ { allowable+ 292, 462, 5, 238, 245 },
			/* 240:0.96867 */ { allowable+ 292, 462, 5, 238, 247 },
			/* 241:0.97280 */ { allowable+ 258, 496, 4, 239, 249 },
			/* 242:0.97665 */ { allowable+ 258, 496, 4, 240, 252 },
			/* 243:0.98022 */ { allowable+ 216, 538, 3, 242, 249 },
			/* 244:0.98349 */ { allowable+ 216, 538, 3, 243, 249 },
			/* 245:0.98647 */ { allowable+ 148, 606, 2, 244, 250 },
			/* 246:0.98916 */ { allowable+ 148, 606, 2, 245, 250 },
			/* 247:0.99155 */ { allowable+ 38, 716, 1, 246, 251 },
			/* 248:0.99365 */ { allowable+ 38, 716, 1, 247, 251 },
			/* 249:0.99545 */ { allowable+ 38, 716, 1, 248, 252 },
			/* 250:0.99695 */ { allowable+ 38, 716, 1, 249, 252 },
			/* 251:0.99816 */ { allowable+ 38, 716, 1, 250, 253 },
			/* 252:0.99906 */ { allowable+ 38, 716, 1, 251, 253 },
			/* 253:0.99966 */ { allowable+ 38, 716, 1, 251, 254 },
			/* 254:0.99996 */ { allowable+ 38, 716, 1, 252, 254 },
#endif
			/* 255:inactive*/ { allowable+ 38,1509,1509, 255, 255 } 
		};

//------------------------------

int ELSCoder::elsDecodeBit(u_int8 *rung)
{
	/* Determine whether 0 or 1. */
	if (decodeInfo.internalBuffer >= ladder[*rung].threshold[decodeInfo.jotCount])
	{
		/* 1: */
		decodeInfo.internalBuffer = static_cast<u_int16>(decodeInfo.internalBuffer-ladder[*rung].threshold[decodeInfo.jotCount]);
		decodeInfo.jotCount -= ladder[*rung].codeLength1;

#ifdef ALACRITOUS
		/* Update probability. */
		*rung = ladder[*rung].next1;
#endif

		if (decodeInfo.jotCount <= 0)
		{
			/* Import a byte. */
			if ((decodeInfo.jotCount += JOTS_PER_BYTE)<=0)
			{
				Fatal("elsDecodeBit: called with inactive rung.\n");
			}

			decodeInfo.internalBuffer <<= 8;
			decodeInfo.internalBuffer |= decodeInfo.externalIn[decodeInfo.externalIndex++];
#ifndef ALACRITOUS
			/* Update probability. */
			*rung = ladder[*rung].next1;
#endif
		}

		return 1;
	}
	else
	{
		/* 0: Buffer value need not change. */
		decodeInfo.jotCount -= ladder[*rung].codeLength0;

#ifdef ALACRITOUS
		/* Update probability */
		*rung = ladder[*rung].next0;
#endif

		if (decodeInfo.jotCount<=0)
		{
			/* Import a byte. */
			if ((decodeInfo.jotCount += JOTS_PER_BYTE)<=0)
			{
				Fatal("elsDecodeBit: called with inactive rung.\n");
			}

			decodeInfo.internalBuffer <<= 8;
			decodeInfo.internalBuffer |= decodeInfo.externalIn[decodeInfo.externalIndex++];
#ifndef ALACRITOUS
			/* Update probability */
			*rung = ladder[*rung].next0;
#endif
		}

		return 0;
	}
}

//------------------------------

int ELSCoder::elsDecodeOk()
{
	long x;

	if (decodeInfo.jotCount==JOTS_PER_BYTE)
		x = 65536l;
	else
		x = allowable[decodeInfo.jotCount+JOTS_PER_BYTE];

	x = (x*(decodeInfo.jotCount-1))/JOTS_PER_BYTE;
	return decodeInfo.internalBuffer == x;
}

//------------------------------

void ELSCoder::elsEncodeBit(u_int8 *rung, int bit)
{
	u_int8 tempStorage;

	if (bit)
	{
		/* Encode a 1 */
		encodeInfo.min += ladder[*rung].threshold[encodeInfo.jotCount];
		encodeInfo.jotCount -= ladder[*rung].codeLength1;
#ifdef ALACRITOUS
		*rung = ladder[*rung].next1;
#endif
	}
	else
	{
		/* Encode a 0. */
		encodeInfo.jotCount -= ladder[*rung].codeLength0;
#ifdef ALACRITOUS
		*rung = ladder[*rung].next0;
#endif
	}

	if (encodeInfo.jotCount<=0) /* Will the decoder import a byte? */
	{
		u_int32 diffBits;
		/* First check for bytes ready to export. */
		if ((encodeInfo.jotCount += JOTS_PER_BYTE)<=0)
		{
			Fatal("elsEncodeBit: called with inactive rung.\n");
		}

		diffBits = (encodeInfo.min + allowable[encodeInfo.jotCount] - 1) ^ encodeInfo.min;
		switch(encodeInfo.backlog)
		{
			default: /* 2 or greater */
				if (diffBits&0xFF000000)
					break;

				tempStorage=static_cast<u_int8>(encodeInfo.min>>24);
				encodeInfo.externalOut->writeBuffer(&tempStorage,1);

				while(--encodeInfo.backlog > 1)
				{
					tempStorage=static_cast<u_int8>((encodeInfo.min>>16)&0xFF);
					encodeInfo.externalOut->writeBuffer(&tempStorage,1);
				}
			case 1:
				if (diffBits&0x00FF0000)
					break;
				tempStorage=static_cast<u_int8>((encodeInfo.min>>16)&0xFF);
				encodeInfo.externalOut->writeBuffer(&tempStorage,1);
				encodeInfo.backlog--;
			case 0:
				if (diffBits&0x0000FF00)
					break;
				tempStorage=static_cast<u_int8>((encodeInfo.min>>8)&0xFF);
				encodeInfo.externalOut->writeBuffer(&tempStorage,1);
				encodeInfo.backlog--;
		}

		encodeInfo.backlog++;

		/* Now move one byte from preactive to active. */
		if (encodeInfo.backlog>2)
			encodeInfo.min = (encodeInfo.min&0xFF000000)|((encodeInfo.min&0x0000FFFF)<< 8);
		else encodeInfo.min <<= 8;

#ifndef ALACRITOUS
		if (bit)
			*rung = ladder[*rung].next1;
		else *rung = ladder[*rung].next0;
#endif
	}
}

//------------------------------

void ELSCoder::elsEncodeEnd()
{
	// Consistency check.
	int32 x;
	u_int8 tempStorage;

	if (encodeInfo.jotCount==JOTS_PER_BYTE)
		x = 65536l;
	else x = allowable[encodeInfo.jotCount+JOTS_PER_BYTE];

	x = (x*(encodeInfo.jotCount-1))/JOTS_PER_BYTE;
	encodeInfo.min += x;

	switch(encodeInfo.backlog)
	{
		default:
			tempStorage=static_cast<u_int8>((encodeInfo.min>>24)&0xFF);
			encodeInfo.externalOut->writeBuffer(&tempStorage,1);
			while(--encodeInfo.backlog > 1)
			{
				tempStorage=static_cast<u_int8>((encodeInfo.min>>16)&0xFF);
				encodeInfo.externalOut->writeBuffer(&tempStorage,1);
			}
		case 1:
			tempStorage=static_cast<u_int8>((encodeInfo.min>>16)&0xFF);
			encodeInfo.externalOut->writeBuffer(&tempStorage,1);
		case 0:
			tempStorage=static_cast<u_int8>((encodeInfo.min>>8)&0xFF);
			encodeInfo.externalOut->writeBuffer(&tempStorage,1);
	}
	tempStorage=static_cast<u_int8>((encodeInfo.min)&0xFF);
	encodeInfo.externalOut->writeBuffer(&tempStorage,1);
}

//------------------------------

const char *ELSCoder::identify(void)
{
	return "ELS Coder";
}

CompressorTypes ELSCoder::enumerate(void)
{
	return CT_ELSCoder;
}

void ELSCoder::compress(const CompressorInput &input,DecompressorInput *output)
{
	u_int32   loop;
	int       cIndex;
	u_int8    buffer;
	Bitstream outBits(input.lengthInBytes);

	memset(context,0,256*sizeof(u_int8));

	encodeInfo.backlog = 0;
	encodeInfo.min = 0;
	encodeInfo.jotCount = JOTS_PER_BYTE;
	encodeInfo.externalOut = &outBits;

	for (loop=0; loop<input.lengthInBytes; loop++)
	{
		buffer=static_cast<u_int8 *>(input.buffer)[loop];

		cIndex = 1;
		elsEncodeBit(context+cIndex,buffer&0x80);
		cIndex = (cIndex<<1) | !!(buffer&0x80);
		elsEncodeBit(context+cIndex,buffer&0x40);
		cIndex = (cIndex<<1) | !!(buffer&0x40);
		elsEncodeBit(context+cIndex,buffer&0x20);
		cIndex = (cIndex<<1) | !!(buffer&0x20);
		elsEncodeBit(context+cIndex,buffer&0x10);
		cIndex = (cIndex<<1) | !!(buffer&0x10);
		elsEncodeBit(context+cIndex,buffer&0x08);
		cIndex = (cIndex<<1) | !!(buffer&0x08);
		elsEncodeBit(context+cIndex,buffer&0x04);
		cIndex = (cIndex<<1) | !!(buffer&0x04);
		elsEncodeBit(context+cIndex,buffer&0x02);
		cIndex = (cIndex<<1) | !!(buffer&0x02);
		elsEncodeBit(context+cIndex,buffer&0x01);
		cIndex = (cIndex<<1) | !!(buffer&0x01);
		if (buffer==255)
		{
			/* Send 0 to distinguish from EOF marker. */
			elsEncodeBit(context,0);
		}
	}

	/* Send 255 followed by 1 for EOF marker. */
	elsEncodeBit(context+1,1);
	elsEncodeBit(context+3,1);
	elsEncodeBit(context+7,1);
	elsEncodeBit(context+15,1);
	elsEncodeBit(context+31,1);
	elsEncodeBit(context+63,1);
	elsEncodeBit(context+127,1);
	elsEncodeBit(context+255,1);
	elsEncodeBit(context,1);
	elsEncodeEnd();

	output->lengthInBytes=outBits.getPosition()/8+((outBits.getPosition() & 7)?1:0);
	output->buffer=MEM_OWN(outBits.copyStream());
}

void ELSCoder::decompress(const DecompressorInput &input,CompressorInput *output)
{
	u_int32   buffer;
	u_int8    tempStorage;
	Bitstream outBits(input.lengthInBytes);

	memset(context,0,256*sizeof(u_int8));

	decodeInfo.externalIn = static_cast<u_int8 *>(input.buffer);
	decodeInfo.jotCount = JOTS_PER_BYTE;

	/* Import first two bytes from external file. */
	decodeInfo.internalBuffer = static_cast<u_int16>((decodeInfo.externalIn[0]<<8) | decodeInfo.externalIn[1]);
	decodeInfo.externalIndex = 2;

	for (;;)
	{
		buffer=1;
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer = (buffer<<1) | elsDecodeBit(context+buffer);
		buffer &= 0xFF;

		if ((buffer==255) && elsDecodeBit(context))
		{
			if (!elsDecodeOk())
				Fatal("ELS Decoder consistency check failed.  Decode and Encode did not match.\n");
			break;
		}

		tempStorage=static_cast<u_int8>(buffer);
		outBits.writeBuffer(&buffer,1);
	}

	output->lengthInBytes=outBits.getPosition()/8+((outBits.getPosition() & 7)?1:0);
	output->buffer=MEM_OWN(outBits.copyStream());
}

ELSCoder::ELSCoder(void)
{
}

ELSCoder::~ELSCoder(void)
{
}
