/*
 * Decompiled with CFR 0.152.
 */
package com.overlast.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class StatBar {
    private StatType type;
    private ResourceLocation texture;
    private int fullWidth;
    private int fullHeight;
    private int defaultBarWidth;
    private int movingTextureX;
    private int movingTextureY;
    private float value = 0.0f;
    private float maxValue = 100.0f;

    public StatBar(StatType type, int fullWidth, int fullHeight, int defaultBarWidth, int movingTextureX, int movingTextureY, ResourceLocation texture) {
        this.type = type;
        this.fullWidth = fullWidth;
        this.fullHeight = fullHeight;
        this.defaultBarWidth = defaultBarWidth;
        this.movingTextureX = movingTextureX;
        this.movingTextureY = movingTextureY;
        this.texture = texture;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public int getFullWidth() {
        return this.fullWidth;
    }

    public int getFullHeight() {
        return this.fullHeight;
    }

    public int getMovingTextureX() {
        return this.movingTextureX;
    }

    public int getMovingTextureY() {
        return this.movingTextureY;
    }

    public int getFullBarWidth() {
        return this.defaultBarWidth;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public boolean shouldBeDisplayed() {
        Minecraft mc = Minecraft.func_71410_x();
        boolean isDebugEnabled = mc.field_71474_y.field_74330_P;
        if (!isDebugEnabled) {
            return true;
        }
        return this.type == StatType.EVOLUTION;
    }

    public int getMovingWidth() {
        double singleUnit = (double)this.defaultBarWidth / (double)this.maxValue;
        int width = (int)(singleUnit * (double)this.value);
        return width;
    }

    public String getTextToDisplay() {
        double roundedValue = (double)Math.round(this.value * 10.0f) / 10.0;
        double evoValue = (double)Math.round(this.value) / 1.0;
        String text = this.type == StatType.EVOLUTION ? (roundedValue >= 1000000.0 ? String.format("%.2f", evoValue / 10000.0) + "wP" : roundedValue + "P") : Double.toString(roundedValue);
        return text;
    }

    public static enum StatType {
        SANITY,
        EVOLUTION;

    }
}

