/*
 * Decompiled with CFR 0.152.
 */
package com.overlast.item.potion;

import com.overlast.creativetab.TabOverLast;
import com.overlast.lib.ModMobEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDrinkedPotion
extends Item {
    private final int canteenSips = 6;
    private final int canteenDurability = 30;

    public ItemDrinkedPotion() {
        this.setRegistryName(new ResourceLocation("overlast", "drinking_potion"));
        this.func_77625_d(1);
        this.func_77637_a(TabOverLast.TAB_overlast);
        this.setNoRepair();
        this.func_77627_a(true);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayerMP && !world.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)entityLiving;
            int canteenType = stack.func_77960_j();
            if (canteenType == 1) {
                player.func_70690_d(new PotionEffect(ModMobEffects.PARASITESPURIFY, 1800, 0, false, true));
            } else if (canteenType == 2) {
                player.func_70690_d(new PotionEffect(ModMobEffects.PARASITESINFECT, 1800, 0, false, true));
            } else if (canteenType == 3) {
                player.func_70690_d(new PotionEffect(ModMobEffects.PARASITESINFECT, 3600, 1, false, true));
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                if (nbt.func_74762_e("sips") > 0) {
                    nbt.func_74768_a("sips", nbt.func_74762_e("sips") - 1);
                } else {
                    nbt.func_74768_a("sips", nbt.func_74762_e("sips") - 1);
                    stack.func_77964_b(0);
                }
                nbt.func_74768_a("durability", nbt.func_74762_e("durability") - 1);
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack heldItem = player.func_184586_b(hand);
            NBTTagCompound nbt = heldItem.func_77978_p();
            if (heldItem.func_77960_j() == 0) {
                return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return "item.overlast.drinking_potion";
        }
        if (stack.func_77960_j() == 1) {
            return "item.overlast.drinking_potion_1";
        }
        if (stack.func_77960_j() == 2) {
            return "item.overlast.drinking_potion_2";
        }
        if (stack.func_77960_j() == 3) {
            return "item.overlast.drinking_potion_3";
        }
        stack.func_77964_b(0);
        return "item.overlast.drinking_potion";
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77960_j() == 0) {
                nbt.func_74768_a("sips", 0);
            } else {
                nbt.func_74768_a("sips", 6);
            }
            nbt.func_74768_a("durability", 30);
            stack.func_77982_d(nbt);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77960_j() == 0) {
                nbt.func_74768_a("sips", 0);
            } else {
                nbt.func_74768_a("sips", 6);
            }
            nbt.func_74768_a("durability", 30);
            stack.func_77982_d(nbt);
        } else {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74762_e("sips") <= 0) {
                stack.func_77964_b(0);
            }
            if (nbt.func_74762_e("durability") <= 0) {
                stack.func_190918_g(1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            float percentLeft = Math.round(nbt.func_74762_e("sips") * 100 / 6);
            if (percentLeft == 100.0f || percentLeft >= 80.0f) {
                tooltip.add(TextFormatting.GREEN + Integer.toString(nbt.func_74762_e("sips")) + " sips");
            } else if ((percentLeft <= 80.0f || percentLeft >= 20.0f) && nbt.func_74762_e("sips") > 1) {
                tooltip.add(TextFormatting.YELLOW + Integer.toString(nbt.func_74762_e("sips")) + " sips");
            } else if (nbt.func_74762_e("sips") == 1) {
                tooltip.add(TextFormatting.RED + Integer.toString(nbt.func_74762_e("sips")) + " sips");
            } else if (percentLeft <= 20.0f || percentLeft >= 0.0f) {
                tooltip.add(TextFormatting.RED + Integer.toString(nbt.func_74762_e("sips")) + " sips");
            } else {
                tooltip.add(TextFormatting.WHITE + Integer.toString(nbt.func_74762_e("sips")) + " sips");
            }
            if (nbt.func_74764_b("durability")) {
                tooltip.add(TextFormatting.GOLD + Integer.toString(nbt.func_74762_e("durability")) + " durability");
            }
        } else {
            tooltip.add(TextFormatting.BLUE + "Potion");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 4; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74762_e("sips") > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        int percentLeft = 0;
        double durabilityToShow = 0.0;
        if (nbt != null) {
            percentLeft = Math.round(nbt.func_74762_e("sips") * 100 / 6);
            durabilityToShow = 1.0 - (double)percentLeft / 100.0;
            return durabilityToShow;
        }
        return 1.0;
    }
}

