/*
 * Decompiled with CFR 0.152.
 */
package com.everlastsino.cate.blockEntity.blockEntities;

import com.everlastsino.cate.api.CateBlockEntityInventory;
import com.everlastsino.cate.blockEntity.CateBlockEntities;
import com.everlastsino.cate.blockEntity.blockEntities.SaucepanSlots;
import com.everlastsino.cate.recipe.CateRecipes;
import com.everlastsino.cate.recipe.recipes.PotCookingRecipe;
import com.everlastsino.cate.screen.screens.SaucepanScreenHandler;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3922;
import org.jetbrains.annotations.Nullable;

public class SaucepanBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
CateBlockEntityInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)11, (Object)class_1799.field_8037);
    private class_1856 latestIngredient;
    private class_1799 latestContainer;
    private class_1856 latestResult;
    private float experience = 0;
    private int cookingTime = 0;
    public boolean isCooking = false;
    public boolean isBeating;
    public int cookingTick = 0;
    public int temperature;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return SaucepanBlockEntity.this.isCooking ? 1 : 0;
                }
                case 1: {
                    return SaucepanBlockEntity.this.cookingTick;
                }
                case 2: {
                    return SaucepanBlockEntity.this.cookingTime;
                }
                case 3: {
                    return SaucepanBlockEntity.this.isBeating ? 1 : 0;
                }
                case 4: {
                    return SaucepanBlockEntity.this.temperature;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SaucepanBlockEntity.this.isCooking = value >= 1;
                    break;
                }
                case 1: {
                    SaucepanBlockEntity.this.cookingTick = value;
                    break;
                }
                case 2: {
                    SaucepanBlockEntity.this.cookingTime = value;
                    break;
                }
                case 3: {
                    SaucepanBlockEntity.this.isBeating = value >= 1;
                    break;
                }
                case 4: {
                    SaucepanBlockEntity.this.temperature = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };

    public SaucepanBlockEntity(class_2338 pos, class_2680 state) {
        super(CateBlockEntities.Saucepan_BlockEntity, pos, state);
        this.latestIngredient = this.latestResult = class_1856.field_9017;
        this.latestContainer = class_1799.field_8037;
    }

    public class_2371<class_1799> getIngredient() {
        class_2371 ingredients = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
        ingredients.set(0, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_1.ordinal())));
        ingredients.set(1, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_2.ordinal())));
        ingredients.set(2, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_3.ordinal())));
        ingredients.set(3, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_4.ordinal())));
        ingredients.set(4, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_5.ordinal())));
        ingredients.set(5, (Object)((class_1799)this.inventory.get(SaucepanSlots.INGREDIENT_6.ordinal())));
        return ingredients;
    }

    public void eraseIngredient() {
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || stack.method_7947() <= 0) continue;
            if (stack.method_7914() == 1) {
                class_1799 remainder = stack.method_7909().method_7857() ? new class_1799((class_1935)stack.method_7909().method_7858()) : class_1799.field_8037;
                this.inventory.set(i, (Object)remainder);
                continue;
            }
            stack.method_7934(1);
        }
        ((class_1799)this.inventory.get(SaucepanSlots.CONTAINER.ordinal())).method_7939(Math.max(0, ((class_1799)this.inventory.get(SaucepanSlots.CONTAINER.ordinal())).method_7947() - 1));
    }

    public class_2371<class_1799> getResults() {
        class_2371 ingredients = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        ingredients.set(0, (Object)((class_1799)this.inventory.get(SaucepanSlots.RESULT_1.ordinal())));
        ingredients.set(1, (Object)((class_1799)this.inventory.get(SaucepanSlots.RESULT_2.ordinal())));
        ingredients.set(2, (Object)((class_1799)this.inventory.get(SaucepanSlots.RESULT_3.ordinal())));
        return ingredients;
    }

    public void insertResults(class_1856 result) {
        List<class_1799> itemStacks = List.of(result.method_8105());
        for (int i = 0; i < 3 && i < itemStacks.size(); ++i) {
            int p = i + SaucepanSlots.RESULT_1.ordinal();
            this.inventory.set(p, (Object)itemStacks.get(i).method_7972());
        }
    }

    public class_1799 getContainer() {
        return (class_1799)this.inventory.get(SaucepanSlots.CONTAINER.ordinal());
    }

    public class_1799 getWaterContainer() {
        return (class_1799)this.inventory.get(SaucepanSlots.WATER_CONTAINER.ordinal());
    }

    public void eraseWater() {
        if (((class_1799)this.inventory.get(SaucepanSlots.WATER_CONTAINER.ordinal())).method_31574(class_1802.field_8705)) {
            this.inventory.set(SaucepanSlots.WATER_CONTAINER.ordinal(), (Object)new class_1799((class_1935)class_1802.field_8550));
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public boolean compareList(List<class_1799> itemStacks1, List<class_1799> itemStacks2) {
        int realSize = 0;
        for (class_1799 stack1 : itemStacks2) {
            realSize += stack1.method_31574(class_1802.field_8162) ? 0 : 1;
        }
        if (realSize != itemStacks1.size()) {
            return false;
        }
        for (class_1799 stack : itemStacks1) {
            boolean has = false;
            for (class_1799 stack1 : itemStacks2) {
                if (stack.method_7909() != stack1.method_7909()) continue;
                has = true;
                break;
            }
            if (has) continue;
            return false;
        }
        return true;
    }

    public void updateBeatingSituation() {
        this.isBeating = this.field_11863 != null && (this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(class_2246.field_17350) || this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(class_2246.field_23860)) && (Boolean)this.field_11863.method_8320(this.field_11867.method_10074()).method_11654((class_2769)class_3922.field_17352) != false;
        this.temperature = this.isBeating ? 75 : 20;
    }

    private static void dropExperience(class_3218 world, class_243 pos, float experience) {
        int i = class_3532.method_15375((float)experience);
        float f = class_3532.method_22450((float)experience);
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)i);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity instanceof SaucepanBlockEntity) {
            SaucepanBlockEntity entity = (SaucepanBlockEntity)blockEntity;
            entity.updateBeatingSituation();
            if (entity.cookingTime == 0) {
                List recipes = world.method_8433().method_30027(CateRecipes.Pot_Cooking_RecipeType);
                for (PotCookingRecipe recipe : recipes) {
                    if (!recipe.check((List<class_1799>)entity.getIngredient(), entity.getContainer())) continue;
                    entity.latestIngredient = recipe.ingredient;
                    entity.latestContainer = recipe.container.method_7972();
                    entity.latestResult = recipe.result;
                    entity.experience = recipe.experience;
                    entity.cookingTime = recipe.cookTime;
                    entity.method_5431();
                    break;
                }
            }
            if (entity.getWaterContainer().method_31574(class_1802.field_8705) && entity.getContainer().method_31574(entity.latestContainer.method_7909()) && ((class_1799)entity.getResults().get(0)).method_31574(class_1802.field_8162) && ((class_1799)entity.getResults().get(1)).method_31574(class_1802.field_8162) && ((class_1799)entity.getResults().get(2)).method_31574(class_1802.field_8162) && entity.compareList(List.of(entity.latestIngredient.method_8105()), (List<class_1799>)entity.getIngredient()) && entity.isBeating) {
                if (entity.cookingTime == entity.cookingTick) {
                    entity.insertResults(entity.latestResult);
                    entity.eraseWater();
                    entity.eraseIngredient();
                    SaucepanBlockEntity.dropExperience((class_3218)world, class_243.method_24953((class_2382)pos), entity.experience);
                    entity.experience = 0.0f;
                    return;
                }
                entity.isCooking = true;
                ++entity.cookingTick;
            } else {
                entity.cookingTime = 0;
                entity.cookingTick = 0;
                entity.isCooking = false;
            }
        }
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new SaucepanScreenHandler(syncId, inventory, this, this.propertyDelegate);
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.isCooking = nbt.method_10577("is_cooking");
        this.cookingTick = nbt.method_10550("cooking_tick");
        this.cookingTime = nbt.method_10550("cooking_time");
        this.experience = nbt.method_10583("experience");
        if (this.field_11863 != null) {
            List recipes = this.field_11863.method_8433().method_30027(CateRecipes.Pot_Cooking_RecipeType);
            for (PotCookingRecipe recipe : recipes) {
                if (!recipe.check((List<class_1799>)this.getIngredient(), this.getContainer())) continue;
                this.latestIngredient = recipe.ingredient;
                this.latestResult = recipe.result;
                this.experience = recipe.experience;
                this.cookingTime = recipe.cookTime;
                break;
            }
        }
        this.updateBeatingSituation();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10556("is_cooking", this.isCooking);
        nbt.method_10569("cooking_tick", this.cookingTick);
        nbt.method_10569("cooking_time", this.cookingTime);
        nbt.method_10548("experience", this.experience);
    }
}

