package com.verdantartifice.primalmagick.datagen.recipes;

import java.util.function.Consumer;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tags.BlockTagsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsForgeExt;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.Tags;

/**
 * Data provider for all of the mod's recipes.
 * 
 * @author Daedalus4096
 */
public class Recipes extends RecipeProvider {
    public Recipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        this.registerMarbleRecipes(consumer);
        this.registerEnchantedMarbleRecipes(consumer);
        this.registerSmokedMarbleRecipes(consumer);
        this.registerHallowedMarbleRecipes(consumer);
        this.registerSunwoodRecipes(consumer);
        this.registerMoonwoodRecipes(consumer);
        this.registerHallowoodRecipes(consumer);
        this.registerEssenceUpgradeRecipes(consumer);
        this.registerEssenceDowngradeRecipes(consumer);
        this.registerSaltRecipes(consumer);
        this.registerSkyglassRecipes(consumer);
        this.registerSkyglassPaneRecipes(consumer);
        this.registerEarthshatterHammerRecipes(consumer);
        this.registerMineralRecipes(consumer);
        this.registerPrimaliteRecipes(consumer);
        this.registerHexiumRecipes(consumer);
        this.registerHallowsteelRecipes(consumer);
        this.registerWandComponentRecipes(consumer);
        this.registerRitualCandleRecipes(consumer);
        this.registerRuneRecipes(consumer);
        this.registerGolemControllerRecipes(consumer);
        this.registerPixieRecipes(consumer);
        this.registerAmbrosiaRecipes(consumer);
        this.registerSanguineCrucibleRecipes(consumer);
        this.registerTinctureRecipes(consumer);
        this.registerPhilterRecipes(consumer);
        this.registerElixirRecipes(consumer);
        this.registerAlchemicalBombRecipes(consumer);
        this.registerClothRecipes(consumer);
        this.registerPrimalToolRecipes(consumer);
        this.registerManaFontRecipes(consumer);
        this.registerManaArrowRecipes(consumer);
        this.registerDissolutionChamberRecipes(consumer);
        
        ShapelessRecipeBuilder.shapeless(ItemsPM.MUNDANE_WAND.get())
            .requires(Tags.Items.RODS_WOODEN)
            .requires(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .unlockedBy("has_terrestrial_dust", has(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS))
            .save(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(BlocksPM.ANALYSIS_TABLE.get())
            .addIngredient(BlocksPM.WOOD_TABLE.get())
            .addIngredient(ItemsPM.MAGNIFYING_GLASS.get())
            .addIngredient(Items.PAPER)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FIRST_STEPS@2")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MAGNIFYING_GLASS.get())
            .patternLine(" I ")
            .patternLine("IGI")
            .patternLine("SI ")
            .key('I', Tags.Items.INGOTS_IRON)
            .key('G', Tags.Items.GLASS_PANES_COLORLESS)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FIRST_STEPS@2")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.WOOD_TABLE.get())
            .patternLine("SSS")
            .patternLine(" P ")
            .patternLine("SPS")
            .key('S', ItemTags.WOODEN_SLABS)
            .key('P', ItemTags.PLANKS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FIRST_STEPS@2")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELL_SCROLL_BLANK.get())
            .patternLine("  S")
            .patternLine("PPP")
            .patternLine("S  ")
            .key('S', Tags.Items.RODS_WOODEN)
            .key('P', Items.PAPER)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_SORCERY")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(BlocksPM.RESEARCH_TABLE.get())
            .addIngredient(BlocksPM.WOOD_TABLE.get())
            .addIngredient(Items.BOOK)
            .addIngredient(Items.PAPER)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("THEORYCRAFTING@2")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.ENCHANTED_INK.get())
            .addIngredient(Items.GLASS_BOTTLE)
            .addIngredient(Tags.Items.DYES_BLACK)
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("THEORYCRAFTING@2")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.ENCHANTED_INK_AND_QUILL.get())
            .addIngredient(ItemsPM.ENCHANTED_INK.get())
            .addIngredient(Tags.Items.FEATHERS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("THEORYCRAFTING@2")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SEASCRIBE_PEN.get())
            .patternLine(" GP")
            .patternLine("GIG")
            .patternLine("NG ")
            .key('G', Tags.Items.INGOTS_GOLD)
            .key('P', ItemsPM.MAGITECH_PARTS_BASIC.get())
            .key('I', ItemsPM.ENCHANTED_INK.get())
            .key('N', Tags.Items.NUGGETS_IRON)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SEASCRIBE_PEN")))
            .manaCost(new SourceList().add(Source.SEA, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(Items.STONE, 8)
            .patternLine("SSS")
            .patternLine("SDS")
            .patternLine("SSS")
            .key('S', Items.COBBLESTONE)
            .key('D', ItemsPM.ESSENCE_DUST_EARTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("STONEMELDING")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stone_from_stonemelding"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SUNLAMP.get())
            .patternLine("NNN")
            .patternLine("NTN")
            .patternLine("NNN")
            .key('N', ItemTagsPM.NUGGETS_PRIMALITE)
            .key('T', Items.TORCH)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUNLAMP")))
            .manaCost(new SourceList().add(Source.SUN, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPIRIT_LANTERN.get())
            .patternLine("NNN")
            .patternLine("NTN")
            .patternLine("NNN")
            .key('N', ItemTagsPM.NUGGETS_HEXIUM)
            .key('T', Items.SOUL_TORCH)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("SUNLAMP"), SimpleResearchKey.parse("HEXIUM")))
            .manaCost(new SourceList().add(Source.INFERNAL, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_PRISM.get())
            .patternLine(" N ")
            .patternLine("QDQ")
            .patternLine(" N ")
            .key('N', Tags.Items.NUGGETS_IRON)
            .key('Q', ItemTagsForgeExt.NUGGETS_QUARTZ)
            .key('D', ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_MANAWEAVING")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.MANA_SALTS.get())
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .addIngredient(ItemsPM.REFINED_SALT.get())
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_SALTS")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.WAND_CHARGER.get())
            .patternLine("GMG")
            .patternLine("MPM")
            .patternLine("GMG")
            .key('G', Tags.Items.INGOTS_GOLD)
            .key('M', ItemsPM.MARBLE_RAW.get())
            .key('P', ItemsPM.MANA_PRISM.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CHARGER")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCRAFTING_ALTAR.get())
            .patternLine("MMM")
            .patternLine("MSM")
            .patternLine("MMM")
            .key('M', ItemsPM.MARBLE_RAW.get())
            .key('S', ItemsPM.SPELL_SCROLL_BLANK.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_SORCERY")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.WAND_ASSEMBLY_TABLE.get())
            .patternLine("MM")
            .patternLine("MM")
            .key('M', ItemsPM.MARBLE_RUNED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ADVANCED_WANDMAKING")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.WAND_INSCRIPTION_TABLE.get())
            .addIngredient(ItemsPM.WOOD_TABLE.get())
            .addIngredient(ItemsPM.SPELL_SCROLL_BLANK.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_INSCRIPTION")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RITUAL_ALTAR.get())
            .patternLine("GRG")
            .patternLine("GMG")
            .key('G', Tags.Items.INGOTS_GOLD)
            .key('R', ItemsPM.MARBLE_RUNED.get())
            .key('M', ItemsPM.MARBLE_RAW.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_RITUAL")))
            .manaCost(new SourceList().add(Source.EARTH, 10).add(Source.SEA, 10).add(Source.SKY, 10).add(Source.SUN, 10).add(Source.MOON, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.OFFERING_PEDESTAL.get())
            .patternLine("S")
            .patternLine("P")
            .patternLine("S")
            .key('S', ItemsPM.MARBLE_SLAB.get())
            .key('P', ItemsPM.MARBLE_PILLAR.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_RITUAL")))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MANAFRUIT.get())
            .addIngredient(Items.APPLE)
            .addIngredient(Items.HONEY_BOTTLE)
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANAFRUIT")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .instability(1)
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.INCENSE_BRAZIER.get())
            .patternLine("GCG")
            .patternLine("GGG")
            .patternLine(" P ")
            .key('G', Tags.Items.INGOTS_GOLD)
            .key('C', ItemTags.COALS)
            .key('P', ItemTags.PLANKS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("INCENSE_BRAZIER")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.INCENSE_STICK.get())
            .patternLine(" F")
            .patternLine("S ")
            .key('F', ItemTags.SMALL_FLOWERS)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("INCENSE_BRAZIER")))
            .manaCost(new SourceList().add(Source.SKY, 1))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RITUAL_LECTERN.get())
            .patternLine("SSS")
            .patternLine(" B ")
            .patternLine(" S ")
            .key('S', ItemsPM.MOONWOOD_SLAB.get())
            .key('B', Tags.Items.BOOKSHELVES)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RITUAL_LECTERN")))
            .manaCost(new SourceList().add(Source.MOON, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RITUAL_BELL.get())
            .patternLine("PPP")
            .patternLine("PSP")
            .patternLine("PIP")
            .key('P', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .key('I', Tags.Items.NUGGETS_IRON)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RITUAL_BELL")))
            .manaCost(new SourceList().add(Source.SEA, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BLOODLETTER.get())
            .patternLine("MSM")
            .patternLine("MMM")
            .patternLine(" P ")
            .key('M', ItemsPM.MARBLE_SMOKED.get())
            .key('S', Items.DIAMOND_SWORD)
            .key('P', ItemsPM.MARBLE_SMOKED_PILLAR.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BLOODLETTER")))
            .manaCost(new SourceList().add(Source.BLOOD, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SOUL_ANVIL.get())
            .patternLine("BBB")
            .patternLine(" I ")
            .patternLine("III")
            .key('B', ItemTagsPM.STORAGE_BLOCKS_HEXIUM)
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SOUL_ANVIL")))
            .manaCost(new SourceList().add(Source.INFERNAL, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CELESTIAL_HARP.get())
            .patternLine("WWW")
            .patternLine("SSW")
            .patternLine("SW ")
            .key('W', ItemsPM.HALLOWOOD_PLANKS.get())
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CELESTIAL_HARP")))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SOUL_GEM.get())
            .requires(ItemsPM.SOUL_GEM_SLIVER.get(), 9)
            .unlockedBy("has_sliver", has(ItemsPM.SOUL_GEM_SLIVER.get()))
            .save(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RUNIC_GRINDSTONE.get())
            .patternLine(" D ")
            .patternLine("SLS")
            .patternLine("PDP")
            .key('D', ItemsPM.RUNE_DISPEL.get())
            .key('S', Tags.Items.RODS_WOODEN)
            .key('L', Items.STONE_SLAB)
            .key('P', ItemsPM.SUNWOOD_PLANKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNIC_GRINDSTONE")))
            .manaCost(new SourceList().add(Source.EARTH, 25))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CALCINATOR_BASIC.get())
            .patternLine("MMM")
            .patternLine("MFM")
            .patternLine("EEE")
            .key('M', ItemsPM.MARBLE_RAW.get())
            .key('F', ItemsPM.ESSENCE_FURNACE.get())
            .key('E', ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .setGroup("calcinators")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CALCINATOR_BASIC")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CALCINATOR_ENCHANTED.get())
            .patternLine("MMM")
            .patternLine("MCM")
            .patternLine("EEE")
            .key('M', ItemsPM.MARBLE_ENCHANTED.get())
            .key('C', ItemsPM.CALCINATOR_BASIC.get())
            .key('E', ItemTagsPM.ESSENCES_TERRESTRIAL_SHARDS)
            .setGroup("calcinators")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CALCINATOR_ENCHANTED")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CALCINATOR_FORBIDDEN.get())
            .patternLine("MMM")
            .patternLine("MCM")
            .patternLine("BIV")
            .key('M', ItemsPM.MARBLE_SMOKED.get())
            .key('C', ItemsPM.CALCINATOR_ENCHANTED.get())
            .key('B', ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .key('I', ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .key('V', ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .setGroup("calcinators")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CALCINATOR_FORBIDDEN")))
            .manaCost(new SourceList().add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CALCINATOR_HEAVENLY.get())
            .patternLine("MMM")
            .patternLine("MCM")
            .patternLine("EEE")
            .key('M', ItemsPM.MARBLE_HALLOWED.get())
            .key('C', ItemsPM.CALCINATOR_FORBIDDEN.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_HALLOWED.get())
            .setGroup("calcinators")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CALCINATOR_HEAVENLY")))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(Items.ICE)
            .addIngredient(Items.WATER_BUCKET)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CRYOTREATMENT")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "ice_from_cryotreatment"));
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(Items.OBSIDIAN)
            .addIngredient(Items.LAVA_BUCKET)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CRYOTREATMENT")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "obsidian_from_cryotreatment"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MAGITECH_PARTS_BASIC.get())
            .patternLine("SIS")
            .patternLine("IRI")
            .patternLine("SIS")
            .key('S', ItemsPM.MANA_SALTS.get())
            .key('I', Tags.Items.INGOTS_IRON)
            .key('R', Tags.Items.DUSTS_REDSTONE)
            .setGroup("magitech_parts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_MAGITECH")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .patternLine("SIS")
            .patternLine("IPI")
            .patternLine("SIS")
            .key('S', ItemsPM.MANA_SALTS.get())
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('P', ItemsPM.MAGITECH_PARTS_BASIC.get())
            .setGroup("magitech_parts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MAGITECH")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MAGITECH_PARTS_FORBIDDEN.get())
            .patternLine("SIS")
            .patternLine("IPI")
            .patternLine("SIS")
            .key('S', ItemsPM.MANA_SALTS.get())
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .setGroup("magitech_parts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MAGITECH")))
            .manaCost(new SourceList().add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MAGITECH_PARTS_HEAVENLY.get())
            .patternLine("SIS")
            .patternLine("IPI")
            .patternLine("SIS")
            .key('S', ItemsPM.MANA_SALTS.get())
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('P', ItemsPM.MAGITECH_PARTS_FORBIDDEN.get())
            .setGroup("magitech_parts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MAGITECH")))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HONEY_EXTRACTOR.get())
            .patternLine("HWB")
            .patternLine("WPW")
            .patternLine("BWH")
            .key('H', Items.HONEYCOMB)
            .key('W', ItemTags.PLANKS)
            .key('B', Items.GLASS_BOTTLE)
            .key('P', ItemsPM.MAGITECH_PARTS_BASIC.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HONEY_EXTRACTOR")))
            .manaCost(new SourceList().add(Source.SKY, 10))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARCANOMETER.get())
            .patternLine("EGE")
            .patternLine("GPG")
            .patternLine(" S ")
            .key('E', Tags.Items.ENDER_PEARLS)
            .key('G', Tags.Items.INGOTS_GOLD)
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARCANOMETER")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.FLYING_CARPET.get())
            .addIngredient(ItemTags.CARPETS)
            .addIngredient(Items.SADDLE)
            .addIngredient(Items.FEATHER)
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get(), 2)
            .addIngredient(ItemsPM.RUNE_PROJECT.get())
            .addIngredient(ItemsPM.RUNE_ITEM.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get(), 2)
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FLYING_CARPET")))
            .manaCost(new SourceList().add(Source.SKY, 100))
            .instability(6)
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ENTROPY_SINK.get())
            .patternLine("PSP")
            .patternLine("TRT")
            .patternLine("MMM")
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .key('S', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('T', ItemsPM.REFINED_SALT.get())
            .key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE)
            .key('M', ItemsPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ENTROPY_SINK")))
            .manaCost(new SourceList().add(Source.EARTH, 75).add(Source.SEA, 75).add(Source.SKY, 75).add(Source.SUN, 75).add(Source.MOON, 75))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.AUTO_CHARGER.get())
            .patternLine("EME")
            .patternLine("PCP")
            .patternLine("EME")
            .key('E', Tags.Items.GEMS_EMERALD)
            .key('M', ItemsPM.MARBLE_ENCHANTED.get())
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .key('C', ItemsPM.WAND_CHARGER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AUTO_CHARGER")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.DREAM_VISION_TALISMAN.get())
            .addIngredient(Items.AMETHYST_SHARD)
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(Tags.Items.INGOTS_COPPER)
            .addIngredient(Tags.Items.STRING)
            .addIngredient(ItemTags.SAND)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("DREAM_VISION_TALISMAN")))
            .manaCost(new SourceList().add(Source.MOON, 40))
            .instability(4)
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.IGNYX.get())
            .addIngredient(ItemTags.COALS)
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("IGNYX")))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.IGNYX_BLOCK.get())
            .requires(ItemsPM.IGNYX.get(), 9)
            .unlockedBy("has_ignyx", has(ItemsPM.IGNYX.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.IGNYX.get(), 9)
            .requires(ItemsPM.IGNYX_BLOCK.get())
            .unlockedBy("has_ignyx_block", has(ItemsPM.IGNYX_BLOCK.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "ignyx_from_storage_block"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.DOWSING_ROD.get())
            .patternLine("  S")
            .patternLine("SS ")
            .patternLine("DS ")
            .key('S', Tags.Items.RODS_WOODEN)
            .key('D', ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("DOWSING_ROD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ESSENCE_TRANSMUTER.get())
            .patternLine("CCC")
            .patternLine("CRC")
            .patternLine("MPM")
            .key('C', Tags.Items.INGOTS_COPPER)
            .key('R', ItemsPM.MANA_PRISM.get())
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ESSENCE_TRANSMUTER")))
            .manaCost(new SourceList().add(Source.MOON, 40))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.MYSTICAL_RELIC.get())
            .requires(ItemsPM.MYSTICAL_RELIC_FRAGMENT.get(), 9)
            .unlockedBy("has_fragment", has(ItemsPM.MYSTICAL_RELIC_FRAGMENT.get()))
            .save(consumer);
        
        SimpleCookingRecipeBuilder.cooking(Ingredient.of(ItemsPM.HEARTWOOD.get()), Items.CHARCOAL, 0.15F, 200, RecipeSerializer.SMELTING_RECIPE)
            .unlockedBy("has_heartwood", has(ItemsPM.HEARTWOOD.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "charcoal_from_smelting_heartwood"));

        SpecialRecipeBuilder.special(RecipeSerializersPM.WAND_ASSEMBLY_SPECIAL.get())
            .save(consumer, PrimalMagick.MODID + ":wand_assembly");
        SpecialRecipeBuilder.special(RecipeSerializersPM.WAND_INSCRIPTION_SPECIAL.get())
            .save(consumer, PrimalMagick.MODID + ":wand_inscription");
        SpecialRecipeBuilder.special(RecipeSerializersPM.SPELLCRAFTING_SPECIAL.get())
            .save(consumer, PrimalMagick.MODID + ":spellcrafting");
        SpecialRecipeBuilder.special(RecipeSerializersPM.FLYING_CARPET_DYE.get())
            .save(consumer, PrimalMagick.MODID + ":flying_carpet_dye");
        SpecialRecipeBuilder.special(RecipeSerializersPM.TIERED_SHIELD_DECORATION.get())
            .save(consumer, PrimalMagick.MODID + ":tiered_shield_decoration");
    }

    protected void registerMarbleRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_BRICK_SLAB.get(), 6)
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_BRICKS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_slab_from_marble_raw_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_BRICKS.get()), BlocksPM.MARBLE_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_slab_from_marble_bricks_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_BRICK_STAIRS.get(), 4)
            .pattern("M  ")
            .pattern("MM ")
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_BRICKS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_BRICK_STAIRS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_stairs_from_marble_raw_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_BRICKS.get()), BlocksPM.MARBLE_BRICK_STAIRS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_stairs_from_marble_bricks_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_BRICK_WALL.get(), 6)
            .pattern("MMM")
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_BRICKS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_BRICK_WALL.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_wall_from_marble_raw_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_BRICKS.get()), BlocksPM.MARBLE_BRICK_WALL.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_brick_wall_from_marble_bricks_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_BRICKS.get(), 4)
            .pattern("MM")
            .pattern("MM")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_BRICKS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_bricks_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_CHISELED.get())
            .pattern("M")
            .pattern("M")
            .define('M', BlocksPM.MARBLE_SLAB.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_CHISELED.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_chiseled_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_PILLAR.get(), 2)
            .pattern("M")
            .pattern("M")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_PILLAR.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_pillar_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_RUNED.get(), 5)
            .pattern(" M ")
            .pattern("MCM")
            .pattern(" M ")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .define('C', BlocksPM.MARBLE_CHISELED.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_RUNED.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_runed_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_SLAB.get(), 6)
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_SLAB.get(), 2)
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_slab_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_STAIRS.get(), 4)
            .pattern("M  ")
            .pattern("MM ")
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_STAIRS.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_stairs_from_marble_raw_stonecutting"));
        ShapedRecipeBuilder.shaped(BlocksPM.MARBLE_WALL.get(), 6)
            .pattern("MMM")
            .pattern("MMM")
            .define('M', BlocksPM.MARBLE_RAW.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_WALL.get())
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_wall_from_marble_raw_stonecutting"));
    }

    protected void registerEnchantedMarbleRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(BlocksPM.MARBLE_ENCHANTED.get(), 9)
            .addIngredient(BlocksPM.MARBLE_RAW.get(), 9)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .manaCost(new SourceList().add(Source.EARTH, 1).add(Source.SEA, 1).add(Source.SKY, 1).add(Source.SUN, 1).add(Source.MOON, 1))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_slab_from_marble_enchanted_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED_BRICKS.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_slab_from_marble_enchanted_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_stairs_from_marble_enchanted_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED_BRICKS.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_stairs_from_marble_enchanted_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_wall_from_marble_enchanted_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED_BRICKS.get()), BlocksPM.MARBLE_ENCHANTED_BRICK_WALL.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_brick_wall_from_marble_enchanted_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_BRICKS.get(), 4)
            .patternLine("MM")
            .patternLine("MM")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_BRICKS.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_bricks_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_CHISELED.get())
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_ENCHANTED_SLAB.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_CHISELED.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_chiseled_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_PILLAR.get(), 2)
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_PILLAR.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_pillar_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_RUNED.get(), 5)
            .patternLine(" M ")
            .patternLine("MCM")
            .patternLine(" M ")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .key('C', BlocksPM.MARBLE_ENCHANTED_CHISELED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_RUNED.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_runed_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_SLAB.get(), 2)
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_slab_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_STAIRS.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_stairs_from_marble_enchanted_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_ENCHANTED_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_ENCHANTED.get()), BlocksPM.MARBLE_ENCHANTED_WALL.get())
            .unlockedBy("has_marble_enchanted", has(BlocksPM.MARBLE_ENCHANTED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_enchanted_wall_from_marble_enchanted_stonecutting"));
    }
    
    protected void registerSmokedMarbleRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED.get(), 8)
            .patternLine("MMM")
            .patternLine("MCM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_RAW.get())
            .key('C', ItemTags.COALS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .manaCost(new SourceList().add(Source.MOON, 5))
            .build(consumer);
        SimpleCookingRecipeBuilder.cooking(Ingredient.of(BlocksPM.MARBLE_RAW.get()), BlocksPM.MARBLE_SMOKED.get(), 0, 100, RecipeSerializer.SMOKING_RECIPE)
            .unlockedBy("has_marble_raw", has(BlocksPM.MARBLE_RAW.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_from_smoking"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_slab_from_marble_smoked_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED_BRICKS.get()), BlocksPM.MARBLE_SMOKED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_slab_from_marble_smoked_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_stairs_from_marble_smoked_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED_BRICKS.get()), BlocksPM.MARBLE_SMOKED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_stairs_from_marble_smoked_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_BRICK_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_BRICK_WALL.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_wall_from_marble_smoked_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED_BRICKS.get()), BlocksPM.MARBLE_SMOKED_BRICK_WALL.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_brick_wall_from_marble_smoked_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_BRICKS.get(), 4)
            .patternLine("MM")
            .patternLine("MM")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_BRICKS.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_bricks_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_CHISELED.get())
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_SMOKED_SLAB.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_CHISELED.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_chiseled_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_PILLAR.get(), 2)
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_PILLAR.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_pillar_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_RUNED.get(), 5)
            .patternLine(" M ")
            .patternLine("MCM")
            .patternLine(" M ")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .key('C', BlocksPM.MARBLE_SMOKED_CHISELED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_RUNED.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_runed_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_SLAB.get(), 2)
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_slab_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_STAIRS.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_stairs_from_marble_smoked_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_SMOKED_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_SMOKED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_SMOKED.get()), BlocksPM.MARBLE_SMOKED_WALL.get())
            .unlockedBy("has_marble_smoked", has(BlocksPM.MARBLE_SMOKED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_smoked_wall_from_marble_smoked_stonecutting"));
    }
    
    protected void registerHallowedMarbleRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED.get(), 8)
            .patternLine("MMM")
            .patternLine("MDM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_RAW.get())
            .key('D', ItemsPM.ESSENCE_DUST_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .manaCost(new SourceList().add(Source.HALLOWED, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_slab_from_marble_hallowed_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED_BRICKS.get()), BlocksPM.MARBLE_HALLOWED_BRICK_SLAB.get(), 2)
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_slab_from_marble_hallowed_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_stairs_from_marble_hallowed_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED_BRICKS.get()), BlocksPM.MARBLE_HALLOWED_BRICK_STAIRS.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_stairs_from_marble_hallowed_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED_BRICKS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_wall_from_marble_hallowed_stonecutting"));
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED_BRICKS.get()), BlocksPM.MARBLE_HALLOWED_BRICK_WALL.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_brick_wall_from_marble_hallowed_bricks_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_BRICKS.get(), 4)
            .patternLine("MM")
            .patternLine("MM")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_BRICKS.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_bricks_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_CHISELED.get())
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_HALLOWED_SLAB.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_CHISELED.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_chiseled_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_PILLAR.get(), 2)
            .patternLine("M")
            .patternLine("M")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_PILLAR.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_pillar_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_RUNED.get(), 5)
            .patternLine(" M ")
            .patternLine("MCM")
            .patternLine(" M ")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .key('C', BlocksPM.MARBLE_HALLOWED_CHISELED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_RUNED.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_runed_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_SLAB.get(), 6)
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_SLAB.get(), 2)
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_slab_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_STAIRS.get(), 4)
            .patternLine("M  ")
            .patternLine("MM ")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_STAIRS.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_stairs_from_marble_hallowed_stonecutting"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(BlocksPM.MARBLE_HALLOWED_WALL.get(), 6)
            .patternLine("MMM")
            .patternLine("MMM")
            .key('M', BlocksPM.MARBLE_HALLOWED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_MANAWEAVING")))
            .build(consumer);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(BlocksPM.MARBLE_HALLOWED.get()), BlocksPM.MARBLE_HALLOWED_WALL.get())
            .unlockedBy("has_marble_hallowed", has(BlocksPM.MARBLE_HALLOWED.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "marble_hallowed_wall_from_marble_hallowed_stonecutting"));
    }

    protected void registerSunwoodRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.shaped(ItemsPM.SUNWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.SUNWOOD_LOG.get())
            .group("bark")
            .unlockedBy("has_sunwood_log", has(ItemsPM.SUNWOOD_LOG.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.STRIPPED_SUNWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.STRIPPED_SUNWOOD_LOG.get())
            .group("stripped_bark")
            .unlockedBy("has_sunwood_log", has(ItemsPM.SUNWOOD_LOG.get()))
            .unlockedBy("has_stripped_sunwood_log", has(ItemsPM.STRIPPED_SUNWOOD_LOG.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(BlocksPM.SUNWOOD_PLANKS.get(), 4)
            .requires(ItemTagsPM.SUNWOOD_LOGS)
            .group("planks")
            .unlockedBy("has_sunwood_log", has(ItemTagsPM.SUNWOOD_LOGS))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.SUNWOOD_SLAB.get(), 6)
            .pattern("###")
            .define('#', BlocksPM.SUNWOOD_PLANKS.get())
            .group("wooden_slab")
            .unlockedBy("has_planks", has(BlocksPM.SUNWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.SUNWOOD_STAIRS.get(), 4)
            .pattern("#  ")
            .pattern("## ")
            .pattern("###")
            .define('#', BlocksPM.SUNWOOD_PLANKS.get())
            .group("wooden_stairs")
            .unlockedBy("has_planks", has(BlocksPM.SUNWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.SUNWOOD_PILLAR.get(), 2)
            .pattern("#")
            .pattern("#")
            .define('#', ItemTagsPM.SUNWOOD_LOGS)
            .unlockedBy("has_sunwood_log", has(ItemTagsPM.SUNWOOD_LOGS))
            .save(consumer);
    }
    
    protected void registerMoonwoodRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.shaped(ItemsPM.MOONWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.MOONWOOD_LOG.get())
            .group("bark")
            .unlockedBy("has_moonwood_log", has(ItemsPM.MOONWOOD_LOG.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.STRIPPED_MOONWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.STRIPPED_MOONWOOD_LOG.get())
            .group("stripped_bark")
            .unlockedBy("has_moonwood_log", has(ItemsPM.MOONWOOD_LOG.get()))
            .unlockedBy("has_stripped_moonwood_log", has(ItemsPM.STRIPPED_MOONWOOD_LOG.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(BlocksPM.MOONWOOD_PLANKS.get(), 4)
            .requires(ItemTagsPM.MOONWOOD_LOGS)
            .group("planks")
            .unlockedBy("has_moonwood_log", has(ItemTagsPM.MOONWOOD_LOGS))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.MOONWOOD_SLAB.get(), 6)
            .pattern("###")
            .define('#', BlocksPM.MOONWOOD_PLANKS.get())
            .group("wooden_slab")
            .unlockedBy("has_planks", has(BlocksPM.MOONWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.MOONWOOD_STAIRS.get(), 4)
            .pattern("#  ")
            .pattern("## ")
            .pattern("###")
            .define('#', BlocksPM.MOONWOOD_PLANKS.get())
            .group("wooden_stairs")
            .unlockedBy("has_planks", has(BlocksPM.MOONWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.MOONWOOD_PILLAR.get(), 2)
            .pattern("#")
            .pattern("#")
            .define('#', ItemTagsPM.MOONWOOD_LOGS)
            .unlockedBy("has_moonwood_log", has(ItemTagsPM.MOONWOOD_LOGS))
            .save(consumer);
    }
    
    protected void registerHallowoodRecipes(Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.shapeless(ItemsPM.HALLOWOOD_SAPLING.get())
            .requires(ItemsPM.HALLOWED_ORB.get())
            .requires(ItemTags.SAPLINGS)
            .unlockedBy("has_hallowed_orb", has(ItemsPM.HALLOWED_ORB.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.HALLOWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.HALLOWOOD_LOG.get())
            .group("bark")
            .unlockedBy("has_hallowood_log", has(ItemsPM.HALLOWOOD_LOG.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.STRIPPED_HALLOWOOD_WOOD.get(), 3)
            .pattern("WW")
            .pattern("WW")
            .define('W', ItemsPM.STRIPPED_HALLOWOOD_LOG.get())
            .group("stripped_bark")
            .unlockedBy("has_hallowood_log", has(ItemsPM.HALLOWOOD_LOG.get()))
            .unlockedBy("has_stripped_hallowood_log", has(ItemsPM.STRIPPED_HALLOWOOD_LOG.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(BlocksPM.HALLOWOOD_PLANKS.get(), 4)
            .requires(ItemTagsPM.HALLOWOOD_LOGS)
            .group("planks")
            .unlockedBy("has_hallowood_log", has(ItemTagsPM.HALLOWOOD_LOGS))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.HALLOWOOD_SLAB.get(), 6)
            .pattern("###")
            .define('#', BlocksPM.HALLOWOOD_PLANKS.get())
            .group("wooden_slab")
            .unlockedBy("has_planks", has(BlocksPM.HALLOWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.HALLOWOOD_STAIRS.get(), 4)
            .pattern("#  ")
            .pattern("## ")
            .pattern("###")
            .define('#', BlocksPM.HALLOWOOD_PLANKS.get())
            .group("wooden_stairs")
            .unlockedBy("has_planks", has(BlocksPM.HALLOWOOD_PLANKS.get()))
            .save(consumer);
        ShapedRecipeBuilder.shaped(BlocksPM.HALLOWOOD_PILLAR.get(), 2)
            .pattern("#")
            .pattern("#")
            .define('#', ItemTagsPM.HALLOWOOD_LOGS)
            .unlockedBy("has_hallowood_log", has(ItemTagsPM.HALLOWOOD_LOGS))
            .save(consumer);
    }

    protected void registerEssenceUpgradeRecipes(Consumer<FinishedRecipe> consumer) {
        for (Source source : Source.SORTED_SOURCES) {
            for (EssenceType baseType : EssenceType.values()) {
                EssenceType upgradeType = baseType.getUpgrade();
                if (upgradeType != null) {
                    ItemStack baseStack = EssenceItem.getEssence(baseType, source);
                    ItemStack upgradeStack = EssenceItem.getEssence(upgradeType, source);
                    Item quartzItem = upgradeType.getUpgradeMedium();
                    if (!baseStack.isEmpty() && !upgradeStack.isEmpty() && quartzItem != null) {
                        CompoundResearchKey research;
                        SimpleResearchKey baseResearch = SimpleResearchKey.parse(upgradeType.getSerializedName().toUpperCase() + "_SYNTHESIS");
                        if (source.getDiscoverKey() == null) {
                            research = CompoundResearchKey.from(baseResearch);
                        } else {
                            research = CompoundResearchKey.from(true, baseResearch, source.getDiscoverKey());
                        }
                        String name = "essence_" + upgradeType.getSerializedName() + "_" + source.getTag() + "_from_" + baseType.getSerializedName();
                        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(upgradeStack.getItem())
                            .patternLine("###")
                            .patternLine("#Q#")
                            .patternLine("###")
                            .key('#', baseStack.getItem())
                            .key('Q', quartzItem)
                            .setGroup("essence_" + upgradeType.getSerializedName())
                            .research(research)
                            .build(consumer, new ResourceLocation(PrimalMagick.MODID, name));
                    }
                }
            }
        }
    }
    
    protected void registerEssenceDowngradeRecipes(Consumer<FinishedRecipe> consumer) {
        for (Source source : Source.SORTED_SOURCES) {
            for (EssenceType baseType : EssenceType.values()) {
                EssenceType downgradeType = baseType.getDowngrade();
                if (downgradeType != null) {
                    ItemStack baseStack = EssenceItem.getEssence(baseType, source);
                    ItemStack downgradeStack = EssenceItem.getEssence(downgradeType, source);
                    if (!baseStack.isEmpty() && !downgradeStack.isEmpty()) {
                        CompoundResearchKey research;
                        SimpleResearchKey baseResearch = SimpleResearchKey.parse(baseType.getSerializedName().toUpperCase() + "_DESYNTHESIS");
                        if (source.getDiscoverKey() == null) {
                            research = CompoundResearchKey.from(baseResearch);
                        } else {
                            research = CompoundResearchKey.from(true, baseResearch, source.getDiscoverKey());
                        }
                        String name = "essence_" + downgradeType.getSerializedName() + "_" + source.getTag() + "_from_" + baseType.getSerializedName();
                        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(downgradeStack.getItem(), 4)
                            .addIngredient(baseStack.getItem())
                            .setGroup("essence_" + downgradeType.getSerializedName())
                            .research(research)
                            .build(consumer, new ResourceLocation(PrimalMagick.MODID, name));
                    }
                }
            }
        }
    }

    protected void registerSaltRecipes(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(BlocksPM.ROCK_SALT_ORE.get()), ItemsPM.ROCK_SALT.get(), 0, 200)
            .unlockedBy("has_rock_salt_ore", has(BlocksPM.ROCK_SALT_ORE.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "rock_salt_from_smelting"));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemsPM.ROCK_SALT.get()), ItemsPM.REFINED_SALT.get(), 0.2F, 200)
            .unlockedBy("has_rock_salt", has(ItemsPM.ROCK_SALT.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALT_BLOCK.get())
            .requires(ItemsPM.REFINED_SALT.get(), 9)
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.REFINED_SALT.get(), 9)
            .requires(ItemsPM.SALT_BLOCK.get())
            .unlockedBy("has_salt_block", has(ItemsPM.SALT_BLOCK.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "refined_salt_from_salt_block"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_BAKED_POTATO.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.BAKED_POTATO)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_baked_potato", has(Items.BAKED_POTATO))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_BEEF.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_BEEF)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_beef", has(Items.COOKED_BEEF))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_CHICKEN.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_CHICKEN)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_chicken", has(Items.COOKED_CHICKEN))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_COD.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_COD)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_cod", has(Items.COOKED_COD))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_MUTTON.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_MUTTON)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_mutton", has(Items.COOKED_MUTTON))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_PORKCHOP.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_PORKCHOP)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_porkchop", has(Items.COOKED_PORKCHOP))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_RABBIT.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_RABBIT)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_rabbit", has(Items.COOKED_RABBIT))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_COOKED_SALMON.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.COOKED_SALMON)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_cooked_salmon", has(Items.COOKED_SALMON))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_BEETROOT_SOUP.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.BEETROOT_SOUP)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_beetroot_soup", has(Items.BEETROOT_SOUP))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_MUSHROOM_STEW.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.MUSHROOM_STEW)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_mushroom_stew", has(Items.MUSHROOM_STEW))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.SALTED_RABBIT_STEW.get())
            .requires(ItemsPM.REFINED_SALT.get())
            .requires(Items.RABBIT_STEW)
            .group("salted_food")
            .unlockedBy("has_salt", has(ItemsPM.REFINED_SALT.get()))
            .unlockedBy("has_rabbit_stew", has(Items.RABBIT_STEW))
            .save(consumer);
    }
    
    protected void registerSkyglassRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SKYGLASS.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', Items.GLASS)
            .key('D', ItemsPM.ESSENCE_DUST_SKY.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_BLACK.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_BLACK)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_BLUE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_BLUE)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_BROWN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_BROWN)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_CYAN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_CYAN)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_GRAY.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_GRAY)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_GREEN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_GREEN)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_LIGHT_BLUE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_LIGHT_BLUE)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_LIGHT_GRAY.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_LIGHT_GRAY)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_LIME.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_LIME)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_MAGENTA.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_MAGENTA)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_ORANGE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_ORANGE)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PINK.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_PINK)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PURPLE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_PURPLE)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_RED.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_RED)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_WHITE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_WHITE)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_YELLOW.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS)
            .key('D', Tags.Items.DYES_YELLOW)
            .setGroup("stained_skyglass")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
    }
    
    protected void registerSkyglassPaneRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SKYGLASS_PANE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.SKYGLASS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BLACK.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_BLACK.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_black_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BLACK.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_BLACK)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_black_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BLUE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_BLUE.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_blue_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BLUE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_BLUE)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_blue_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BROWN.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_BROWN.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_brown_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_BROWN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_BROWN)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_brown_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_CYAN.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_CYAN.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_cyan_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_CYAN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_CYAN)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_cyan_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_GRAY.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_GRAY.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_gray_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_GRAY.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_GRAY)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_gray_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_GREEN.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_GREEN.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_green_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_GREEN.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_GREEN)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_green_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_LIGHT_BLUE.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_light_blue_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_BLUE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_LIGHT_BLUE)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_light_blue_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_LIGHT_GRAY.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_light_gray_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIGHT_GRAY.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_LIGHT_GRAY)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_light_gray_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIME.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_LIME.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_lime_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_LIME.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_LIME)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_lime_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_MAGENTA.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_MAGENTA.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_magenta_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_MAGENTA.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_MAGENTA)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_magenta_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_ORANGE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_ORANGE.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_orange_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_ORANGE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_ORANGE)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_orange_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_PINK.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_PINK.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_pink_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_PINK.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_PINK)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_pink_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_PURPLE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_PURPLE.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_purple_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_PURPLE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_PURPLE)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_purple_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_RED.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_RED.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_red_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_RED.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_RED)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_red_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_WHITE.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_WHITE.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_white_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_WHITE.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_WHITE)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_white_from_panes"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_YELLOW.get(), 16)
            .patternLine("GGG")
            .patternLine("GGG")
            .key('G', ItemsPM.STAINED_SKYGLASS_YELLOW.get())
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_yellow_from_blocks"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.STAINED_SKYGLASS_PANE_YELLOW.get(), 8)
            .patternLine("GGG")
            .patternLine("GDG")
            .patternLine("GGG")
            .key('G', ItemTagsPM.SKYGLASS_PANES)
            .key('D', Tags.Items.DYES_YELLOW)
            .setGroup("stained_skyglass_pane")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SKYGLASS")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "stained_skyglass_pane_yellow_from_panes"));
    }

    protected void registerEarthshatterHammerRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.EARTHSHATTER_HAMMER.get())
            .patternLine("III")
            .patternLine("IEI")
            .patternLine(" S ")
            .key('I', Tags.Items.INGOTS_IRON)
            .key('E', ItemsPM.ESSENCE_SHARD_EARTH.get())
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EARTHSHATTER_HAMMER")))
            .manaCost(new SourceList().add(Source.EARTH, 20))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.IRON_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.ORES_IRON)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_grit_from_ore"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.IRON_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.RAW_MATERIALS_IRON)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_grit_from_raw_metal"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.GOLD_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.ORES_GOLD)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_grit_from_ore"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.GOLD_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.RAW_MATERIALS_GOLD)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_grit_from_raw_metal"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.COPPER_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.ORES_COPPER)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_grit_from_ore"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.COPPER_GRIT.get(), 2)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.RAW_MATERIALS_COPPER)
            .group("earthshatter_hammer_grit")
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_grit_from_raw_metal"));
        ShapelessRecipeBuilder.shapeless(Items.COBBLESTONE)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.STONE)
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "cobblestone_from_earthshatter_hammer"));
        ShapelessRecipeBuilder.shapeless(Items.GRAVEL)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.COBBLESTONE)
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "gravel_from_earthshatter_hammer"));
        ShapelessRecipeBuilder.shapeless(Items.SAND)
            .requires(ItemsPM.EARTHSHATTER_HAMMER.get())
            .requires(Tags.Items.GRAVEL)
            .unlockedBy("has_hammer", has(ItemsPM.EARTHSHATTER_HAMMER.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "sand_from_earthshatter_hammer"));
    }

    protected void registerMineralRecipes(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemsPM.IRON_GRIT.get()), Items.IRON_INGOT, 0.7F, 200)
            .unlockedBy("has_grit", has(ItemsPM.IRON_GRIT.get()))
            .group("iron_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_ingot_from_grit_smelting"));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(ItemsPM.IRON_GRIT.get()), Items.IRON_INGOT, 0.7F, 100)
            .unlockedBy("has_grit", has(ItemsPM.IRON_GRIT.get()))
            .group("iron_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_ingot_from_grit_blasting"));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemsPM.GOLD_GRIT.get()), Items.GOLD_INGOT, 0.7F, 200)
            .unlockedBy("has_grit", has(ItemsPM.GOLD_GRIT.get()))
            .group("gold_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_ingot_from_grit_smelting"));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(ItemsPM.GOLD_GRIT.get()), Items.GOLD_INGOT, 0.7F, 100)
            .unlockedBy("has_grit", has(ItemsPM.GOLD_GRIT.get()))
            .group("gold_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_ingot_from_grit_blasting"));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemsPM.COPPER_GRIT.get()), Items.COPPER_INGOT, 0.7F, 200)
            .unlockedBy("has_grit", has(ItemsPM.COPPER_GRIT.get()))
            .group("copper_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_ingot_from_grit_smelting"));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(ItemsPM.COPPER_GRIT.get()), Items.COPPER_INGOT, 0.7F, 100)
            .unlockedBy("has_grit", has(ItemsPM.COPPER_GRIT.get()))
            .group("copper_ingot")
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_ingot_from_grit_blasting"));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(BlocksPM.QUARTZ_ORE.get()), Items.QUARTZ, 0.2F, 200)
            .unlockedBy("has_quartz_ore", has(BlocksPM.QUARTZ_ORE.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "quartz_from_smelting"));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(BlocksPM.QUARTZ_ORE.get()), Items.QUARTZ, 0.2F, 200)
            .unlockedBy("has_quartz_ore", has(BlocksPM.QUARTZ_ORE.get()))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "quartz_from_blasting"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.QUARTZ_NUGGET.get(), 9)
            .requires(Items.QUARTZ)
            .unlockedBy("has_quartz", has(Items.QUARTZ))
            .save(consumer);
        ShapedRecipeBuilder.shaped(Items.QUARTZ)
            .pattern("NNN")
            .pattern("NNN")
            .pattern("NNN")
            .define('N', ItemTagsForgeExt.NUGGETS_QUARTZ)
            .unlockedBy("has_nugget", has(ItemTagsForgeExt.NUGGETS_QUARTZ))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "quartz_from_nuggets"));
    }
    
    protected void registerPrimaliteRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.PRIMALITE_INGOT.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("primalite_ingot")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.PRIMALITE_NUGGET.get(), 9)
            .requires(ItemTagsPM.INGOTS_PRIMALITE)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_PRIMALITE))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.PRIMALITE_INGOT.get())
            .pattern("NNN")
            .pattern("NNN")
            .pattern("NNN")
            .define('N', ItemTagsPM.NUGGETS_PRIMALITE)
            .group("primalite_ingot")
            .unlockedBy("has_nugget", has(ItemTagsPM.NUGGETS_PRIMALITE))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "primalite_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.PRIMALITE_INGOT.get(), 9)
            .requires(ItemTagsPM.STORAGE_BLOCKS_PRIMALITE)
            .group("primalite_ingot")
            .unlockedBy("has_block", has(ItemTagsPM.STORAGE_BLOCKS_PRIMALITE))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "primalite_ingots_from_block"));
        ShapedRecipeBuilder.shaped(ItemsPM.PRIMALITE_BLOCK.get())
            .pattern("III")
            .pattern("III")
            .pattern("III")
            .define('I', ItemTagsPM.INGOTS_PRIMALITE)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_PRIMALITE))
            .save(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_SWORD.get())
            .patternLine("I")
            .patternLine("I")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_TRIDENT.get())
            .patternLine(" II")
            .patternLine(" SI")
            .patternLine("S  ")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_BOW.get())
            .patternLine(" IS")
            .patternLine("I S")
            .patternLine(" IS")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_SHOVEL.get())
            .patternLine("I")
            .patternLine("S")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_PICKAXE.get())
            .patternLine("III")
            .patternLine(" S ")
            .patternLine(" S ")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_AXE.get())
            .patternLine("II")
            .patternLine("IS")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_HOE.get())
            .patternLine("II")
            .patternLine(" S")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_FISHING_ROD.get())
            .patternLine("  I")
            .patternLine(" IS")
            .patternLine("I S")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_HEAD.get())
            .patternLine("III")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_CHEST.get())
            .patternLine("I I")
            .patternLine("III")
            .patternLine("III")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_LEGS.get())
            .patternLine("III")
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_FEET.get())
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_SHIELD.get())
            .patternLine("PIP")
            .patternLine("PPP")
            .patternLine(" P ")
            .key('P', ItemTags.PLANKS)
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE")))
            .build(consumer);
    }
    
    protected void registerHexiumRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.HEXIUM_INGOT.get())
            .addIngredient(ItemTagsPM.INGOTS_PRIMALITE)
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .setGroup("hexium_ingot")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.HEXIUM_NUGGET.get(), 9)
            .requires(ItemTagsPM.INGOTS_HEXIUM)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_HEXIUM))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.HEXIUM_INGOT.get())
            .pattern("NNN")
            .pattern("NNN")
            .pattern("NNN")
            .define('N', ItemTagsPM.NUGGETS_HEXIUM)
            .group("hexium_ingot")
            .unlockedBy("has_nugget", has(ItemTagsPM.NUGGETS_HEXIUM))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "hexium_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.HEXIUM_INGOT.get(), 9)
            .requires(ItemTagsPM.STORAGE_BLOCKS_HEXIUM)
            .group("hexium_ingot")
            .unlockedBy("has_block", has(ItemTagsPM.STORAGE_BLOCKS_HEXIUM))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "hexium_ingots_from_block"));
        ShapedRecipeBuilder.shaped(ItemsPM.HEXIUM_BLOCK.get())
            .pattern("III")
            .pattern("III")
            .pattern("III")
            .define('I', ItemTagsPM.INGOTS_HEXIUM)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_HEXIUM))
            .save(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_SWORD.get())
            .patternLine("I")
            .patternLine("I")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_TRIDENT.get())
            .patternLine(" II")
            .patternLine(" SI")
            .patternLine("S  ")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_BOW.get())
            .patternLine(" IS")
            .patternLine("I S")
            .patternLine(" IS")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_SHOVEL.get())
            .patternLine("I")
            .patternLine("S")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_PICKAXE.get())
            .patternLine("III")
            .patternLine(" S ")
            .patternLine(" S ")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_AXE.get())
            .patternLine("II")
            .patternLine("IS")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_HOE.get())
            .patternLine("II")
            .patternLine(" S")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_FISHING_ROD.get())
            .patternLine("  I")
            .patternLine(" IS")
            .patternLine("I S")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_HEAD.get())
            .patternLine("III")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_CHEST.get())
            .patternLine("I I")
            .patternLine("III")
            .patternLine("III")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_LEGS.get())
            .patternLine("III")
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_FEET.get())
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_SHIELD.get())
            .patternLine("PIP")
            .patternLine("PPP")
            .patternLine(" P ")
            .key('P', ItemTags.PLANKS)
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM")))
            .build(consumer);
    }
    
    protected void registerHallowsteelRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.HALLOWSTEEL_INGOT.get())
            .addIngredient(ItemTagsPM.INGOTS_HEXIUM)
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())
            .setGroup("hallowsteel_ingot")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.HALLOWSTEEL_NUGGET.get(), 9)
            .requires(ItemTagsPM.INGOTS_HALLOWSTEEL)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_HALLOWSTEEL))
            .save(consumer);
        ShapedRecipeBuilder.shaped(ItemsPM.HALLOWSTEEL_INGOT.get())
            .pattern("NNN")
            .pattern("NNN")
            .pattern("NNN")
            .define('N', ItemTagsPM.NUGGETS_HALLOWSTEEL)
            .group("hallowsteel_ingot")
            .unlockedBy("has_nugget", has(ItemTagsPM.NUGGETS_HALLOWSTEEL))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "hallowsteel_ingot_from_nuggets"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.HALLOWSTEEL_INGOT.get(), 9)
            .requires(ItemTagsPM.STORAGE_BLOCKS_HALLOWSTEEL)
            .group("hallowsteel_ingot")
            .unlockedBy("has_block", has(ItemTagsPM.STORAGE_BLOCKS_HALLOWSTEEL))
            .save(consumer, new ResourceLocation(PrimalMagick.MODID, "hallowsteel_ingots_from_block"));
        ShapedRecipeBuilder.shaped(ItemsPM.HALLOWSTEEL_BLOCK.get())
            .pattern("III")
            .pattern("III")
            .pattern("III")
            .define('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .unlockedBy("has_ingot", has(ItemTagsPM.INGOTS_HALLOWSTEEL))
            .save(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_SWORD.get())
            .patternLine("I")
            .patternLine("I")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_TRIDENT.get())
            .patternLine(" II")
            .patternLine(" SI")
            .patternLine("S  ")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_BOW.get())
            .patternLine(" IS")
            .patternLine("I S")
            .patternLine(" IS")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_SHOVEL.get())
            .patternLine("I")
            .patternLine("S")
            .patternLine("S")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_PICKAXE.get())
            .patternLine("III")
            .patternLine(" S ")
            .patternLine(" S ")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_AXE.get())
            .patternLine("II")
            .patternLine("IS")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_HOE.get())
            .patternLine("II")
            .patternLine(" S")
            .patternLine(" S")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.RODS_WOODEN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_FISHING_ROD.get())
            .patternLine("  I")
            .patternLine(" IS")
            .patternLine("I S")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('S', Tags.Items.STRING)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_HEAD.get())
            .patternLine("III")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_CHEST.get())
            .patternLine("I I")
            .patternLine("III")
            .patternLine("III")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_LEGS.get())
            .patternLine("III")
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_FEET.get())
            .patternLine("I I")
            .patternLine("I I")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_SHIELD.get())
            .patternLine("PIP")
            .patternLine("PPP")
            .patternLine(" P ")
            .key('P', ItemTags.PLANKS)
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL")))
            .build(consumer);
    }
    
    protected void registerWandComponentRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEARTWOOD_WAND_CORE_ITEM.get())
            .patternLine(" H")
            .patternLine("H ")
            .key('H', ItemsPM.HEARTWOOD.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_HEARTWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.OBSIDIAN_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_EARTH.get())
            .key('#', Tags.Items.OBSIDIAN)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_OBSIDIAN")))
            .manaCost(new SourceList().add(Source.EARTH, 15).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CORAL_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_SEA.get())
            .key('#', ItemTagsPM.CORAL_BLOCKS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_CORAL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 15).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BAMBOO_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_SKY.get())
            .key('#', Items.BAMBOO)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_BAMBOO")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 15).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SUNWOOD_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_SUN.get())
            .key('#', ItemsPM.SUNWOOD_LOG.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_SUNWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 15).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MOONWOOD_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_MOON.get())
            .key('#', ItemsPM.MOONWOOD_LOG.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_MOONWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BONE_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_BLOOD.get())
            .key('#', Items.BONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_BONE")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.BLOOD, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BLAZE_ROD_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .key('#', Tags.Items.RODS_BLAZE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_BLAZE_ROD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.INFERNAL, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PURPUR_WAND_CORE_ITEM.get())
            .patternLine("D#")
            .patternLine("#D")
            .key('D', ItemsPM.ESSENCE_DUST_VOID.get())
            .key('#', Items.PURPUR_BLOCK)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_PURPUR")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.VOID, 15))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.OBSIDIAN_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.CORAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.BAMBOO_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.SUNWOOD_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.MOONWOOD_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .instability(3)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 15).add(Source.SEA, 15).add(Source.SKY, 15).add(Source.SUN, 15).add(Source.MOON, 15))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.DARK_PRIMAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.PRIMAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.BONE_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.BLAZE_ROD_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.PURPUR_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .instability(5)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_DARK_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 50).add(Source.SEA, 50).add(Source.SKY, 50).add(Source.SUN, 50).add(Source.MOON, 50).add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PURE_PRIMAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.DARK_PRIMAL_WAND_CORE_ITEM.get())
            .addIngredient(ItemsPM.HALLOWOOD_LOG.get(), 2)
            .addIngredient(Tags.Items.NETHER_STARS)
            .addIngredient(ItemsPM.MANA_SALTS.get(), 2)
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .instability(7)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_PURE_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 100).add(Source.SEA, 100).add(Source.SKY, 100).add(Source.SUN, 100).add(Source.MOON, 100).add(Source.BLOOD, 100).add(Source.INFERNAL, 100).add(Source.VOID, 100).add(Source.HALLOWED, 100))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.IRON_WAND_CAP_ITEM.get())
            .patternLine("NNN")
            .patternLine("N N")
            .key('N', Tags.Items.NUGGETS_IRON)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CAP_IRON")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.GOLD_WAND_CAP_ITEM.get())
            .patternLine("NNN")
            .patternLine("N N")
            .key('N', Tags.Items.NUGGETS_GOLD)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CAP_GOLD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_WAND_CAP_ITEM.get())
            .patternLine("NNN")
            .patternLine("N N")
            .key('N', ItemTagsPM.NUGGETS_PRIMALITE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CAP_PRIMALITE")))
            .manaCost(new SourceList().add(Source.EARTH, 15).add(Source.SEA, 15).add(Source.SKY, 15).add(Source.SUN, 15).add(Source.MOON, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_WAND_CAP_ITEM.get())
            .patternLine("NNN")
            .patternLine("N N")
            .key('N', ItemTagsPM.NUGGETS_HEXIUM)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CAP_HEXIUM")))
            .manaCost(new SourceList().add(Source.EARTH, 50).add(Source.SEA, 50).add(Source.SKY, 50).add(Source.SUN, 50).add(Source.MOON, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_WAND_CAP_ITEM.get())
            .patternLine("NNN")
            .patternLine("N N")
            .key('N', ItemTagsPM.NUGGETS_HALLOWSTEEL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CAP_HALLOWSTEEL")))
            .manaCost(new SourceList().add(Source.EARTH, 150).add(Source.SEA, 150).add(Source.SKY, 150).add(Source.SUN, 150).add(Source.MOON, 150))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.APPRENTICE_WAND_GEM_ITEM.get())
            .addIngredient(Tags.Items.GEMS_DIAMOND)
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_GEM_APPRENTICE")))
            .manaCost(new SourceList().add(Source.EARTH, 10).add(Source.SEA, 10).add(Source.SKY, 10).add(Source.SUN, 10).add(Source.MOON, 10))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.ADEPT_WAND_GEM_ITEM.get())
            .addIngredient(Tags.Items.GEMS_DIAMOND)
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_SHARDS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_GEM_ADEPT")))
            .manaCost(new SourceList().add(Source.EARTH, 30).add(Source.SEA, 30).add(Source.SKY, 30).add(Source.SUN, 30).add(Source.MOON, 30))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.WIZARD_WAND_GEM_ITEM.get())
            .addIngredient(Tags.Items.GEMS_DIAMOND)
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_CRYSTALS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_GEM_WIZARD")))
            .manaCost(new SourceList().add(Source.EARTH, 100).add(Source.SEA, 100).add(Source.SKY, 100).add(Source.SUN, 100).add(Source.MOON, 100))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.ARCHMAGE_WAND_GEM_ITEM.get())
            .addIngredient(Tags.Items.GEMS_DIAMOND)
            .addIngredient(ItemTagsPM.ESSENCES_TERRESTRIAL_CLUSTERS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_GEM_ARCHMAGE")))
            .manaCost(new SourceList().add(Source.EARTH, 300).add(Source.SEA, 300).add(Source.SKY, 300).add(Source.SUN, 300).add(Source.MOON, 300))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEARTWOOD_STAFF_CORE_ITEM.get())
            .patternLine("  H")
            .patternLine(" H ")
            .patternLine("H  ")
            .key('H', ItemsPM.HEARTWOOD.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_HEARTWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.OBSIDIAN_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_EARTH.get())
            .key('#', Tags.Items.OBSIDIAN)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_OBSIDIAN")))
            .manaCost(new SourceList().add(Source.EARTH, 15).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CORAL_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_SEA.get())
            .key('#', ItemTagsPM.CORAL_BLOCKS)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_CORAL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 15).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BAMBOO_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_SKY.get())
            .key('#', Items.BAMBOO)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_BAMBOO")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 15).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SUNWOOD_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_SUN.get())
            .key('#', ItemsPM.SUNWOOD_LOG.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_SUNWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 15).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MOONWOOD_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_MOON.get())
            .key('#', ItemsPM.MOONWOOD_LOG.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_MOONWOOD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BONE_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .key('#', Items.BONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_BONE")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.BLOOD, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.BLAZE_ROD_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .key('#', Tags.Items.RODS_BLAZE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_BLAZE_ROD")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.INFERNAL, 15))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PURPUR_STAFF_CORE_ITEM.get())
            .patternLine(" D#")
            .patternLine("D#D")
            .patternLine("#D ")
            .key('D', ItemsPM.ESSENCE_SHARD_VOID.get())
            .key('#', Items.PURPUR_BLOCK)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_PURPUR")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5).add(Source.VOID, 15))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.OBSIDIAN_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.CORAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.BAMBOO_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.SUNWOOD_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.MOONWOOD_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .instability(4)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 15).add(Source.SEA, 15).add(Source.SKY, 15).add(Source.SUN, 15).add(Source.MOON, 15))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.DARK_PRIMAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.PRIMAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.BONE_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.BLAZE_ROD_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.PURPUR_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .instability(6)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("STAVES"), SimpleResearchKey.parse("WAND_CORE_DARK_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 50).add(Source.SEA, 50).add(Source.SKY, 50).add(Source.SUN, 50).add(Source.MOON, 50).add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PURE_PRIMAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.DARK_PRIMAL_STAFF_CORE_ITEM.get())
            .addIngredient(ItemsPM.HALLOWOOD_LOG.get(), 2)
            .addIngredient(Tags.Items.NETHER_STARS)
            .addIngredient(ItemsPM.MANA_SALTS.get(), 2)
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .instability(8)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("WAND_CORE_PURE_PRIMAL")))
            .manaCost(new SourceList().add(Source.EARTH, 100).add(Source.SEA, 100).add(Source.SKY, 100).add(Source.SUN, 100).add(Source.MOON, 100).add(Source.BLOOD, 100).add(Source.INFERNAL, 100).add(Source.VOID, 100).add(Source.HALLOWED, 100))
            .build(consumer);
    }
    
    protected void registerRitualCandleRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.TALLOW.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RITUAL_CANDLES")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RITUAL_CANDLE_WHITE.get())
            .patternLine("S")
            .patternLine("T")
            .patternLine("T")
            .key('S', Tags.Items.STRING)
            .key('T', ItemsPM.TALLOW.get())
            .setGroup("ritual_candles")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RITUAL_CANDLES")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "ritual_candle_white_from_tallow"));
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RITUAL_CANDLE_WHITE.get())
            .patternLine("S")
            .patternLine("W")
            .patternLine("W")
            .key('S', Tags.Items.STRING)
            .key('W', ItemsPM.BEESWAX.get())
            .setGroup("ritual_candles")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RITUAL_CANDLES")))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "ritual_candle_white_from_beeswax"));
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_BLACK.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_BLACK)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_BLUE.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_BLUE)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_BROWN.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_BROWN)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_CYAN.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_CYAN)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_GRAY.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_GRAY)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_GREEN.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_GREEN)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_LIGHT_BLUE.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_LIGHT_BLUE)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_LIGHT_GRAY.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_LIGHT_GRAY)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_LIME.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_LIME)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_MAGENTA.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_MAGENTA)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_ORANGE.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_ORANGE)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_PINK.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_PINK)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_PURPLE.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_PURPLE)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_RED.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_RED)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_WHITE.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_WHITE)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
        ShapelessRecipeBuilder.shapeless(ItemsPM.RITUAL_CANDLE_YELLOW.get())
            .requires(ItemTagsPM.RITUAL_CANDLES)
            .requires(Tags.Items.DYES_YELLOW)
            .group("ritual_candles")
            .unlockedBy("has_candle", has(ItemTagsPM.RITUAL_CANDLES))
            .save(consumer);
    }
    
    protected void registerRuneRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNECARVING_TABLE.get())
            .addIngredient(ItemsPM.WOOD_TABLE.get())
            .addIngredient(Items.STONE_SLAB)
            .addIngredient(Items.DIAMOND_SWORD)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_RUNEWORKING")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_UNATTUNED.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_RUNEWORKING")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RUNESCRIBING_ALTAR_BASIC.get())
            .patternLine(" R ")
            .patternLine("DMD")
            .patternLine("MMM")
            .key('R', ItemsPM.RUNE_UNATTUNED.get())
            .key('D', Tags.Items.GEMS_DIAMOND)
            .key('M', ItemsPM.MARBLE_RAW.get())
            .setGroup("runescribing_altar")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("BASIC_RUNEWORKING")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RUNESCRIBING_ALTAR_ENCHANTED.get())
            .patternLine(" R ")
            .patternLine("DAD")
            .patternLine("MMM")
            .key('R', ItemsPM.RUNE_UNATTUNED.get())
            .key('D', Tags.Items.GEMS_DIAMOND)
            .key('A', ItemsPM.RUNESCRIBING_ALTAR_BASIC.get())
            .key('M', ItemsPM.MARBLE_ENCHANTED.get())
            .setGroup("runescribing_altar")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("EXPERT_RUNEWORKING")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RUNESCRIBING_ALTAR_FORBIDDEN.get())
            .patternLine(" R ")
            .patternLine("DAD")
            .patternLine("MMM")
            .key('R', ItemsPM.RUNE_UNATTUNED.get())
            .key('D', Tags.Items.GEMS_DIAMOND)
            .key('A', ItemsPM.RUNESCRIBING_ALTAR_ENCHANTED.get())
            .key('M', ItemsPM.MARBLE_SMOKED.get())
            .setGroup("runescribing_altar")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MASTER_RUNEWORKING")))
            .manaCost(new SourceList().add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.RUNESCRIBING_ALTAR_HEAVENLY.get())
            .patternLine(" R ")
            .patternLine("DAD")
            .patternLine("MMM")
            .key('R', ItemsPM.RUNE_UNATTUNED.get())
            .key('D', Tags.Items.GEMS_DIAMOND)
            .key('A', ItemsPM.RUNESCRIBING_ALTAR_FORBIDDEN.get())
            .key('M', ItemsPM.MARBLE_HALLOWED.get())
            .setGroup("runescribing_altar")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_RUNEWORKING")))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_EARTH.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_EARTH")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_SEA.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_SEA")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_SKY.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_SKY")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_SUN.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_SUN")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_MOON.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_MOON")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_PROJECT.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_PROJECT")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_PROTECT.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_PROTECT")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_ITEM.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_ITEM")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_SELF.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_SELF")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_BLOOD.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_BLOOD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_INFERNAL.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_INFERNAL")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_VOID.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_VOID.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_VOID")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_ABSORB.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_ABSORB")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_DISPEL.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_DISPEL")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_SUMMON.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_SUMMON")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_AREA.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_AREA")))
            .build(consumer);
        RunecarvingRecipeBuilder.runecarvingRecipe(ItemsPM.RUNE_CREATURE.get())
            .firstIngredient(Items.STONE_SLAB)
            .secondIngredient(Tags.Items.GEMS_LAPIS)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_CREATURE")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_HALLOWED.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_HALLOWED.get())
            .setGroup("source_runes")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_HALLOWED")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.RUNE_POWER.get())
            .addIngredient(ItemsPM.RUNE_UNATTUNED.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("RUNE_POWER")))
            .build(consumer);
    }

    protected void registerGolemControllerRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.PRIMALITE_GOLEM_CONTROLLER.get())
            .patternLine("PIP")
            .patternLine("IRI")
            .patternLine("PIP")
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMALITE_GOLEM")))
            .manaCost(new SourceList().add(Source.EARTH, 20).add(Source.SEA, 20).add(Source.SKY, 20).add(Source.SUN, 20).add(Source.MOON, 20))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXIUM_GOLEM_CONTROLLER.get())
            .patternLine("PIP")
            .patternLine("IRI")
            .patternLine("PIP")
            .key('P', ItemsPM.MAGITECH_PARTS_FORBIDDEN.get())
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXIUM_GOLEM")))
            .manaCost(new SourceList().add(Source.BLOOD, 50).add(Source.INFERNAL, 50).add(Source.VOID, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HALLOWSTEEL_GOLEM_CONTROLLER.get())
            .patternLine("PIP")
            .patternLine("IRI")
            .patternLine("PIP")
            .key('P', ItemsPM.MAGITECH_PARTS_HEAVENLY.get())
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('R', Tags.Items.STORAGE_BLOCKS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HALLOWSTEEL_GOLEM")))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .build(consumer);
    }
    
    protected void registerPixieRecipes(Consumer<FinishedRecipe> consumer) {
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_EARTH_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PIXIES")))
            .manaCost(new SourceList().add(Source.EARTH, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SEA_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PIXIES")))
            .manaCost(new SourceList().add(Source.SEA, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SKY_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PIXIES")))
            .manaCost(new SourceList().add(Source.SKY, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SUN_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PIXIES")))
            .manaCost(new SourceList().add(Source.SUN, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_MOON_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PIXIES")))
            .manaCost(new SourceList().add(Source.MOON, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_BLOOD_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("PIXIES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_INFERNAL_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("PIXIES"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_VOID_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("PIXIES"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_HALLOWED_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_HALLOWED.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("PIXIES"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_EARTH_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GRAND_PIXIES")))
            .manaCost(new SourceList().add(Source.EARTH, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_SEA_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GRAND_PIXIES")))
            .manaCost(new SourceList().add(Source.SEA, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_SKY_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GRAND_PIXIES")))
            .manaCost(new SourceList().add(Source.SKY, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_SUN_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GRAND_PIXIES")))
            .manaCost(new SourceList().add(Source.SUN, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_MOON_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GRAND_PIXIES")))
            .manaCost(new SourceList().add(Source.MOON, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_BLOOD_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GRAND_PIXIES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_INFERNAL_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GRAND_PIXIES"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_VOID_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GRAND_PIXIES"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GRAND_HALLOWED_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())
            .addIngredient(Tags.Items.INGOTS_IRON)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GRAND_PIXIES"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .instability(5)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_EARTH_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_EARTH.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MAJESTIC_PIXIES")))
            .manaCost(new SourceList().add(Source.EARTH, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_SEA_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SEA.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MAJESTIC_PIXIES")))
            .manaCost(new SourceList().add(Source.SEA, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_SKY_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SKY.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MAJESTIC_PIXIES")))
            .manaCost(new SourceList().add(Source.SKY, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_SUN_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SUN.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MAJESTIC_PIXIES")))
            .manaCost(new SourceList().add(Source.SUN, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_MOON_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_MOON.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MAJESTIC_PIXIES")))
            .manaCost(new SourceList().add(Source.MOON, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_BLOOD_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_BLOOD.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MAJESTIC_PIXIES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_INFERNAL_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MAJESTIC_PIXIES"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_VOID_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_VOID.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MAJESTIC_PIXIES"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 200))
            .instability(7)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.MAJESTIC_HALLOWED_PIXIE.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_HALLOWED.get())
            .addIngredient(Tags.Items.INGOTS_GOLD)
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_CREATURE.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MAJESTIC_PIXIES"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 200))
            .instability(7)
            .build(consumer);
    }

    protected void registerAmbrosiaRecipes(Consumer<FinishedRecipe> consumer) {
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_EARTH_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AMBROSIA")))
            .manaCost(new SourceList().add(Source.EARTH, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SEA_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AMBROSIA")))
            .manaCost(new SourceList().add(Source.SEA, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SKY_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AMBROSIA")))
            .manaCost(new SourceList().add(Source.SKY, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_SUN_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AMBROSIA")))
            .manaCost(new SourceList().add(Source.SUN, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_MOON_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("AMBROSIA")))
            .manaCost(new SourceList().add(Source.MOON, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_BLOOD_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("AMBROSIA"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_INFERNAL_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("AMBROSIA"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_VOID_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("AMBROSIA"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.BASIC_HALLOWED_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_HALLOWED.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("AMBROSIA"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 40))
            .instability(4)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_EARTH_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GREATER_AMBROSIA")))
            .manaCost(new SourceList().add(Source.EARTH, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_SEA_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GREATER_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SEA, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_SKY_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GREATER_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SKY, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_SUN_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GREATER_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SUN, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_MOON_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("GREATER_AMBROSIA")))
            .manaCost(new SourceList().add(Source.MOON, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_BLOOD_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GREATER_AMBROSIA"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_INFERNAL_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GREATER_AMBROSIA"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_VOID_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GREATER_AMBROSIA"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.GREATER_HALLOWED_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES, 2)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("GREATER_AMBROSIA"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 100))
            .instability(6)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_EARTH_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_EARTH.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_AMBROSIA")))
            .manaCost(new SourceList().add(Source.EARTH, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_SEA_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SEA.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SEA, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_SKY_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SKY.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SKY, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_SUN_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_SUN.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_AMBROSIA")))
            .manaCost(new SourceList().add(Source.SUN, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_MOON_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_MOON.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SUPREME_AMBROSIA")))
            .manaCost(new SourceList().add(Source.MOON, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_BLOOD_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_BLOOD.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("SUPREME_AMBROSIA"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_INFERNAL_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_INFERNAL.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("SUPREME_AMBROSIA"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_VOID_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_VOID.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("SUPREME_AMBROSIA"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 200))
            .instability(8)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SUPREME_HALLOWED_AMBROSIA.get())
            .addIngredient(ItemsPM.MANAFRUIT.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.ESSENCE_CLUSTER_HALLOWED.get())
            .addIngredient(ItemsPM.RUNE_ABSORB.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES, 3)
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get())
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("SUPREME_AMBROSIA"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 200))
            .instability(8)
            .build(consumer);
    }
    
    protected void registerSanguineCrucibleRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SANGUINE_CRUCIBLE.get())
            .patternLine("ICI")
            .patternLine("IWI")
            .patternLine("III")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('C', ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .key('W', Items.WATER_BUCKET)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CRUCIBLE")))
            .manaCost(new SourceList().add(Source.BLOOD, 100).add(Source.INFERNAL, 100))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SANGUINE_CORE_BLANK.get())
            .patternLine(" H ")
            .patternLine("BIB")
            .patternLine("H H")
            .key('H', ItemTagsPM.INGOTS_HEXIUM)
            .key('B', ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .key('I', ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CRUCIBLE")))
            .manaCost(new SourceList().add(Source.BLOOD, 50).add(Source.INFERNAL, 50))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_AXOLOTL.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.TROPICAL_FISH_BUCKET)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_BAT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.FEATHERS)
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_FLYING_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_BEE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemTags.SMALL_FLOWERS)
            .addIngredient(Items.HONEYCOMB)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_FLYING_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_BLAZE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.RODS_BLAZE)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_CAT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemTags.FISHES)
            .addIngredient(Tags.Items.STRING)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_CAVE_SPIDER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SPIDER_EYE)
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_CHICKEN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.FEATHERS)
            .addIngredient(Tags.Items.EGGS)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_FLYING_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_COD.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.COD)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_COW.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.BEEF)
            .addIngredient(Tags.Items.LEATHER)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_CREEPER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.GUNPOWDER)
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_PLANTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_DOLPHIN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.COD)
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_DONKEY.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SADDLE)
            .addIngredient(Tags.Items.CHESTS_WOODEN)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_DROWNED.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ELDER_GUARDIAN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.DUSTS_PRISMARINE)
            .addIngredient(Items.SPONGE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ENDERMAN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.ENDER_PEARLS)
            .addIngredient(ItemsPM.ESSENCE_DUST_VOID.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_ALIENS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ENDERMITE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.ENDER_PEARLS)
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_ALIENS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_EVOKER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .addIngredient(Items.TOTEM_OF_UNDYING)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SAPIENTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_FOX.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.LEATHER)
            .addIngredient(Items.SWEET_BERRIES)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_GHAST.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_GLOW_SQUID.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.GLOW_INK_SAC)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_GOAT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.MILK_BUCKET)
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_GUARDIAN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.DUSTS_PRISMARINE)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_HOGLIN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.PORKCHOP)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_HORSE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SADDLE)
            .addIngredient(Items.APPLE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_HUSK.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_LLAMA.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.LEATHER)
            .addIngredient(ItemTags.CARPETS)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_MAGMA_CUBE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.MAGMA_CREAM)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_MOOSHROOM.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.BEEF)
            .addIngredient(Tags.Items.MUSHROOMS)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_PLANTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_OCELOT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemTags.FISHES)
            .addIngredient(Items.VINE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PANDA.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.BAMBOO)
            .addIngredient(Items.VINE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PARROT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.FEATHERS)
            .addIngredient(Items.VINE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_FLYING_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PHANTOM.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PIG.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.PORKCHOP)
            .addIngredient(Tags.Items.CROPS_CARROT)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PIGLIN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.GOLDEN_SWORD)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PIGLIN_BRUTE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.GOLDEN_AXE)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PILLAGER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .addIngredient(Items.CROSSBOW)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SAPIENTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_POLAR_BEAR.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.COD)
            .addIngredient(Items.ICE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_PUFFERFISH.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.PUFFERFISH)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_RABBIT.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.RABBIT)
            .addIngredient(Items.RABBIT_HIDE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_RAVAGER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SADDLE)
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SALMON.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SALMON)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SHEEP.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.MUTTON)
            .addIngredient(ItemTags.WOOL)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SHULKER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SHULKER_SHELL)
            .addIngredient(ItemsPM.ESSENCE_DUST_VOID.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_ALIENS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SILVERFISH.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.STONE)
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SKELETON.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.BONES)
            .addIngredient(Items.BOW)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SKELETON_HORSE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.BONES)
            .addIngredient(Items.SADDLE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SLIME.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.SLIMEBALLS)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SPIDER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SPIDER_EYE)
            .addIngredient(Tags.Items.STRING)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_SQUID.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.INK_SAC)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_STRAY.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.BONES)
            .addIngredient(Items.ICE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_STRIDER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SADDLE)
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_DEMONS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_TROPICAL_FISH.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.TROPICAL_FISH)
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_TURTLE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.SCUTE)
            .addIngredient(Items.SEAGRASS)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SEA_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_VEX.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.FEATHERS)
            .addIngredient(Items.IRON_SWORD)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_FLYING_CREATURES")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_VILLAGER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .addIngredient(Tags.Items.GEMS_EMERALD)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SAPIENTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_VINDICATOR.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .addIngredient(Items.IRON_AXE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SAPIENTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_WITCH.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.BLOODY_FLESH.get())
            .addIngredient(Items.GLASS_BOTTLE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_SAPIENTS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_WITHER_SKELETON.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.BONES)
            .addIngredient(Items.WITHER_SKELETON_SKULL)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_WOLF.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.BONES)
            .addIngredient(Items.BEEF)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_LAND_ANIMALS")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ZOGLIN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(Items.PORKCHOP)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ZOMBIE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ZOMBIE_HORSE.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(Items.SADDLE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ZOMBIE_VILLAGER.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(Tags.Items.GEMS_EMERALD)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_ZOMBIFIED_PIGLIN.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Items.ROTTEN_FLESH)
            .addIngredient(Items.GOLDEN_SWORD)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_UNDEAD")))
            .build(consumer);
        ArcaneShapelessRecipeBuilder.arcaneShapelessRecipe(ItemsPM.SANGUINE_CORE_TREEFOLK.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(ItemsPM.HEARTWOOD.get())
            .addIngredient(Items.APPLE)
            .setGroup("attuned_sanguine_cores")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SANGUINE_CORE_PLANTS")))
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SANGUINE_CORE_INNER_DEMON.get())
            .addIngredient(ItemsPM.SANGUINE_CORE_BLANK.get())
            .addIngredient(Tags.Items.NETHER_STARS)
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .addIngredient(ItemsPM.RUNE_SUMMON.get())
            .addIngredient(ItemsPM.RUNE_SELF.get())
            .addIngredient(ItemsPM.RUNE_POWER.get(), 2)
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CLEANSING_RITE")))
            .manaCost(new SourceList().add(Source.BLOOD, 100).add(Source.INFERNAL, 100).add(Source.VOID, 100))
            .instability(7)
            .build(consumer);
    }
    
    protected void registerTinctureRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SKYGLASS_FLASK.get(), 3)
            .patternLine("# #")
            .patternLine(" # ")
            .key('#', ItemsPM.SKYGLASS.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.CONCOCTER.get())
            .patternLine("CPC")
            .patternLine("PBP")
            .patternLine("MMM")
            .key('C', Tags.Items.INGOTS_COPPER)
            .key('P', ItemsPM.MAGITECH_PARTS_ENCHANTED.get())
            .key('B', Items.BREWING_STAND)
            .key('M', ItemsPM.MARBLE_ENCHANTED.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 40))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.NIGHT_VISION, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_NIGHT_VISION, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.INVISIBILITY, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_INVISIBILITY, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LEAPING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_LEAPING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_LEAPING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.FIRE_RESISTANCE, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_FIRE_RESISTANCE, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SWIFTNESS, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SWIFTNESS, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_SWIFTNESS, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.TURTLE_MASTER, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_TURTLE_MASTER, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_TURTLE_MASTER, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.WATER_BREATHING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_WATER_BREATHING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.HEALING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_HEALING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.REGENERATION, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_REGENERATION, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_REGENERATION, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_DUST_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_TINCTURES"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRENGTH, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_STRENGTH, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_STRENGTH, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SLOW_FALLING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SLOW_FALLING, ConcoctionType.TINCTURE))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_DUST_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_TINCTURES")))
            .manaCost(new SourceList().add(Source.INFERNAL, 1))
            .build(consumer);
    }
    
    protected void registerPhilterRecipes(Consumer<FinishedRecipe> consumer) {
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.NIGHT_VISION, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_NIGHT_VISION, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.INVISIBILITY, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_INVISIBILITY, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LEAPING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_LEAPING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_LEAPING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.FIRE_RESISTANCE, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_FIRE_RESISTANCE, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SWIFTNESS, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SWIFTNESS, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_SWIFTNESS, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.TURTLE_MASTER, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_TURTLE_MASTER, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_TURTLE_MASTER, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.WATER_BREATHING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_WATER_BREATHING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.HEALING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_HEALING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.REGENERATION, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_REGENERATION, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_REGENERATION, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_PHILTERS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRENGTH, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_STRENGTH, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_STRENGTH, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SLOW_FALLING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SLOW_FALLING, ConcoctionType.PHILTER))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_PHILTERS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
    }
    
    protected void registerElixirRecipes(Consumer<FinishedRecipe> consumer) {
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.NIGHT_VISION, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_NIGHT_VISION, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.INVISIBILITY, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_INVISIBILITY, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LEAPING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_LEAPING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_LEAPING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.FIRE_RESISTANCE, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_FIRE_RESISTANCE, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SWIFTNESS, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SWIFTNESS, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_SWIFTNESS, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.TURTLE_MASTER, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_TURTLE_MASTER, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_TURTLE_MASTER, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.WATER_BREATHING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_WATER_BREATHING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.HEALING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_HEALING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.REGENERATION, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_REGENERATION, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_REGENERATION, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_ELIXIRS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRENGTH, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_STRENGTH, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.STRONG_STRENGTH, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.SLOW_FALLING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newConcoction(Potions.LONG_SLOW_FALLING, ConcoctionType.ELIXIR))
            .addIngredient(ConcoctionUtils.newConcoction(Potions.WATER, ConcoctionType.WATER))
            .addIngredient(ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .useDefaultGroup()
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_ELIXIRS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 9))
            .build(consumer);
    }
    
    protected void registerAlchemicalBombRecipes(Consumer<FinishedRecipe> consumer) {
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.NIGHT_VISION, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_NIGHT_VISION, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.INVISIBILITY, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_INVISIBILITY, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GOLDEN_CARROT)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LEAPING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_LEAPING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_LEAPING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.RABBIT_FOOT)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.FIRE_RESISTANCE, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_FIRE_RESISTANCE, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.MAGMA_CREAM)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.SWIFTNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_SWIFTNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_SWIFTNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.TURTLE_MASTER, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_TURTLE_MASTER, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_TURTLE_MASTER, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.TURTLE_HELMET)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.WATER_BREATHING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_WATER_BREATHING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PUFFERFISH)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.HEALING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_HEALING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.REGENERATION, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_REGENERATION, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_REGENERATION, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GHAST_TEAR)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRENGTH, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_STRENGTH, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_STRENGTH, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.BLAZE_POWDER)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.SLOW_FALLING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_SLOW_FALLING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.PHANTOM_MEMBRANE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("CONCOCTING_BOMBS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.SLOWNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_SLOWNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_SLOWNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SUGAR)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.HARMING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_HARMING, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.GLISTERING_MELON_SLICE)
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.POISON, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SPIDER_EYE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_POISON, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.STRONG_POISON, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .addIngredient(Tags.Items.CROPS_NETHER_WART)
            .addIngredient(Items.SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_GLOWSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.WEAKNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
        ConcoctingRecipeBuilder.concoctingRecipe(ConcoctionUtils.newBomb(Potions.LONG_WEAKNESS, FuseType.MEDIUM))
            .addIngredient(ConcoctionUtils.newBomb(Potions.WATER, FuseType.MEDIUM))
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get())
            .addIngredient(Items.FERMENTED_SPIDER_EYE)
            .addIngredient(Tags.Items.DUSTS_REDSTONE)
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("CONCOCTING_BOMBS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 3))
            .build(consumer);
    }
    
    protected void registerClothRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCLOTH.get())
            .patternLine("ESE")
            .patternLine(" C ")
            .patternLine("ESE")
            .key('E', ItemTagsPM.ESSENCES_TERRESTRIAL_DUSTS)
            .key('S', Tags.Items.STRING)
            .key('C', ItemTags.WOOL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SPELLCLOTH")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXWEAVE.get())
            .patternLine("ESE")
            .patternLine(" C ")
            .patternLine("ESE")
            .key('E', ItemTagsPM.ESSENCES_FORBIDDEN_SHARDS)
            .key('S', Tags.Items.STRING)
            .key('C', ItemsPM.SPELLCLOTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXWEAVE")))
            .manaCost(new SourceList().add(Source.BLOOD, 20).add(Source.INFERNAL, 20).add(Source.VOID, 20))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SAINTSWOOL.get())
            .patternLine("ESE")
            .patternLine(" C ")
            .patternLine("ESE")
            .key('E', ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())
            .key('S', Tags.Items.STRING)
            .key('C', ItemsPM.HEXWEAVE.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SAINTSWOOL")))
            .manaCost(new SourceList().add(Source.HALLOWED, 50))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.IMBUED_WOOL_HEAD.get())
            .patternLine("###")
            .patternLine("# #")
            .key('#', ItemTags.WOOL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("IMBUED_WOOL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.IMBUED_WOOL_CHEST.get())
            .patternLine("# #")
            .patternLine("###")
            .patternLine("###")
            .key('#', ItemTags.WOOL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("IMBUED_WOOL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.IMBUED_WOOL_LEGS.get())
            .patternLine("###")
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemTags.WOOL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("IMBUED_WOOL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.IMBUED_WOOL_FEET.get())
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemTags.WOOL)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("IMBUED_WOOL")))
            .manaCost(new SourceList().add(Source.EARTH, 5).add(Source.SEA, 5).add(Source.SKY, 5).add(Source.SUN, 5).add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCLOTH_HEAD.get())
            .patternLine("###")
            .patternLine("# #")
            .key('#', ItemsPM.SPELLCLOTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SPELLCLOTH")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCLOTH_CHEST.get())
            .patternLine("# #")
            .patternLine("###")
            .patternLine("###")
            .key('#', ItemsPM.SPELLCLOTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SPELLCLOTH")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCLOTH_LEGS.get())
            .patternLine("###")
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.SPELLCLOTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SPELLCLOTH")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SPELLCLOTH_FEET.get())
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.SPELLCLOTH.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SPELLCLOTH")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXWEAVE_HEAD.get())
            .patternLine("###")
            .patternLine("# #")
            .key('#', ItemsPM.HEXWEAVE.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXWEAVE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXWEAVE_CHEST.get())
            .patternLine("# #")
            .patternLine("###")
            .patternLine("###")
            .key('#', ItemsPM.HEXWEAVE.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXWEAVE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXWEAVE_LEGS.get())
            .patternLine("###")
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.HEXWEAVE.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXWEAVE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEXWEAVE_FEET.get())
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.HEXWEAVE.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEXWEAVE")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SAINTSWOOL_HEAD.get())
            .patternLine("###")
            .patternLine("# #")
            .key('#', ItemsPM.SAINTSWOOL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SAINTSWOOL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SAINTSWOOL_CHEST.get())
            .patternLine("# #")
            .patternLine("###")
            .patternLine("###")
            .key('#', ItemsPM.SAINTSWOOL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SAINTSWOOL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SAINTSWOOL_LEGS.get())
            .patternLine("###")
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.SAINTSWOOL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SAINTSWOOL")))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.SAINTSWOOL_FEET.get())
            .patternLine("# #")
            .patternLine("# #")
            .key('#', ItemsPM.SAINTSWOOL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SAINTSWOOL")))
            .build(consumer);
    }
    
    protected void registerPrimalToolRecipes(Consumer<FinishedRecipe> consumer) {
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_SHOVEL.get().getDefaultInstance())
            .addIngredient(ItemsPM.PRIMALITE_SHOVEL.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_EARTH.get(), 2)
            .addIngredient(ItemsPM.RUNE_EARTH.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.RITUAL_BELL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMAL_SHOVEL")))
            .manaCost(new SourceList().add(Source.EARTH, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_FISHING_ROD.get().getDefaultInstance())
            .addIngredient(ItemsPM.PRIMALITE_FISHING_ROD.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SEA.get(), 2)
            .addIngredient(ItemsPM.RUNE_SEA.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMAL_FISHING_ROD")))
            .manaCost(new SourceList().add(Source.SEA, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_AXE.get().getDefaultInstance())
            .addIngredient(ItemsPM.PRIMALITE_AXE.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SKY.get(), 2)
            .addIngredient(ItemsPM.RUNE_SKY.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_BELL.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMAL_AXE")))
            .manaCost(new SourceList().add(Source.SKY, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_HOE.get().getDefaultInstance())
            .addIngredient(ItemsPM.PRIMALITE_HOE.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_SUN.get(), 2)
            .addIngredient(ItemsPM.RUNE_SUN.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlockTagsPM.RITUAL_CANDLES)
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMAL_HOE")))
            .manaCost(new SourceList().add(Source.SUN, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.PRIMAL_PICKAXE.get().getDefaultInstance())
            .addIngredient(ItemsPM.PRIMALITE_PICKAXE.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_MOON.get(), 2)
            .addIngredient(ItemsPM.RUNE_MOON.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.RITUAL_LECTERN.get())
            .addProp(BlocksPM.INCENSE_BRAZIER.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("PRIMAL_PICKAXE")))
            .manaCost(new SourceList().add(Source.MOON, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.FORBIDDEN_TRIDENT.get().getDefaultInstance())
            .addIngredient(ItemsPM.HEXIUM_TRIDENT.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_BLOOD.get(), 2)
            .addIngredient(ItemsPM.RUNE_BLOOD.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.BLOODLETTER.get(), 2)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_TRIDENT")))
            .manaCost(new SourceList().add(Source.BLOOD, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.FORBIDDEN_BOW.get().getDefaultInstance())
            .addIngredient(ItemsPM.HEXIUM_BOW.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_INFERNAL.get(), 2)
            .addIngredient(ItemsPM.RUNE_INFERNAL.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.SOUL_ANVIL.get(), 2)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_BOW")))
            .manaCost(new SourceList().add(Source.INFERNAL, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.FORBIDDEN_SWORD.get().getDefaultInstance())
            .addIngredient(ItemsPM.HEXIUM_SWORD.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_VOID.get(), 2)
            .addIngredient(ItemsPM.RUNE_VOID.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.BLOODLETTER.get())
            .addProp(BlocksPM.SOUL_ANVIL.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_SWORD")))
            .manaCost(new SourceList().add(Source.VOID, 40))
            .instability(3)
            .build(consumer);
        RitualRecipeBuilder.ritualRecipe(ItemsPM.SACRED_SHIELD.get().getDefaultInstance())
            .addIngredient(ItemsPM.HALLOWSTEEL_SHIELD.get())
            .addIngredient(ItemsPM.ESSENCE_SHARD_HALLOWED.get(), 2)
            .addIngredient(ItemsPM.RUNE_HALLOWED.get())
            .addIngredient(ItemsPM.MANA_PRISM.get())
            .addIngredient(ItemsPM.MANA_SALTS.get())
            .addProp(BlocksPM.CELESTIAL_HARP.get(), 2)
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("SACRED_SHIELD")))
            .manaCost(new SourceList().add(Source.HALLOWED, 40))
            .instability(3)
            .build(consumer);
    }
    
    protected void registerManaFontRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_EARTH.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_EARTH.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.EARTH, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_SEA.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_SEA.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SEA, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_SKY.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_SKY.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SKY, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_SUN.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_SUN.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SUN, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_MOON.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_MOON.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.MOON, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_BLOOD.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_BLOOD.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_INFERNAL.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_INFERNAL.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_VOID.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_VOID.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.ARTIFICIAL_FONT_HALLOWED.get())
            .patternLine("IMI")
            .patternLine(" E ")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_PRIMALITE)
            .key('M', ItemsPM.MARBLE_ENCHANTED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_SHARD_HALLOWED.get())
            .setGroup("artificial_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("ARTIFICIAL_MANA_FONTS"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 250))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_EARTH.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_EARTH.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_EARTH.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.EARTH, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_SEA.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_SEA.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_SEA.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SEA, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_SKY.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_SKY.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_SKY.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SKY, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_SUN.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_SUN.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_SUN.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SUN, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_MOON.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_MOON.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_MOON.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.MOON, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_BLOOD.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_BLOOD.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_BLOOD.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_INFERNAL.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_INFERNAL.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_INFERNAL.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_VOID.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_VOID.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_VOID.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.FORBIDDEN_FONT_HALLOWED.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HEXIUM)
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CRYSTAL_HALLOWED.get())
            .key('F', ItemsPM.ARTIFICIAL_FONT_HALLOWED.get())
            .setGroup("forbidden_mana_fonts")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("FORBIDDEN_MANA_FONTS"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 750))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_EARTH.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_EARTH.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_EARTH.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.EARTH, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_SEA.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_SEA.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_SEA.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SEA, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_SKY.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_SKY.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_SKY.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SKY, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_SUN.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_SUN.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_SUN.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.SUN, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_MOON.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_MOON.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_MOON.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.MOON, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_BLOOD.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_BLOOD.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_BLOOD.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.BLOOD, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_INFERNAL.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_INFERNAL.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_INFERNAL.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.INFERNAL, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_VOID.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_VOID.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_VOID.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.VOID, 2500))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.HEAVENLY_FONT_HALLOWED.get())
            .patternLine("IMI")
            .patternLine("EFE")
            .patternLine("IMI")
            .key('I', ItemTagsPM.INGOTS_HALLOWSTEEL)
            .key('M', ItemsPM.MARBLE_HALLOWED_SLAB.get())
            .key('E', ItemsPM.ESSENCE_CLUSTER_HALLOWED.get())
            .key('F', ItemsPM.FORBIDDEN_FONT_HALLOWED.get())
            .setGroup("heavenly_mana_fonts")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("HEAVENLY_MANA_FONTS")))
            .manaCost(new SourceList().add(Source.HALLOWED, 2500))
            .build(consumer);
    }
    
    protected void registerManaArrowRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_EARTH.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_EARTH.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_ARROWS")))
            .manaCost(new SourceList().add(Source.EARTH, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_SEA.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_SEA.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_ARROWS")))
            .manaCost(new SourceList().add(Source.SEA, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_SKY.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_SKY.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_ARROWS")))
            .manaCost(new SourceList().add(Source.SKY, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_SUN.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_SUN.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_ARROWS")))
            .manaCost(new SourceList().add(Source.SUN, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_MOON.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_MOON.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("MANA_ARROWS")))
            .manaCost(new SourceList().add(Source.MOON, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_BLOOD.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_BLOOD.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MANA_ARROWS"), Source.BLOOD.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.BLOOD, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_INFERNAL.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_INFERNAL.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MANA_ARROWS"), Source.INFERNAL.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.INFERNAL, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_VOID.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_VOID.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MANA_ARROWS"), Source.VOID.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.VOID, 5))
            .build(consumer);
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.MANA_ARROW_HALLOWED.get(), 4)
            .patternLine(" A ")
            .patternLine("ADA")
            .patternLine(" A ")
            .key('A', Items.ARROW)
            .key('D', ItemsPM.ESSENCE_DUST_HALLOWED.get())
            .setGroup("mana_arrows")
            .research(CompoundResearchKey.from(true, SimpleResearchKey.parse("MANA_ARROWS"), Source.HALLOWED.getDiscoverKey()))
            .manaCost(new SourceList().add(Source.HALLOWED, 5))
            .build(consumer);
    }
    
    protected void registerDissolutionChamberRecipes(Consumer<FinishedRecipe> consumer) {
        ArcaneShapedRecipeBuilder.arcaneShapedRecipe(ItemsPM.DISSOLUTION_CHAMBER.get())
            .patternLine("DDD")
            .patternLine("DHD")
            .patternLine("MPM")
            .key('D', Tags.Items.GEMS_DIAMOND)
            .key('H', ItemsPM.EARTHSHATTER_HAMMER.get())
            .key('M', ItemsPM.MARBLE_SMOKED_SLAB.get())
            .key('P', ItemsPM.MAGITECH_PARTS_FORBIDDEN.get())
            .research(CompoundResearchKey.from(SimpleResearchKey.parse("DISSOLUTION_CHAMBER")))
            .manaCost(new SourceList().add(Source.EARTH, 100))
            .build(consumer);
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.IRON_GRIT.get(), 3)
            .ingredient(Tags.Items.ORES_IRON)
            .setGroup("iron_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_grit_from_dissolving_ore"));
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.IRON_GRIT.get(), 3)
            .ingredient(Tags.Items.RAW_MATERIALS_IRON)
            .setGroup("iron_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "iron_grit_from_dissolving_raw_metal"));
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.GOLD_GRIT.get(), 3)
            .ingredient(Tags.Items.ORES_GOLD)
            .setGroup("gold_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_grit_from_dissolving_ore"));
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.GOLD_GRIT.get(), 3)
            .ingredient(Tags.Items.RAW_MATERIALS_GOLD)
            .setGroup("gold_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "gold_grit_from_dissolving_raw_metal"));
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.COPPER_GRIT.get(), 3)
            .ingredient(Tags.Items.ORES_COPPER)
            .setGroup("copper_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_grit_from_dissolving_ore"));
        DissolutionRecipeBuilder.dissolutionRecipe(ItemsPM.COPPER_GRIT.get(), 3)
            .ingredient(Tags.Items.RAW_MATERIALS_COPPER)
            .setGroup("copper_grit_dissolution")
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "copper_grit_from_dissolving_raw_metal"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.COBBLESTONE, 2)
            .ingredient(Tags.Items.STONE)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "cobblestone_from_dissolving_stone"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.GRAVEL, 2)
            .ingredient(Tags.Items.COBBLESTONE)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "gravel_from_dissolving_cobblestone"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.SAND, 2)
            .ingredient(Tags.Items.GRAVEL)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "sand_from_dissolving_gravel"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.BONE_MEAL, 6)
            .ingredient(Tags.Items.BONES)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "bone_meal_from_dissolving_bone"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.BLAZE_POWDER, 4)
            .ingredient(Tags.Items.RODS_BLAZE)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "blaze_powder_from_dissolving_blaze_rod"));
        DissolutionRecipeBuilder.dissolutionRecipe(Items.STRING, 9)
            .ingredient(ItemTags.WOOL)
            .manaCost(new SourceList().add(Source.EARTH, 1))
            .build(consumer, new ResourceLocation(PrimalMagick.MODID, "string_from_dissolving_wool"));
    }
}
